﻿// <著作権>
// Copyright (c) 2007, NTT DATA Corporation.
using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using TERASOLUNA.Fw.Common.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Utlib.Logging;

namespace TERASOLUNA.Fw.CommonUT.Validation.Validators
{
    /// <summary>
    /// IntRangeValidatorTest のテストクラスです。
    /// </summary>
    [TestClass]

    public class IntRangeValidatorTest
    {
        #region 追加テスト属性
        //
        // テストを作成しているときに、次の追加属性を使用することができます:
        //
        // クラス内の最初のテストを実行する前にコードを実行するには、ClassInitialize を使用します
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // クラス内のすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用します
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // 各テストを実行する前にコードを実行するには、TestInitialize を使用します 
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        // 各テストを実行した後にコードを実行するには、TestCleanup を使用します
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest01()
        {
            IntRangeValidator target = 
                new IntRangeValidator(0, RangeBoundaryType.Ignore, 
                                      10, RangeBoundaryType.Exclusive,
                                      null,
                                      true);

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_RANGE_VALIDATOR_NEGATED_IG_EX_MESSAGETEMPLATE", placeHolder);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_IntRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_IntRangeValidatorAccessor(target);


            Assert.AreEqual<string>(val, accessor.DefaultNegatedMessageTemplate, "プロパティの値が不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(IntRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest01()
        {
            IntRangeValidator target =
                new IntRangeValidator(0, RangeBoundaryType.Ignore,
                                      10, RangeBoundaryType.Exclusive,
                                      null,
                                      false);

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_RANGE_VALIDATOR_NONNEGATED_IG_EX_MESSAGETEMPLATE", placeHolder);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_IntRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_IntRangeValidatorAccessor(target);


            Assert.AreEqual<string>(val, accessor.DefaultNonNegatedMessageTemplate, "プロパティの値が不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(IntRangeValidator), LogLevel.INFO));      
        }       
    }
}
