﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using TERASOLUNA.Fw.Common;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Validation.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using System.Reflection;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Validation.Validators;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Configuration
{
    /// <summary>
    /// StringLengthRangeValidatorData のテストクラスです
    /// </summary>
    [TestClass()]
    public class StringLengthRangeValidatorDataTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// 引数のTypeがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest01()
        {
            // 準備
            Type targetType = null;
            StringLengthRangeValidatorData target 
                = new StringLengthRangeValidatorData();     
            
            target.LowerBound = 3;
            target.UpperBound = 6;
            target.LowerBoundType = RangeBoundaryType.Inclusive;
            target.UpperBoundType = RangeBoundaryType.Exclusive;
            target.MessageTemplate = "TERASOLUNA";
            target.Negated = true;
            CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_StringLengthRangeValidatorDataAccessor accessor 
                = new CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_StringLengthRangeValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 検証
            Assert.IsInstanceOfType(result, typeof(StringLengthRangeValidator), "型が不正です");
            StringLengthRangeValidator irv = result as StringLengthRangeValidator;
            Assert.AreEqual<string>("TERASOLUNA", irv.MessageTemplate, "メッセージテンプレートが不正です.");
            Assert.IsTrue(irv.Negated, "Negatedが不正です.");
            
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// 引数のTypeが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest02()
        {
            // 準備
            StringLengthRangeValidatorData target 
                = new StringLengthRangeValidatorData();
            Type targetType = typeof(StringLengthRangeValidatorData);        
            
            target.LowerBound = 3;
            target.UpperBound = 6;
            target.LowerBoundType = RangeBoundaryType.Inclusive;
            target.UpperBoundType = RangeBoundaryType.Exclusive;
            target.MessageTemplate = "TERASOLUNA";
            target.Negated = true;
            CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_StringLengthRangeValidatorDataAccessor accessor 
                = new CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_StringLengthRangeValidatorDataAccessor(target);

            // 実施
            Validator result = accessor.DoCreateValidator(targetType);

            // 検証
            Assert.IsInstanceOfType(result, typeof(StringLengthRangeValidator), "型が不正です");
            StringLengthRangeValidator irv = result as StringLengthRangeValidator;
            Assert.AreEqual<string>("TERASOLUNA", irv.MessageTemplate, "メッセージテンプレートが不正です.");
            Assert.IsTrue(irv.Negated, "Negatedが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidatorData), LogLevel.INFO));
        }
    }
}
