﻿using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Common.Logging.TraceSourceLog;

namespace TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog
{
    class TraceSourceLogFactory_Stub01 : TraceSourceLogFactory
    {
        public string _className = null;
        public string _sourceName = null;
        public Type _classType = null;

        public IDictionary<string, ITraceSourceLog> LoggersStub
        {
            get
            {
                return Loggers;
            }
        }

        /// <summary>
        /// <see cref="TraceSourceLogger"/> インスタンスを生成します。
        /// </summary>
        /// <param name="className">生成するインスタンスの型文字列。</param>
        /// <param name="sourceName"><see cref="TraceSourceLogger"/> クラスのコンストラクタに引数として与える
        /// トレースソースの名前。</param>
        /// <returns><see cref="TraceSourceLogger"/> インスタンス。</returns>
        protected override ITraceSourceLog CreateTraceSourceLoggerByName(string className, string sourceName)
        {
            _className = className;
            _sourceName = sourceName;

            ITraceSourceLog result = new TraceSourceLogger(className, sourceName);
            return result;
        }

        /// <summary>
        /// <see cref="TraceSourceLogger"/> インスタンスを生成します。
        /// </summary>
        /// <param name="classType">生成するインスタンスの型文字列。</param>
        /// <param name="sourceName"><see cref="TraceSourceLogger"/> クラスのコンストラクタに引数として与える
        /// トレースソースの名前。</param>
        /// <returns><see cref="TraceSourceLogger"/> インスタンス。</returns>
        protected override ITraceSourceLog CreateTraceSourceLoggerByType(Type classType, string sourceName)
        {
            _classType = classType;
            _sourceName = sourceName;

            ITraceSourceLog result = new TraceSourceLogger(classType, sourceName);
            return result;
        }

    }
}
