﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Logging.TraceSourceLog;
using TERASOLUNA.Fw.Common.Logging;
using System.Configuration;
namespace TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog
{
    /// <summary>
    /// TraceSourceLogFactory のテストクラスです。
    /// </summary>
    [TestClass()]
    public class TraceSourceLogFactoryTest
    {
        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = 
                "TERASOLUNA.Fw.Common.Logging.TraceSourceLog.TraceSourceLogFactory, TERASOLUNA.Fw.Common";
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        [TestCleanup()]
        public void MyTestCleanup()
        {
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = 
                "TERASOLUNA.Fw.Utlib.Logging.LogUTFactory, TERASOLUNA.Fw.Utlib";

            TERASOLUNA.Fw.Utlib.Logging.LogUTFactory logFactory = new TERASOLUNA.Fw.Utlib.Logging.LogUTFactory();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;
        }
        
        #endregion

        #region GetLogger<T>(string, params object[]) のテスト

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest01()
        {
            // 準備
            string className = null;
            object[] args = { "sourceName" };

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className, args);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: className", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 空文字列の場合、
        /// ArgumentException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest02()
        {
            // 準備
            string className = string.Empty;
            object[] args = { "sourceName" };

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className, args);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual("引数 \"className\" の値を空文字列にすることはできません。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// className と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 0 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest03()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();        
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest04()
        {
            // 準備
            string className = "className";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(className, null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 0 の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest05()
        {
            // 準備
            string className = "className";

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 1 で args[0]=null の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest06()
        {
            // 準備
            string className = "className";
            object[] args = { null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 1 で args[0] の文字列変換後の
        /// 文字列長が 0 の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest07()
        {
            // 準備
            string className = "className";
            object[] args = { string.Empty };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 3 で
        /// args[0]=args[1]=args[2]=null の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest08()
        {
            // 準備
            string className = "className";
            object[] args = { null, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 3 で args[0] の文字列変換後の
        /// 文字列長が 0、args[1]=args[2]=null の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest09()
        {
            // 準備
            string className = "className";
            object[] args = { string.Empty, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 3 で args[0] の文字列変換後の
        /// 文字列長が 0 でなく、args[1]=args[2]=null の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest10()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName", null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// className と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 1 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest11()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01","sourceName01"));
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(2, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// className と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 3 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest12()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01","sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("className02","sourceName02"));
            logFactory.LoggersStub.Add("dummyKey03", new TraceSourceLogger("className03","sourceName03"));
            
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(4, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// className と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在し、
        /// Dictionaryの要素数が 1 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest13()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            
            logFactory.LoggersStub.Clear();
            TraceSourceLogger chacheLogger = new TraceSourceLogger("className","sourceName");
            logFactory.LoggersStub.Add("className:sourceName", chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreSame(chacheLogger, logger);
            Assert.IsNull(logFactory._className);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// className と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在し、
        /// Dictionaryの要素数が 3 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest14()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("className02", "sourceName02"));
            TraceSourceLogger chacheLogger = new TraceSourceLogger("className", "sourceName");
            logFactory.LoggersStub.Add("className:sourceName", chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(3, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreSame(chacheLogger, logger);
            Assert.IsNull(logFactory._className);
            Assert.IsNull(logFactory._sourceName);
        }

        #endregion

        #region GetLogger<T>(Type, params object[]) のテスト

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest01()
        {
            // 準備
            Type classType = null;
            object[] args = { "sourceName" };

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType, args);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: classType", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// classType と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 0 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest02()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest03()
        {
            // 準備
            Type classType = typeof(Object);

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger<ILog>(classType, null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 0 の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest04()
        {
            // 準備
            Type classType = typeof(Object);

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 1 で args[0]=null の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest05()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 1 で args[0] の文字列変換後の
        /// 文字列長が 0 の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest06()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { string.Empty };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 3 で
        /// args[0]=args[1]=args[2]=null の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest07()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { null, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 3 で args[0] の文字列変換後の
        /// 文字列長が 0、args[1]=args[2]=null の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest08()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { string.Empty, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 3 で args[0] の文字列変換後の
        /// 文字列長が 0 でなく、args[1]=args[2]=null の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest09()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName", null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// classType と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 1 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest10()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(2, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// classType と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 3 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest11()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("classType02", "sourceName02"));
            logFactory.LoggersStub.Add("dummyKey03", new TraceSourceLogger("classType03", "sourceName03"));

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(4, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// classType と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在し、
        /// Dictionaryの要素数が 1 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest12()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            TraceSourceLogger chacheLogger = new TraceSourceLogger(typeof(Object), "sourceName");
            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            logFactory.LoggersStub.Add(key, chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(chacheLogger, logger);

            Assert.IsNull(logFactory._classType);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// classType と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在し、
        /// Dictionaryの要素数が 3 個の場合、
        /// TraceSourceLogger のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest13()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("classType02", "sourceName02"));
            TraceSourceLogger chacheLogger = new TraceSourceLogger(typeof(Object), "sourceName");
            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            logFactory.LoggersStub.Add(key, chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(3, logFactory.LoggersStub.Count);

            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(chacheLogger, logger);

            Assert.IsNull(logFactory._classType);
            Assert.IsNull(logFactory._sourceName);
        }

        #endregion

        #region GetLogger(string, params object[]) のテスト

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest01()
        {
            // 準備
            string className = null;
            object[] args = { "sourceName" };

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className, args);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: className", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 空文字列の場合、
        /// ArgumentException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest02()
        {
            // 準備
            string className = string.Empty;
            object[] args = { "sourceName" };

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className, args);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual("引数 \"className\" の値を空文字列にすることはできません。", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// className と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 0 個の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest03()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest04()
        {
            // 準備
            string className = "className";

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(className, null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 0 の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest05()
        {
            // 準備
            string className = "className";

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 1 で args[0]=null の場合、
        /// ILog 実装クラス のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest06()
        {
            // 準備
            string className = "className";
            object[] args = { null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 1 で args[0] の文字列変換後の
        /// 文字列長が 0 の場合、
        /// ILog 実装クラス のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest07()
        {
            // 準備
            string className = "className";
            object[] args = { string.Empty };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 3 で
        /// args[0]=args[1]=args[2]=null の場合、
        /// ILog 実装クラス のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest08()
        {
            // 準備
            string className = "className";
            object[] args = { null, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 3 で args[0] の文字列変換後の
        /// 文字列長が 0、args[1]=args[2]=null の場合、
        /// ILog 実装クラス のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest09()
        {
            // 準備
            string className = "className";
            object[] args = { string.Empty, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の className が 非空文字列、args の要素数が 3 で args[0] の文字列変換後の
        /// 文字列長が 0 でなく、args[1]=args[2]=null の場合、
        /// ILog 実装クラス のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest10()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName", null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// className と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 1 個の場合、
        /// ILog 実装クラス のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest11()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01", "sourceName01"));
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(2, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// className と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 3 個の場合、
        /// ILog 実装クラス のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest12()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("className02", "sourceName02"));
            logFactory.LoggersStub.Add("dummyKey03", new TraceSourceLogger("className03", "sourceName03"));

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(4, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// className と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在し、
        /// Dictionaryの要素数が 1 個の場合、
        /// ILog 実装クラス のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest13()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            TraceSourceLogger chacheLogger = new TraceSourceLogger("className", "sourceName");
            logFactory.LoggersStub.Add("className:sourceName", chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreSame(chacheLogger, logger);
            Assert.IsNull(logFactory._className);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// className と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在し、
        /// Dictionaryの要素数が 3 個の場合、
        /// ILog 実装クラス のインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest14()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("className02", "sourceName02"));
            TraceSourceLogger chacheLogger = new TraceSourceLogger("className", "sourceName");
            logFactory.LoggersStub.Add("className:sourceName", chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(3, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreSame(chacheLogger, logger);
            Assert.IsNull(logFactory._className);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// TraceSourceLogFactory のスタブクラスを利用せずに実行することで、
        /// CreateTraceSourceLoggerByName メソッドのパスを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest15()
        {
            // 準備
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory logFactory = new TraceSourceLogFactory();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory.GetLogger(className, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
        }

        #endregion

        #region GetLogger(Type, params object[]) のテスト

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest01()
        {
            // 準備
            Type classType = null;
            object[] args = { "sourceName" };

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType, args);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: classType", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// classType と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 0 個の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest02()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args が null の場合、
        /// ArgumentNullException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest03()
        {
            // 準備
            Type classType = typeof(Object);

            try
            {
                // 実施
                ILog target = LogFactory.GetLogger(classType, null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("値を Null にすることはできません。\r\nパラメータ名: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 0 の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest04()
        {
            // 準備
            Type classType = typeof(Object);

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 1 で args[0]=null の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest05()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 1 で args[0] の文字列変換後の
        /// 文字列長が 0 の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest06()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { string.Empty };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 3 で
        /// args[0]=args[1]=args[2]=null の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest07()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { null, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 3 で args[0] の文字列変換後の
        /// 文字列長が 0、args[1]=args[2]=null の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest08()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { string.Empty, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の classType が not null、args の要素数が 3 で args[0] の文字列変換後の
        /// 文字列長が 0 でなく、args[1]=args[2]=null の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest09()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName", null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// classType と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 1 個の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest10()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(2, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// classType と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在せず、
        /// Dictionaryの要素数が 3 個の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest11()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("classType02", "sourceName02"));
            logFactory.LoggersStub.Add("dummyKey03", new TraceSourceLogger("classType03", "sourceName03"));

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(4, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// classType と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在し、
        /// Dictionaryの要素数が 1 個の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest12()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            TraceSourceLogger chacheLogger = new TraceSourceLogger(typeof(Object), "sourceName");
            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            logFactory.LoggersStub.Add(key, chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(chacheLogger, logger);

            Assert.IsNull(logFactory._classType);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// classType と arg[0] から生成したキー文字列に該当する
        /// ILog 実装クラスのインスタンスのキャッシュが存在し、
        /// Dictionaryの要素数が 3 個の場合、
        /// ILog 実装クラスのインスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest13()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("classType02", "sourceName02"));
            TraceSourceLogger chacheLogger = new TraceSourceLogger(typeof(Object), "sourceName");
            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            logFactory.LoggersStub.Add(key, chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(3, logFactory.LoggersStub.Count);

            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(chacheLogger, logger);

            Assert.IsNull(logFactory._classType);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) のテスト
        /// </summary>
        /// <remarks>
        /// TraceSourceLogFactory のスタブクラスを利用せずに実行することで、
        /// CreateTraceSourceLoggerByName メソッドのパスを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest14()
        {
            // 準備
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory logFactory = new TraceSourceLogFactory();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // 実施
            ILog logger = TraceSourceLogFactory.GetLogger(classType, args);

            // 確認
            Assert.IsInstanceOfType(logger, typeof(ILog));
        }

        #endregion
    }
}
