﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Configuration;
using System.Configuration;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common;


namespace TERASOLUNA.Fw.CommonUT.Configuration
{
    /// <summary>
    /// FilesCollection のテスト クラスです。
    ///</summary>
   
    [TestClass()]
    public class FilesCollectionTest
    {

        private TestContext testContextInstance;
        private const string BLOGIC_CONFIG_SECTION_FILE_NAME_01 = "TestItem_BLogicConfigSection01.config";
        private const string BLOGIC_CONFIG_SECTION_FILE_NAME_08 = "TestItem_BLogicConfigSection08.config";

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// FilesCollection () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            FilesCollection target = new FilesCollection();
            Assert.IsNotNull(target);
        
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateNewElement () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>FileElement型インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestCreateNewElement01()
        {
            FilesCollection target = new FilesCollection();
            CommonUT.TERASOLUNA_Fw_Common_Configuration_FilesCollectionAccessor accessor = new TERASOLUNA_Fw_Common_Configuration_FilesCollectionAccessor(target);
            Assert.IsInstanceOfType(accessor.CreateNewElement(), typeof(FileElement));
        
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));

        }

        /// <summary>
        /// GetElementKey () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition>引数にFileElement型インスタンスを指定すること</TestCondition>
        /// <TestAssertion>string型の値が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestGetElementKey01()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
            FilesCollection filesCol = scs.Files;
            FileElement target = filesCol[0];
            TERASOLUNA_Fw_Common_Configuration_FilesCollectionAccessor accessor = new TERASOLUNA_Fw_Common_Configuration_FilesCollectionAccessor(filesCol);
            object ret = accessor.GetElementKey(target);
            Assert.AreEqual("TestItem_BLogicExternal01.config", ret.ToString());

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));
        }

        /// <summary>
        /// GetElementKey () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition>引数にnullを指定すること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestGetElementKey02()
        {
            try
            {
                FilesCollection target = new FilesCollection();
                TERASOLUNA_Fw_Common_Configuration_FilesCollectionAccessor accessor = new TERASOLUNA_Fw_Common_Configuration_FilesCollectionAccessor(target);
                object ret = accessor.GetElementKey(null);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException ex)
            {
                Assert.IsInstanceOfType(ex, typeof(ArgumentNullException));

                // 例外パラメータの確認
                //ArgumentNullException ae = ex.InnerException as ArgumentNullException;
                Assert.AreEqual("element", ex.ParamName);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FilesCollection), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "element"));

        }

        /// <summary>
        /// GetElementKey () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition>引数にFileElement型でないインスタンスを指定すること</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestGetElementKey03()
        {
            ConfigurationElement target = null;

            try
            {
                BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
                FilesCollection filesCol = scs.Files;
                target = new BLogicElement();

                TERASOLUNA_Fw_Common_Configuration_FilesCollectionAccessor accessor = new TERASOLUNA_Fw_Common_Configuration_FilesCollectionAccessor(filesCol);
                string ret = accessor.GetElementKey(target).ToString();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException ex)
            {
                Assert.IsInstanceOfType(ex, typeof(ArgumentException));

                // 例外メッセージの確認
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_CAST", target.GetType().FullName, typeof(FileElement).FullName), ex.Message);

            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(FilesCollection), typeof(ArgumentException), "E_INVALID_CAST", target.GetType().FullName, typeof(FileElement).FullName));

        }

        /// <summary>
        /// CollectionType のテスト
        /// </summary>
        /// <TestTarget>CollectionType()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>ConfigurationElementCollectionType.BasicMapが返却されること</TestAssertion>
        [TestMethod()]
        public void TestCollectionType01()
        {
            FilesCollection target = new FilesCollection();
            Assert.AreEqual(ConfigurationElementCollectionType.BasicMap, target.CollectionType);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));
        }

        /// <summary>
        /// this[int index] のテスト
        /// </summary>
        /// <TestTarget>this[int index]</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>indexに指定したFileElementが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestItem01()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
            FilesCollection target = scs.Files;
            Assert.AreEqual("TestItem_BLogicExternal01.config", target[0].Path);
            Assert.AreEqual("TestItem_BLogicExternal02.config", target[1].Path);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));
        }

        /// <summary>
        /// this[string path] のテスト
        /// </summary>
        /// <TestTarget>this[string path]</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>pathに指定したFileElementが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestItem02()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
            FilesCollection target = scs.Files;
            Assert.AreEqual("TestItem_BLogicExternal01.config", target["TestItem_BLogicExternal01.config"].Path);
            Assert.AreEqual("TestItem_BLogicExternal02.config", target["TestItem_BLogicExternal02.config"].Path);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));
        }

        /// <summary>
        /// this[int index] のテスト
        /// </summary>
        /// <TestTarget>this[int index]</TestTarget>
        /// <TestCondition>-1を指定する</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestItem03()
        {
            try
            {
                BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
                FilesCollection target = scs.Files;
                FileElement ret = target[-1];
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException)
            {
                Assert.IsTrue(true);
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));

        }

        /// <summary>
        /// this[int index] のテスト
        /// </summary>
        /// <TestTarget>this[int index]</TestTarget>
        /// <TestCondition>格納されていない配列の列を指定する</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestItem04()
        {
            try
            {
                BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
                FilesCollection target = scs.Files;
                FileElement ret = target[2];
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException)
            {
                Assert.IsTrue(true);
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));

        }

        /// <summary>
        /// this[string path] のテスト
        /// </summary>
        /// <TestTarget>this[string path]</TestTarget>
        /// <TestCondition>nullを指定すること</TestCondition>
        /// <TestAssertion>IndexOutOfRangeExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestItem05()
        {
            try
            {
                BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
                FilesCollection target = scs.Files;
                FileElement ret = target[null];
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (NullReferenceException)
            {
                Assert.IsTrue(true);
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));

        }

        /// <summary>
        /// this[string path] のテスト
        /// </summary>
        /// <TestTarget>this[string path]</TestTarget>
        /// <TestCondition>空文字を指定すること</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestItem06()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
            FilesCollection target = scs.Files;
            FileElement ret = target[""];
            Assert.AreEqual(null, ret);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));

        }

        /// <summary>
        /// this[string path] のテスト
        /// </summary>
        /// <TestTarget>this[string path]</TestTarget>
        /// <TestCondition>設定外の文字列を指定すること</TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestItem07()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
            FilesCollection target = scs.Files;
            FileElement ret = target["invalid"];
            Assert.AreEqual(null, ret);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));

        }

        /// <summary>
        /// Count のテスト
        /// </summary>
        /// <TestTarget>Count</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>保持しているFile要素数が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestCount01()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
            FilesCollection target = scs.Files;
            Assert.AreEqual(2, target.Count);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));
        }

        /// <summary>
        /// Count のテスト
        /// </summary>
        /// <TestTarget>Count</TestTarget>
        /// <TestCondition>構成ファイルのfile要素が無いこと</TestCondition>
        /// <TestAssertion>0が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection08.config")]
        public void TestCount02()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_08);
            FilesCollection target = scs.Files;
            Assert.AreEqual(0, target.Count);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));
        }

        /// <summary>
        /// ElementName のテスト
        /// </summary>
        /// <TestTarget>Count</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>"file"が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestElementName01()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
            FilesCollection filesCol = scs.Files;
            ConfigurationElement target = new BLogicElement();

            TERASOLUNA_Fw_Common_Configuration_FilesCollectionAccessor accessor = new TERASOLUNA_Fw_Common_Configuration_FilesCollectionAccessor(filesCol);
            string ret = accessor.ElementName;
            Assert.AreEqual("file", ret);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FilesCollection), LogLevel.INFO));
        }


    }

}
