﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Configuration;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.Configuration
{
    /// <summary>
    ///  FileElement () のテスト
    /// </summary>
  
    [TestClass()]
    public class FileElementTest
    {

        private TestContext testContextInstance;
        private const string BLOGIC_CONFIG_SECTION_FILE_NAME_01 = "TestItem_BLogicConfigSection01.config";
        private const string BLOGIC_CONFIG_SECTION_FILE_NAME_09 = "TestItem_BLogicConfigSection09.config";
        private const string BLOGIC_CONFIG_SECTION_FILE_NAME_10 = "TestItem_BLogicConfigSection10.config";
        private const string BLOGIC_CONFIG_SECTION_FILE_NAME_12 = "TestItem_BLogicConfigSection12.config";
        private const string BLOGIC_CONFIG_SECTION_FILE_NAME_11 = "TestItem_BLogicConfigSection11.config";
        private const string BLOGIC_CONFIG_SECTION_FILE_NAME_28 = "TestItem_BLogicConfigSection28.config";

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// FileElement () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            FileElement target = new FileElement();
            Assert.IsNotNull(target);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileElement), LogLevel.INFO));
        }

        /// <summary>
        /// Path のテスト
        /// </summary>
        /// <TestTarget>Path</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>構成ファイルのpath属性の値が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        public void TestPath01()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_01);
            FileElement target = scs.Files[0];
            Assert.AreEqual("TestItem_BLogicExternal01.config", target.Path);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileElement), LogLevel.INFO));
        }
        /// <summary>
        /// Path のテスト
        /// </summary>
        /// <TestTarget>Path</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が空文字であること</TestCondition>
        /// <TestAssertion>構成ファイルのpath属性の値が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection28.config")]
        public void TestPath02()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_28);
            FileElement target = scs.Files[0];
            Assert.AreEqual("", target.Path);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileElement), LogLevel.INFO));
        }
        /// <summary>
        /// Path のテスト
        /// </summary>
        /// <TestTarget>Path</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が存在しないファイルパスであること</TestCondition>
        /// <TestAssertion>構成ファイルのpath属性の値が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection09.config")]
        public void TestPath03()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_09);
            FileElement target = scs.Files[0];
            Assert.AreEqual("Nothing.config", target.Path);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileElement), LogLevel.INFO));
        }
        /// <summary>
        /// Path のテスト
        /// </summary>
        /// <TestTarget>Path</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が使用できないファイル名であること</TestCondition>
        /// <TestAssertion>構成ファイルのpath属性の値が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection10.config")]
        public void TestPath04()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_10);
            FileElement target = scs.Files[0];
            Assert.AreEqual("TestItem_SqlExternalX>.config", target.Path);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileElement), LogLevel.INFO));
        }
        /// <summary>
        /// Path のテスト
        /// </summary>
        /// <TestTarget>Path</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が無効なファイル名であること</TestCondition>
        /// <TestAssertion>構成ファイルのpath属性の値が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection12.config")]
        public void TestPath05()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_12);
            FileElement target = scs.Files[0];
            Assert.AreEqual(@"a\a", target.Path);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileElement), LogLevel.INFO));
        }
        /// <summary>
        /// Path のテスト
        /// </summary>
        /// <TestTarget>Path</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が260字以上であること</TestCondition>
        /// <TestAssertion>構成ファイルのpath属性の値が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection11.config")]
        public void TestPath06()
        {
            BLogicConfigurationSection scs = ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(BLOGIC_CONFIG_SECTION_FILE_NAME_11);
            FileElement target = scs.Files[0];
            Assert.AreEqual(@"1111111111222222222233333333334444444444555555555566666666667777777777888888888899999999990000000000111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999000000000011111111112222222222333333333344444\TestItem_SqlExternalXX.config", target.Path);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileElement), LogLevel.INFO));
        }

    }


}
