﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;

namespace TERASOLUNA.Fw.Common.Configuration.BLogic
{
    /// <summary>
    /// ビジネスロジック設定ファイル内の dbInfo 要素を表します。
    /// </summary>
    /// <remarks>
    /// BLogicDbInfoElement は、ビジネスロジック設定ファイル内の dbInfo 要素を表します。 
    /// 詳細については <see cref="ConfigurationElement"/> を参照してください。
    /// </remarks>
    public sealed class BLogicDbInfoElement : ConfigurationElement
    {
        /// <summary>
        /// name 属性の属性名です。
        /// </summary>
        /// <remarks>
        /// この定数の値は、 "name" です。
        /// </remarks>
        private const string NAME_ATTRIBUTE_NAME = "name";

        /// <summary>
        /// <see cref="BLogicDbInfoElement"/> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>デフォルトコンストラクタです。</remarks>
        public BLogicDbInfoElement()
        {
        }

        /// <summary>
        /// <see cref="BLogicDbInfoElement"/> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="name">name 属性の値。</param>
        public BLogicDbInfoElement(string name)
        {
            this[NAME_ATTRIBUTE_NAME] = name;
        }

        /// <summary>
        /// name 属性の値を取得します。
        /// </summary>
        /// <value>
        /// name 属性の値。
        /// </value>
        [ConfigurationProperty(NAME_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string Name
        {
            get
            {
                return (string)this[NAME_ATTRIBUTE_NAME];
            }
        }
    }
}
