// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Common.Configuration.BLogic
{
    /// <summary>
    /// blogic vf̃RNVi[\vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="BLogicCollection"/> ́ArWlXWbNݒt@C blogic vf̃RNV\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElementCollection"/> QƂĂB
    /// </remarks>
    public class BLogicCollection : ConfigurationElementCollection
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(BLogicCollection));

        /// <summary>
        /// blogic vf̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "blogic" łB
        /// </remarks>
        private static readonly string BLOGIC_ELEMENT_NAME = "blogic";

        /// <summary>
        /// <see cref="BLogicCollection"/> NX̐VCX^X쐬܂B
        /// </summary>
        /// <remarks>ftHgRXgN^łB</remarks>
        public BLogicCollection()
        {
        }

        /// <summary>
        /// <see cref="BLogicCollection"/> ̌^擾܂B
        /// </summary>
        /// <remarks>
        /// ̃RNV <see cref="ConfigurationElementCollectionType"/>  <seealso cref="ConfigurationElementCollectionType.BasicMap"/> łB
        /// </remarks>
        /// <value>
        /// ̃RNV <see cref="ConfigurationElementCollectionType"/> B
        /// </value>
        public override ConfigurationElementCollectionType CollectionType
        {
            get
            {
                return ConfigurationElementCollectionType.BasicMap;
            }
        }

        /// <summary>
        /// <see cref="BLogicElement"/> NX̐VCX^X쐬܂B
        /// </summary>
        /// <returns><see cref="BLogicElement"/> NX̃CX^XB</returns>
        protected override ConfigurationElement CreateNewElement()
        {
            return new BLogicElement();
        }

        /// <summary>
        /// w肵CfbNXʒuɂ blogic vf擾܂B
        /// </summary>
        /// <param name="index">擾 <see cref="BLogicElement"/> ̃CfbNXʒuB</param>
        /// <returns>w肵CfbNXʒuɂ <see cref="BLogicElement"/> B</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(int)"/> \bhgpāA <see cref="BLogicCollection"/>  <see cref="BLogicElement"/> 擾܂B
        /// </remarks>
        public BLogicElement this[int index]
        {
            get
            {
                return (BLogicElement)BaseGet(index);
            }
        }

        /// <summary>
        /// w肵L[ blogic vf擾܂B
        /// </summary>
        /// <param name="name">擾 blogic vf̃L[B</param>
        /// <returns>w肵L[ <see cref="BLogicElement"/> BȊȌꍇ null QƂłB</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(object)"/> \bhgpāA
        /// <see cref="BLogicCollection"/>  <see cref="BLogicElement"/> 擾܂B
        /// w肵L[ <see cref="BLogicElement"/> RNVɑ݂ȂꍇAnull QƂԂ܂B
        /// </remarks>
        public new BLogicElement this[string name]
        {
            get
            {
                return (BLogicElement)BaseGet(name);
            }
        }

        /// <summary>
        /// rWlXWbNݒt@Ĉ̗vf̃RNVʂ邽߂Ɏgp閼O擾܂B
        /// </summary>
        /// <remarks>
        /// vf "blogic" łB
        /// </remarks>
        /// <value>
        /// ̗vf̃RNV̗vfB
        /// </value>
        protected override string ElementName
        {
            get
            {
                return BLOGIC_ELEMENT_NAME;
            }
        }

        /// <summary>
        /// blogic vf̗vfL[擾܂B
        /// </summary>
        /// <param name="element"> 擾 <see cref="BLogicElement"/> vf̃L[B</param>
        /// <returns>w肵L[ <see cref="BLogicElement"/> BȊȌꍇ null QƂłB</returns>
        /// <remarks>ɂȂB</remarks>
        /// <exception cref="System.ArgumentNullException">
        /// <paramref name="element"/>  null QƂłB
        /// </exception>
        /// <exception cref="System.ArgumentException">
        /// <paramref name="element"/>  <see cref="BLogicElement"/> ɃLXgł܂B
        /// </exception>
        protected override Object GetElementKey(ConfigurationElement element)
        {
            if (element == null)
            {
                ArgumentNullException exception = new ArgumentNullException("element");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Common.Properties.Resources.E_NULL_ARGUMENT, "element"), exception);
                }
                throw exception;
            }

            BLogicElement blogicElement = element as BLogicElement;
            if (blogicElement == null)
            {
                string message = string.Format(Common.Properties.Resources.E_INVALID_CAST, element.GetType().FullName, typeof(BLogicElement).FullName);
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            return blogicElement.Name;
        }

        /// <summary>
        /// <see cref="BLogicCollection"/>  blogic vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="BLogicElement"/> B</param>
        /// <remarks>
        /// <see cref="BLogicCollection.BaseAdd(ConfigurationElement)"/> \bhgpāA
        /// RNVɐV <see cref="BLogicElement"/> ǉ܂B
        /// </remarks>
        public void Add(BLogicElement element)
        {
            BaseAdd(element);
        }

        /// <summary>
        /// <see cref="BLogicCollection"/>  blogic vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="BLogicElement"/> B</param>
        /// <remarks>
        /// w肵 <paramref name="element"/>  blogic vfRNVɊɑ݂ꍇAO͔܂B
        /// </remarks>
        protected override void BaseAdd(ConfigurationElement element)
        {
            BaseAdd(element, false);
        }

        /// <summary>
        /// <see cref="BLogicCollection"/> ǂݎpǂl擾܂B 
        /// </summary>
        /// <returns>
        /// <see cref="BLogicCollection"/> ǂݎp̏ꍇ true BȊȌꍇ false B
        /// </returns>
        /// <remarks>
        /// <see cref="BLogicCollection"/> ͓ǂݎpł͂܂B
        /// </remarks>
        public override bool IsReadOnly()
        {
            return false;
        }

    }
}
