// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.ExceptionTransition;
using System.Xml;
using TERASOLUNA.Fw.Common.Configuration;
using TERASOLUNA.Fw.WebUT;
using System.Xml.Schema;
using System.Configuration;
using System.IO;
using TERASOLUNA.Fw.WebUT.Configuration;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.WebUT.Configuration.ExceptionTransition
{
    /// <summary>
    /// TERASOLUNA.Fw.Common.Configuration.ExceptionTransitionConfigurationSection のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Common.Configuration.ExceptionTransitionConfigurationSection 単体テストをここに含めます
    /// </summary>

    [TestClass()]
    public class ExceptionTransitionConfigurationSectionTest
    {

        private TestContext testContextInstance;
        private const string FLAG_ON = "On";
        private const string FLAG_OFF = "Off";
        private const string FLAG_ON_DEFAULT = "on";
        private const string FLAG_OFF_DEFAULT = "off";
        private const string CONFIG_FILE_NAME_01 = "TestItem_ExceptionTransitionConfigSection01.config";
        private const string CONFIG_FILE_NAME_02 = "TestItem_ExceptionTransitionConfigSection02.config";
        private const string CONFIG_FILE_NAME_03 = "TestItem_ExceptionTransitionConfigSection03.config";
        private const string CONFIG_FILE_NAME_04 = "TestItem_ExceptionTransitionConfigSection04.config";
        private const string CONFIG_FILE_NAME_05 = "TestItem_ExceptionTransitionConfigSection05.config";
        private const string CONFIG_FILE_NAME_06 = "TestItem_ExceptionTransitionConfigSection06.config";
        private const string CONFIG_FILE_NAME_07 = "TestItem_ExceptionTransitionConfigSection07.config";
        private const string CONFIG_FILE_NAME_08 = "TestItem_ExceptionTransitionConfigSection08.config";
        private const string CONFIG_FILE_NAME_09 = "TestItem_ExceptionTransitionConfigSection09.config";
        private const string CONFIG_FILE_NAME_10 = "TestItem_ExceptionTransitionConfigSection10.config";
        private const string CONFIG_FILE_NAME_11 = "TestItem_ExceptionTransitionConfigSection11.config";
        private const string CONFIG_FILE_NAME_12 = "TestItem_ExceptionTransitionConfigSection12.config";
        private const string CONFIG_FILE_NAME_13 = "TestItem_ExceptionTransitionConfigSection13.config";
        private const string CONFIG_FILE_NAME_14 = "TestItem_ExceptionTransitionConfigSection14.config";
        private const string CONFIG_FILE_NAME_15 = "TestItem_ExceptionTransitionConfigSection15.config";
        private const string CONFIG_FILE_NAME_16 = "TestItem_ExceptionTransitionConfigSection16.config";
        private const string CONFIG_FILE_NAME_17 = "TestItem_ExceptionTransitionConfigSection17.config";

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// ExceptionTransitionConfigurationSection () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            ExceptionTransitionConfigurationSection target = new ExceptionTransitionConfigurationSection();
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Mode のテスト
        /// </summary>
        /// <TestTarget>Mode</TestTarget>
        /// <TestCondition>構成ファイルが正常なこと、mode属性に"On"が設定されていること</TestCondition>
        /// <TestAssertion>"On"が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection01.config")]
        public void TestMode01()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            Assert.AreEqual(FLAG_ON, target.Mode);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Mode のテスト
        /// </summary>
        /// <TestTarget>Mode</TestTarget>
        /// <TestCondition>構成ファイルが正常なこと、mode属性に"Off"が設定されていること</TestCondition>
        /// <TestAssertion>"Off"が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection02.config")]
        public void TestMode02()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_02);
            Assert.AreEqual(FLAG_OFF, target.Mode);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Mode のテスト
        /// </summary>
        /// <TestTarget>Mode</TestTarget>
        /// <TestCondition>構成ファイルが正常なこと、mode属性が省略されていること</TestCondition>
        /// <TestAssertion>"On"が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection03.config")]
        public void TestMode03()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_03);
            Assert.AreEqual(FLAG_ON_DEFAULT, target.Mode);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Logging のテスト
        /// </summary>
        /// <TestTarget>Logging</TestTarget>
        /// <TestCondition>構成ファイルが正常なこと、logging属性に"On"が設定されていること</TestCondition>
        /// <TestAssertion>"On"が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection01.config")]
        public void TestLogging01()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            Assert.AreEqual(FLAG_ON, target.Logging);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Logging のテスト
        /// </summary>
        /// <TestTarget>Logging</TestTarget>
        /// <TestCondition>構成ファイルが正常なこと、logging属性に"Off"が設定されていること</TestCondition>
        /// <TestAssertion>"Off"が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection02.config")]
        public void TestLogging02()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_02);
            Assert.AreEqual(FLAG_OFF, target.Logging);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Logging のテスト
        /// </summary>
        /// <TestTarget>Logging</TestTarget>
        /// <TestCondition>構成ファイルが正常なこと、logging属性が省略されていること</TestCondition>
        /// <TestAssertion>"Off"が返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection03.config")]
        public void TestLogging03()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_03);
            Assert.AreEqual(FLAG_OFF_DEFAULT, target.Logging);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Files のテスト
        /// </summary>
        /// <TestTarget>Files</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>FilesCollectionが返却されること</TestAssertion>
        [TestMethod()]
        public void TestFiles01()
        {
            ExceptionTransitionConfigurationSection target = new ExceptionTransitionConfigurationSection();
            Assert.IsInstanceOfType(target.Files, typeof(FilesCollection));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// ExceptionTransitionCollection のテスト
        /// </summary>
        /// <TestTarget>ExceptionTransitionCollection</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>ExceptionTransitionCollectionが返却されること</TestAssertion>
        [TestMethod()]
        public void TestExceptionTransitionCollection01()
        {
            ExceptionTransitionConfigurationSection target = new ExceptionTransitionConfigurationSection();
            Assert.IsInstanceOfType(target.ExceptionTransitionCollection, typeof(ExceptionTransitionCollection));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>外部設定ファイルの設定情報がExceptionTransitionCollectionプロパティに保持されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal02.config")]
        public void TestCreateExceptionTransitionElements01()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);

            target.CreateExceptionTransitionElements();

            Assert.AreEqual("System.ArgumentException", target.ExceptionTransitionCollection[0].ExceptionType);
            Assert.AreEqual("Error1", target.ExceptionTransitionCollection[0].NextPage);
            Assert.AreEqual("System.ArgumentNullException", target.ExceptionTransitionCollection[1].ExceptionType);
            Assert.AreEqual("Error2", target.ExceptionTransitionCollection[1].NextPage);
            Assert.AreEqual("System.ApplicationException", target.ExceptionTransitionCollection[2].ExceptionType);
            Assert.AreEqual("Error3", target.ExceptionTransitionCollection[2].NextPage);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionTransition要素のexceptionType属性の値が重複していること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection04.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal03.config")]
        public void TestCreateExceptionTransitionElements02()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_04);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionTransitionExternal03.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionTransitionConfiguration要素が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection05.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal04.config")]
        public void TestCreateExceptionTransitionElements03()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_05);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionTransitionExternal04.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionTransition要素が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection06.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal05.config")]
        public void TestCreateExceptionTransitionElements04()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_06);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionTransitionExternal05.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionTransition要素のexceptionType属性が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection07.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal06.config")]
        public void TestCreateExceptionTransitionElements05()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_07);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionTransitionExternal06.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionTransition要素のnextPage属性が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection08.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal07.config")]
        public void TestCreateExceptionTransitionElements06()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_08);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionTransitionExternal07.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>外部設定ファイルに不正な要素が存在すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection09.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal08.config")]
        public void TestCreateExceptionTransitionElements07()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_09);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionTransitionExternal08.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }


        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>構成ファイルにfile要素がないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection10.config")]
        public void TestCreateExceptionTransitionElements08()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_10);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_CUSTOM_SECTION_HANDLER", "exceptionTransitionConfiguration");
                Assert.AreEqual(message, e.Message);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>構成ファイルに設定されている外部設定ファイルが存在しないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection11.config")]
        public void TestCreateExceptionTransitionElements09()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_11);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\Nothing.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(FileNotFoundException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性にファイル名に使用できない文字が含まれていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection12.config")]
        public void TestCreateExceptionTransitionElements10()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_12);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + Path.DirectorySeparatorChar + @"TestItem_SqlExternalX>.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が260文字以上であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection13.config")]
        public void TestCreateExceptionTransitionElements11()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_13);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\1111111111222222222233333333334444444444555555555566666666667777777777888888888899999999990000000000111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999000000000011111111112222222222333333333344444\TestItem_SqlExternalXX.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(PathTooLongException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が無効なパスであること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection14.config")]
        public void TestCreateExceptionTransitionElements12()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_14);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\a\a";
                string message = MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(DirectoryNotFoundException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>外部設定ファイルがXML形式でないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection15.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal09.config")]
        public void TestCreateExceptionTransitionElements13()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_15);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string filePath = Environment.CurrentDirectory + @"\TestItem_ExceptionTransitionExternal09.config";
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", "exceptionTransitionConfiguration", filePath);
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateExceptionTransitionElements () のテスト
        /// </summary>
        /// <TestTarget>CreateExceptionTransitionElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのexceptionType属性の値がマージ後重複すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionConfigSection16.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal01.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_ExceptionTransitionExternal10.config")]
        public void TestCreateExceptionTransitionElements14()
        {
            ExceptionTransitionConfigurationSection target =
                ConfigTestHelper.GetExceptionTransitionConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_16);

            try
            {
                target.CreateExceptionTransitionElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 成功
                string message = MessageManager.GetMessage("E_CONFIGURATION_INVALID_MERGED_CONFIG", "ex:exceptionTransitionConfiguration");
                Assert.AreEqual(message, e.Message);
                Assert.IsInstanceOfType(e.InnerException, typeof(XmlSchemaException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ExceptionTransitionConfigurationSection), LogLevel.INFO));
        }
    }
}
