// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;

namespace TERASOLUNA.Fw.Web.Validation
{
    /// <summary>
    /// ͒l؂ɗp鑮`܂B
    /// </summary>
    /// <remarks>
    /// <para>
    /// ̑ <see cref="Common.BLogic.IBLogic"/> C^tF[XNXɎw肷邱ƂɂA
    /// ͒l؂ɕKvƂȂ̉s܂B
    /// rWlXWbN̎sOɁA͒l؂vꍇɎw肵ĂB
    /// </para>
    /// <para>
    /// w莞AOt "RuleSet" ɒlݒ肵ȂꍇA "Default" p܂B
    /// </para>
    /// </remarks>
    [AttributeUsage(AttributeTargets.Class)]
    public class ValidationInfoAttribute : Attribute
    {
        /// <summary>
        /// ͒l؂ɗpXL[}t@C̑΃t@CpXłB
        /// </summary>
        private string _validationFilePath = null;

        /// <summary>
        /// ͒l؂ɗp郋[ZbgłB
        /// </summary>
        /// <remarks>
        /// ftHg̒l "Default" łB
        /// </remarks>
        private string _ruleSet = "Default";

        /// <summary>
        /// V <see cref="ValidationInfoAttribute"/> ̃CX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public ValidationInfoAttribute()
            : this(null, null)
        {
        }

        /// <summary>
        /// V <see cref="ValidationInfoAttribute"/> ̃CX^X܂B
        /// </summary>
        /// <remarks>RXgN^łB</remarks>
        /// <param name="validationFilePath">͒l؂ɗpXL[}t@C̑΃t@CpXB</param>
        public ValidationInfoAttribute(string validationFilePath)
            : this(validationFilePath, null)
        {
        }

        /// <summary>
        /// V <see cref="ValidationInfoAttribute"/> ̃CX^X܂B
        /// </summary>
        /// <remarks>RXgN^łB</remarks>
        /// <param name="validationFilePath">͒l؂ɗpXL[}t@C̑΃t@CpXB</param>
        /// <param name="ruleSet">͒l؂ɗp郋[Zbg</param>
        public ValidationInfoAttribute(string validationFilePath, string ruleSet)
        {
            _validationFilePath = validationFilePath;
            if (string.IsNullOrEmpty(ruleSet))
            {
                _ruleSet = ruleSet;
            }
        }

        /// <summary>
        /// ͒l؂ɗpXL[}t@C
        /// ΃t@CpX擾܂͐ݒ肵܂B
        /// </summary>
        /// <remarks>
        /// rWlXWbN̎sOɁA͒l؂vꍇɎw肵܂B
        /// w肳ĂȂꍇ́A͒l؂sȂƂ\܂B
        /// ̃vpeBɂ́A[AvP[V[g]\Bin ̑΃pX
        /// w肷Kv܂B
        /// </remarks>
        public string ValidationFilePath
        {
            get
            {
                return _validationFilePath;
            }
            set
            {
                _validationFilePath = value;
            }
        }

        /// <summary>
        /// ͒l؂ɗp郋[Zbg擾܂͐ݒ肵܂B
        /// </summary>
        public string RuleSet
        {
            get
            {
                return _ruleSet;
            }
            set
            {
                _ruleSet = value;
            }
        }
    }
}
