// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.IO;
using System.Net.Mime;
using System.Text;
using System.Web;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Web.BLogic;

namespace TERASOLUNA.Fw.Web.Controller
{
    /// <summary>
    /// NCAg̃t@C_E[h𔺂rWlXWbNsv
    /// Rg[NXłB
    /// </summary>
    public class FileDownloadRequestController : BLogicRequestController
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(FileDownloadRequestController));

        /// <summary>
        /// Content-Dispositon wb_́B
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "content-disposition" łB
        /// </remarks>
        private static readonly string HEADER_CONTENT_DISPOSITION = "content-disposition";

        /// <summary>
        /// Base64 \GR[fBOʖłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "B" łB
        /// </remarks>
        private static readonly string MIME_ENCODE_TYPE = "B";
        /// <summary>
        /// t@Ĉ̃GR[fBOłB( ISO-2022-JP )
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "ISO-2022-JP" łB
        /// </remarks>
        private readonly Encoding FILENAME_ENCOING = Encoding.GetEncoding("ISO-2022-JP");

        /// <summary>
        /// rWlXWbNs܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <returns>Ȉꍇ true AƖG[ꍇ false ԋp܂B</returns>
        /// <remarks>
        /// <see cref="BLogicRequestController.ExecuteBLogic"/> ĂяoA
        /// rWlXWbNʃIuWFNg <see cref="FileDownloadBLogicResult"/> 
        /// ł邩؂s܂B
        /// </remarks>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <see cref="Common.BLogic.IBLogic"/> NX𐶐ł܂B
        /// </item>
        /// <item>
        /// <seealso cref="Common.BLogic.IBLogic.Execute"/> \bh̕ԋpl null QƂłB
        /// </item>
        /// <item>
        /// <description>
        /// rWlXWbNʃIuWFNg <see cref="FileDownloadBLogicResult"/>
        /// NXł͂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// rWlXWbNIArWlXWbNʃIuWFNg <seealso cref="FileDownloadBLogicResult"/>  
        /// <seealso cref="FileDownloadBLogicResult.DownloadData"/> ݒ肳ĂȂꍇɁA 
        /// <seealso cref="FileDownloadBLogicResult.DownloadFileInfo"/> ɐݒ肳ꂽt@C܂łB
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        protected override bool ExecuteBLogic(HttpContext context)
        {
            bool isSuccess = base.ExecuteBLogic(context);

            FileDownloadBLogicResult result = context.Items[KEY_CONTEXT_ITEM_BLOGIC_RESULT] as FileDownloadBLogicResult;
            if (result == null)
            {
                // ʂFileDownloadBLogicResultłȂꍇAOX[B
                TerasolunaException exception = new TerasolunaException(string.Format(
                    Properties.Resources.E_INVALID_BLOGIC_RESULT_TYPE, typeof(FileDownloadBLogicResult).FullName));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            if (isSuccess)
            {
                // rWlXWbNIĂꍇB
                if (result.ResultData == null)
                {
                    // ResultDataݒ̏ꍇɁADownloadDataݒ肳ĂȂāADownloadFileInfo
                    // ȂꍇAG[B
                    if (result.DownloadData == null && !result.DownloadFileInfo.Exists)
                    {
                        TerasolunaException exception = new TerasolunaException(string.Format(
                            Properties.Resources.E_FILE_NOT_FOUND, result.DownloadFileInfo.Name));
                        if (_log.IsErrorEnabled)
                        {
                            _log.Error(exception.Message, exception);
                        }
                        throw exception;
                    }
                }
            }
                       
            return isSuccess;
        }

        /// <summary>
        /// ĨX|X݂܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁ARequestAResponseASessionA Server)
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <para>
        /// <see cref="HttpContext.Items"/> 
        /// <see cref="BLogicRequestController.KEY_CONTEXT_ITEM_BLOGIC_RESULT"/> Ɋi[ꂽ
        /// rWlXWbNsʃIuWFNgł <see cref="FileDownloadBLogicResult"/> 
        /// <see cref="FileDownloadBLogicResult.DownloadFileInfo"/>t@Ĉ擾A
        /// <see cref="EncodeFileName"/> ɂt@ĈGR[h܂B
        /// </para>
        /// <para>
        /// GR[ht@CA
        /// <see cref="WriteSuccessBinaryResponseHeader"/>
        /// ̈Ɏw肵ČĂяoAĨX|X̃wb_ݒ肵܂B
        /// </para>
        /// <para>
        /// <see cref="FileDownloadBLogicResult.DownloadData"/> ݒ肳Ă΁A
        /// <see cref="WriteResponseBodyFromByteArray"/> ĂяoA byte z
        /// X|Xf[^ <see cref="HttpResponse.OutputStream"/> ɏ݂܂B
        /// ݒ肳ĂȂꍇ́A
        /// <see cref="WriteResponseBodyFromFileInfo"/> ĂяoAt@CɎw肳ꂽ
        /// t@CɃX|Xf[^ <see cref="HttpResponse.OutputStream"/> ɏ݂܂B
        /// </para>
        /// </remarks>
        protected override void WriteSuccessResponse(HttpContext context)
        {
            FileDownloadBLogicResult result = context.Items[KEY_CONTEXT_ITEM_BLOGIC_RESULT] as FileDownloadBLogicResult;
            
            string encodedFileName = EncodeFileName(result.DownloadFileInfo.Name);

            // X|Xwb_ݒ
            WriteSuccessBinaryResponseHeader(context.Response, encodedFileName);

            // {fB
            if (result.DownloadData == null)
            {
                // _E[hf[^ݒ肳ĂȂꍇ́ArWlXWbNʃIuWFNg̃t@C
                // w肳ꂽt@CpX̃t@C_E[hΏۂƂ܂B
                WriteResponseBodyFromFileInfo(context.Response, result.DownloadFileInfo);
            }
            else
            {
                // _E[hf[^ݒ肳Ăꍇ́Aݒ肳ꂽrWlXWbNʃIuWFNg̃_E[hf[^
                // _E[hΏۂƂ܂B
                byte[] downloadData = new byte[result.DownloadData.Count];
                result.DownloadData.CopyTo(downloadData, 0);
                WriteResponseBodyFromByteArray(context.Response, downloadData);
            }
        }

        /// <summary>
        /// t@CGR[h܂B
        /// </summary>
        /// <param name="fileName">GR[hΏۂ̃t@ĆB</param>
        /// <returns>GR[hꂽt@ĆB</returns>
        /// <remarks>
        /// content-disposition wb_filenamep[^ɐݒ肷
        /// t@ĈGR[h܂B
        /// <para>̃tH[}bgŃGR[h܂B</para>
        /// <code>
        /// ?{R[h}?{ASCIIGR[h`}?{GR[ht@C}?=
        /// </code>
        /// <list type="table">
        /// <listheader>
        /// <term>
        /// tB[h
        /// </term>
        /// <description>
        /// l
        /// </description>
        /// </listheader>
        /// <item>
        /// <term>
        /// R[h
        /// </term>
        /// <description>
        /// ISO-2022-JP
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// ASCIIGR[h`
        /// </term>
        /// <description>
        /// B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// GR[ht@C
        /// </term>
        /// <description>
        /// R[ĥɎw肳ꂽR[hɃt@C<paramref name="fileName"/>
        /// GR[hAt@ĈBase64ŃGR[hꂽB
        /// </description>
        /// </item>
        /// </list>
        /// </remarks>
        protected virtual string EncodeFileName(string fileName)
        {
            byte[] encodingBytes = FILENAME_ENCOING.GetBytes(fileName);
            string bencodedFileName = System.Convert.ToBase64String(encodingBytes);
            string mimeBEncodedFileName = string.Format("?{0}?{1}?{2}?=", FILENAME_ENCOING.WebName, MIME_ENCODE_TYPE, bencodedFileName);
            return mimeBEncodedFileName;
        }

        /// <summary>
        /// X|XɐĨwb_ݒ肵܂B
        /// </summary>
        /// <param name="response">wb_̐ݒΏۂƂȂ <see cref="HttpResponse"/>B</param>
        /// <param name="fileName">content-dispositionwb_ɐݒ肷t@ĆB</param>
        /// <remarks>
        /// ̍ڂwb_ɐݒ肵܂B
        /// <list type="table">
        /// <listheader>
        /// <term>
        /// wb_
        /// </term>
        /// <description>
        /// ݒl
        /// </description>
        /// </listheader>
        /// <item>
        /// <term>
        /// content-type
        /// </term>
        /// <description>
        /// application/octetstream
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// Xe[^X
        /// </term>
        /// <description>
        /// OK
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// content-disposition
        /// </term>
        /// <description>
        /// <paramref name="fileName"/> Ɏw肳ꂽt@ĆB
        /// </description>
        /// </item>
        /// </list>
        /// </remarks>
        protected virtual void WriteSuccessBinaryResponseHeader(HttpResponse response, string fileName)
        {
            // content-type
            ContentType ct = new ContentType();
            ct.MediaType = MediaTypeNames.Application.Octet;
            response.ContentType = ct.ToString();
            // Xe[^X
            response.StatusDescription = "OK";
            // content-disposition
            ContentDisposition cd = new ContentDisposition();
            cd.FileName = fileName;
            response.AddHeader(HEADER_CONTENT_DISPOSITION, cd.ToString());
        }

        /// <summary>
        /// X|X̏o̓Xg[Ɏw肳ꂽoCgz
        /// i[ꂽf[^݂܂B
        /// </summary>
        /// <param name="response">ݑΏۂƂȂ <see cref="HttpResponse"/>B</param>
        /// <param name="byteArray">rWlXWbNԋpꂽ_E[hf[^i[ꂽoCgzB</param>
        /// <remarks>
        /// <paramref name="byteArray"/> Ɏw肳ꂽ byte z̃f[^ <see cref="HttpResponse.OutputStream"/> 
        /// ɏ݂܂B
        /// </remarks>
        protected virtual void WriteResponseBodyFromByteArray(HttpResponse response, byte[] byteArray)
        {
            using (BinaryWriter bw = new BinaryWriter(response.OutputStream))
            {
                bw.Write(byteArray);
            }
        }

        /// <summary>
        /// X|X̏o̓Xg[Ɏw肳ꂽt@C
        /// Yt@C̓e𒼐ڏ݂܂B
        /// </summary>
        /// <param name="response">ݑΏۂƂȂ <see cref="HttpResponse"/>B</param>
        /// <param name="fileInfo">rWlXWbNԋpꂽt@CB</param>
        /// <remarks>
        /// <paramref name="fileInfo"/> Ɏw肳ꂽ t@Cɐݒ肳ꂽpXɊYt@C
        /// ̓eǂݍ݁A <see cref="HttpResponse.OutputStream"/> ɏ݂܂B
        /// </remarks>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters")]
        protected virtual void WriteResponseBodyFromFileInfo(HttpResponse response, FileInfo fileInfo)
        {
            response.TransmitFile(fileInfo.FullName);
        }
    }
}
