// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;

namespace TERASOLUNA.Fw.Web.Configuration.RequestController
{
    /// <summary>
    /// \t@C requestControllerConfiguration ZNV\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ConfigurationSection"/> NXgArequestControllerConfiguration JX^\nhłB
    /// ڍׂɂẮA<see cref="ConfigurationSection"/> QƂĂB
    /// </remarks>
    public class RequestControllerConfigurationSection : ConfigurationSection
    {
        /// <summary>
        /// <see cerf="RequestControllerCollection"/> ̗vfłB
        /// </summary>
        private const string CONTROLLERS_ELEMENT_NAME = "controllers";

        /// <summary>
        /// <see cref="RequestControllerConfigurationSection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public RequestControllerConfigurationSection()
        {
        }

        /// <summary>
        /// controllers vf擾܂B
        /// </summary>
        /// <remarks>
        /// requestControllerConfiguration ZNVA <see cref="RequestControllerCollection"/> RNV擾܂B
        /// </remarks>
        [ConfigurationProperty(CONTROLLERS_ELEMENT_NAME, IsDefaultCollection = false, IsRequired = true)]
        public RequestControllerCollection Controllers
        {
            get
            {
                RequestControllerCollection controllersCollection = (RequestControllerCollection)base[CONTROLLERS_ELEMENT_NAME];
                return controllersCollection;
            }
        }
    }
}
