// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;

namespace TERASOLUNA.Fw.Web.Configuration.ExceptionCode
{
    /// <summary>
    /// OR[hݒt@C exceptionCode vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ExceptionCodeElement"/> ́AG[ʑJڐݒt@C exceptionCode vf\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElement"/> QƂĂB
    /// </remarks>
    public sealed class ExceptionCodeElement : ConfigurationElement
    {
        /// <summary>
        /// exceptionType ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exceptionType" łB
        /// </remarks>
        private const string EXCEPTION_TYPE_ATTRIBUTE_NAME = "exceptionType";

        /// <summary>
        /// code ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "code" łB
        /// </remarks>
        private const string CODE_ATTRIBUTE_NAME = "code";

        /// <summary>
        /// <see cref="ExceptionCodeElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>ftHgRXgN^łB</remarks>
        public ExceptionCodeElement()
        {
        }

        /// <summary>
        /// <see cref="ExceptionCodeElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="exceptionType">exceptionType ̒lBType ̖OԂ܂݁AAZu܂܂ȂA^̊SCB</param>
        /// <param name="code">code ̒lB<paramref name="exceptionType"/> ̌^ɑ΂OR[hB</param>
        /// <remarks>
        /// exceptionType Acode ̒l exceptionTypeAcode ŏ܂B
        /// </remarks>
        public ExceptionCodeElement(string exceptionType, string code)
        {
            this[EXCEPTION_TYPE_ATTRIBUTE_NAME] = exceptionType;
            this[CODE_ATTRIBUTE_NAME] = code;
        }

        /// <summary>
        /// exceptionType ̒l擾܂B
        /// </summary>
        /// <value>
        /// exceptionType ̒lB
        /// </value>
        [ConfigurationProperty(EXCEPTION_TYPE_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string ExceptionType
        {
            get
            {
                return (string)this[EXCEPTION_TYPE_ATTRIBUTE_NAME];
            }
        }

        /// <summary>
        /// code ̒l擾܂B
        /// </summary>
        /// <value>
        /// code ̒lB
        /// </value>
        [ConfigurationProperty(CODE_ATTRIBUTE_NAME, IsRequired = true)]
        public string Code
        {
            get
            {
                return (string)this[CODE_ATTRIBUTE_NAME];
            }
        }
    }
}
