﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using System.Reflection;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Validators
{
    /// <summary>
    /// StringLengthRangeValidator のテストクラスです
    ///</summary>
    [TestClass()]
    public class StringLengthRangeValidatorTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// DefaultNegatedMessageTemplate01 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 未満の範囲の数値を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest01()
        {
            //準備
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Ignore;
            string messageTemplate = null;
            bool negated = true;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NEGATED_IN_IG_MESSAGETEMPLATE", placeHolder);

            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      

        }

        /// <summary>
        /// DefaultNegatedMessageTemplate02 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest02()
        {
            //準備
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Exclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Ignore;
            string messageTemplate = null;
            bool negated = true;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NEGATED_EX_IG_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNegatedMessageTemplate03 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {5} 文字より大きい文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest03()
        {
            //準備
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Ignore;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = true;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NEGATED_IG_IN_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }


        /// <summary>
        /// DefaultNegatedMessageTemplate04 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字未満または {5} 文字より大きい文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest04()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = true;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNegatedMessageTemplate05 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下または {5} 文字より大きい文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest05()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Exclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = true;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NEGATED_EX_IN_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNegatedMessageTemplate06 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest06()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Ignore;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Exclusive;
            string messageTemplate = null;
            bool negated = true;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NEGATED_IG_EX_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNegatedMessageTemplate07 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字未満または {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest07()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Exclusive;
            string messageTemplate = null;
            bool negated = true;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NEGATED_IN_EX_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNegatedMessageTemplate08 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下または {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest08()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Exclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Exclusive;
            string messageTemplate = null;
            bool negated = true;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NEGATED_EX_EX_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }


        /// <summary>
        /// DefaultNonNegatedMessageTemplate01 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下または {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest01()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Ignore;
            string messageTemplate = null;
            bool negated = false;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NONNEGATED_IN_IG_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNonNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplate02 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下または {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest02()
        {
            //準備
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Exclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Ignore;
            string messageTemplate = null;
            bool negated = false;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NONNEGATED_EX_IG_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNonNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplate03 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下または {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest03()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Ignore;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = false;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NONNEGATED_IG_IN_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNonNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplate04 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下または {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest04()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = false;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NONNEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNonNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplate05 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下または {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest05()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Exclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = false;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NONNEGATED_EX_IN_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNonNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplate06 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下または {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest06()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Ignore;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Exclusive;
            string messageTemplate = null;
            bool negated = false;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NONNEGATED_IG_EX_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNonNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplate07 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下または {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest07()
        {
            //準備　
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Exclusive;
            string messageTemplate = null;
            bool negated = false;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NONNEGATED_IN_EX_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNonNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplate07 のテスト
        /// </summary>
        /// <remarks>
        /// lowerBoundTypeにInclusive、upperBoundTypeにIgnoreを設定した場合、
        /// DefaultNegatedMessageTemplateの返り値が"\"{2}\" には {3} 文字以下または {5} 文字以上の文字列を入力してください。"であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest08()
        {
            //準備
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Exclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Exclusive;
            string messageTemplate = null;
            bool negated = false;
            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NONNEGATED_EX_EX_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            string actual = accessor.DefaultNonNegatedMessageTemplate;

            //検証
            Assert.AreEqual(val, actual, "メッセージが不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest01()
        {
            //準備
            object objectToValidate = null;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = false;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }


        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが空文字の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest02()
        {
            //準備
            object objectToValidate = string.Empty;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = false;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }


        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが文字列型で文字列長が指定した範囲の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest03()
        {
            //準備
            object objectToValidate = "TERAS";
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = false;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);           

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }


        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが文字列型で文字列長が指定した範囲の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest04()
        {
            //準備
            object objectToValidate = "TERASOLUNA";
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = false;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", currentTarget, 3, "{4}", 6 };
            string expectedMessage = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NONNEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual(r.Target, currentTarget, "Targetが不正です.");
            Assert.IsNull(r.Tag, "Tagが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      

        }


        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが文字列型以外で文字列表現の文字列長が指定した範囲の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest05()
        {
            //準備
            object objectToValidate = 11.11;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = false;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが文字列型以外で文字列表現の文字列長が指定した範囲外の場合、
        /// currentTargetがnullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest06()
        {
            //準備
            object objectToValidate = 11.1111;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = false;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", currentTarget, 3, "{4}", 6 };
            string expectedMessage = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NONNEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual(r.Target, currentTarget, "Targetが不正です.");
            Assert.IsNull(r.Tag, "Tagが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      

        }


        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullの場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest07()
        {
            //準備
            object objectToValidate = null;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = true;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが空文字の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest08()
        {
            //準備
            object objectToValidate = string.Empty;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = true;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが文字列型で文字列長が指定した範囲の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest09()
        {
            //準備
            object objectToValidate = "TERAS";
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = true;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", currentTarget, 3, "{4}", 6 };
            string expectedMessage = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual(r.Target, currentTarget, "Targetが不正です.");
            Assert.IsNull(r.Tag, "Tagが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが文字列型で文字列長が指定した範囲の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest10()
        {
            //準備
            object objectToValidate = "TERASOLUNA";
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = true;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが文字列型以外で文字列表現の文字列長が指定した範囲の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest11()
        {
            //準備
            object objectToValidate = 11.11;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = true;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", currentTarget, 3, "{4}", 6 };
            string expectedMessage = MessageManager.GetMessage("STRING_LENGTH_VALIDATOR_NEGATED_IN_IN_MESSAGETEMPLATE", placeHolder);
            ValidationResult r = resultList.FindFromMessage(expectedMessage);
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual(r.Target, currentTarget, "Targetが不正です.");
            Assert.IsNull(r.Tag, "Tagが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが文字列型以外で文字列表現の文字列長が指定した範囲外の場合、
        /// currentTargetがnullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest12()
        {
            //準備
            object objectToValidate = 11.1111;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = true;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullであり、ValidationResultsがnullの場合、
        /// ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest13()
        {
            //準備
            object objectToValidate = "TERASO";
            object currentTarget = null;
            string key = null;
            ValidationResults results = null;
            int lowerBound = 3;
            RangeBoundaryType lowerBoundType = RangeBoundaryType.Inclusive;
            int upperBound = 6;
            RangeBoundaryType upperBoundType = RangeBoundaryType.Inclusive;
            string messageTemplate = null;
            bool negated = false;

            StringLengthRangeValidator target =
                new StringLengthRangeValidator(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_StringLengthRangeValidatorAccessor(target);

            try
            {
                //実施
                accessor.DoValidate(objectToValidate, currentTarget, key, results);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.IsInstanceOfType(e, typeof(ArgumentNullException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(StringLengthRangeValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(StringLengthRangeValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "validationResults"));
        }
    }
}
