﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Validation;

namespace TERASOLUNA.Fw.CommonUT.Validation
{
 
    [TestClass()]
    /// <summary>
    /// テスト用のヘルパークラスです。
    /// ValidationResultを読み込むListです。
    /// </summary>
 
    public class ValidationResultList : List<ValidationResult>
    {
        public ValidationResultList(IEnumerable<ValidationResult> results)
        {
            foreach (ValidationResult r in results)
            {
                this.Add(r);
            }
        }

        public ValidationResult FindFromMessage(string message)
        {
            return base.Find(delegate(ValidationResult vr) { return vr.Message == message; });
        }

        public ValidationResult FindFromKey(string key)
        {
            return base.Find(delegate(ValidationResult vr) { return vr.Key == key; });
        }
    }
}
