// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using System.Reflection;
using TERASOLUNA.Fw.Common.Logging.TraceSourceLog;

namespace TERASOLUNA.Fw.Common.Logging
{
    /// <summary>
    /// <see cref="ILog"/> NX̃CX^X𐶐t@NgNXłB
    /// </summary>
    public abstract class LogFactory
    {
        /// <summary>
        /// p <see cref="LogFactory"/> NX̌^AvP[V\t@C
        /// 擾邽߂̃L[łB
        /// </summary>
        /// <remarks>
        /// <para>
        /// AvP[V\t@C appSettings vfA̕L[ƂāA
        /// <see cref="LogFactory"/> NX̊SC^擾܂B
        /// </para>
        /// <para>
        /// ̒萔̒l "LogFactoryTypeName" łB
        /// </para>
        /// </remarks>
        protected static readonly string APP_KEY_FACTORY_PROPERTY = "LogFactoryTypeName";

        /// <summary>
        /// <see cref="LogFactory"/> pNX̃VOgCX^XłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private static volatile LogFactory _logFactory = null;

        /// <summary>
        /// bNp̃IuWFNgłB
        /// </summary>
        private static object _syncRoot = new Object();

        /// <summary>
        /// <see cref="LogFactory"/> ^̃NX̃CX^X擾܂B
        /// </summary>
        /// <remarks>
        /// \t@C <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[ƂČ^
        /// LqĂꍇǍ^̃CX^X𐶐܂BLqȂꍇA
        /// <see cref="TraceSourceLogFactory"/> ̃CX^X𐶐܂B
        /// </remarks>
        /// <value><see cref="LogFactory"/> ^̃NX̃CX^XB</value>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^邱Ƃł܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^͒ۃNXłB
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^܂́A<see cref="TraceSourceLogFactory"/> ̃RXgN^ĂяoɎs܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^܂́A<see cref="TraceSourceLogFactory"/> ̃RXgN^ŗO܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^ <see cref="LogFactory"/> ɃLXgł܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// AvP[Vݒf[^i[ NameValueCollection IuWFNg擾ł܂łB
        /// </exception>
        protected static LogFactory Factory
        {
            get
            {
                if (_logFactory == null)
                {
                    lock (_syncRoot)
                    {
                        if (_logFactory == null)
                        {
                            _logFactory = CreateLogFactoryFromAppSettings(
                                APP_KEY_FACTORY_PROPERTY,
                                typeof(TraceSourceLogFactory));
                        }
                    }
                }
                return _logFactory;
            }
        }

        /// <summary>
        /// <see cref="ILog"/> NX̃CX^X擾܂B
        /// </summary>
        /// <param name="className">悤Ƃ <see cref="ILog"/> NX
        /// CX^Xʂ邽߂̕B</param>
        /// <param name="args">
        /// 0 ȏ̃OCX^X𐶐邽߂ɕKvȑΏۃIuWFNg܂ object ^̉ϒB
        /// W <see cref="TraceSourceLogFactory"/> ł́A1 Ԗڂ̃IuWFNĝݗp܂B
        /// </param>
        /// <returns><see cref="ILog"/> NX̃CX^XB</returns>
        /// <remarks>
        /// <list type="number">
        /// <item>
        /// \t@C̐ݒɊÂ <see cref="LogFactory"/> hNX̃VOgCX^X𐶐܂B
        /// CX^X̓LbVĂALbV݂Ȃꍇ͎̂悤ɐ܂B
        /// \t@C <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[ƂČ^
        /// LqĂꍇǍ^̃CX^X𐶐܂BLqȂꍇA
        /// Wł <see cref="TraceSourceLogFactory"/> ̃CX^X𐶐܂B
        /// </item>
        /// <item>
        /// CX^X <seealso cref="GetInstance(string, object[])"/> \bhĂяo <see cref="ILog"/> NX̃CX^X擾܂B
        /// </item>
        /// </list>
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="className"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="args"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="className"/> 󕶎łB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^邱Ƃł܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^͒ۃNXłB
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̃ftHgRXgN^ĂяoɎs܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̃ftHgRXgN^ŗO܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^ <see cref="LogFactory"/> ɃLXgł܂B
        /// </item>
        /// <item>
        /// 擾 <see cref="ILog"/> NX̃CX^X null QƂłB
        /// </item>
        /// </list>
        /// ɉāAW <see cref="TraceSourceLogFactory"/> gṕAȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// \t@CɋLq <see cref="System.Diagnostics.TraceSource"/> ̐ݒ荀ڂsłB
        /// Ox臒lɂ Off, Critical, Error, Warning, Information, Verbose, All ̂ꂩݒ肵ĂB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// \t@C̐ݒ肪słB
        /// </exception>
        public static ILog GetLogger(string className, params object[] args)
        {
            // ̓`FbN
            if (className == null)
            {
                throw new ArgumentNullException("className");
            }

            if (className.Length == 0)
            {
                throw new ArgumentException(string.Format(Properties.Resources.E_EMPTY_STRING, "className"));
            }

            if (args == null)
            {
                throw new ArgumentNullException("args");
            }

            // CX^X̎擾
            ILog result = Factory.GetInstance(className, args);
            if (result == null)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_INSTANCE_CREATION_FAILED, typeof(ILog).FullName));
            }

            return result;
        }

        /// <summary>
        /// <see cref="ILog"/> NX̃CX^X擾܂B
        /// </summary>
        /// <param name="classType">悤Ƃ@<see cref="ILog"/> NX
        /// CX^Xʂ邽߂̃NX̌^B</param>
        /// <param name="args">
        /// 0 ȏ̃OCX^X𐶐邽߂ɕKvȑΏۃIuWFNg܂ object ^̉ϒB
        /// W <see cref="TraceSourceLogFactory"/> ł́A1 Ԗڂ̃IuWFNĝݗp܂B
        /// </param>
        /// <returns><see cref="ILog"/> NX̃CX^XB</returns>
        /// <remarks>
        /// <list type="number">
        /// <item>
        /// \t@C̐ݒɊÂ <see cref="LogFactory"/> hNX̃VOgCX^X𐶐܂B
        /// CX^X̓LbVĂALbV݂Ȃꍇ͎̂悤ɐ܂B
        /// \t@C <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[ƂČ^
        /// LqĂꍇǍ^̃CX^X𐶐܂BLqȂꍇA
        /// Wł <see cref="TraceSourceLogFactory"/> ̃CX^X𐶐܂B
        /// </item>
        /// <item>
        /// CX^X <seealso cref="GetInstance(string, object[])"/> \bhĂяo <see cref="ILog"/> NX̃CX^X擾܂B
        /// </item>
        /// </list>
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="className"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="args"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^邱Ƃł܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^͒ۃNXłB
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̃ftHgRXgN^ĂяoɎs܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̃ftHgRXgN^ŗO܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^ <see cref="LogFactory"/> ɃLXgł܂B
        /// </item>
        /// <item>
        /// 擾 <see cref="ILog"/> NX̃CX^X null QƂłB
        /// </item>
        /// </list>
        /// ɉāAW <see cref="TraceSourceLogFactory"/> gṕAȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// \t@CɋLq <see cref="System.Diagnostics.TraceSource"/> ̐ݒ荀ڂsłB
        /// Ox臒lɂ Off, Critical, Error, Warning, Information, Verbose, All ̂ꂩݒ肵ĂB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// \t@C̐ݒ肪słB
        /// </exception>
        public static ILog GetLogger(Type classType, params object[] args)
        {
            // ̓`FbN
            if (classType == null)
            {
                throw new ArgumentNullException("classType");
            }

            if (args == null)
            {
                throw new ArgumentNullException("args");
            }

            // CX^X̎擾
            ILog result = Factory.GetInstance(classType, args);
            if (result == null)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_INSTANCE_CREATION_FAILED, typeof(ILog).FullName));
            }

            return result;
        }

        /// <summary>
        /// <see cref="ILog"/> NX̃CX^X擾܂B
        /// </summary>
        /// <typeparam name="T"> CX^X󂯂^B</typeparam>
        /// <param name="className">悤Ƃ <see cref="ILog"/> NX
        /// CX^Xʂ邽߂̕B</param>
        /// <param name="args">
        /// 0 ȏ̃OCX^X𐶐邽߂ɕKvȑΏۃIuWFNg܂ object ^̉ϒB
        /// W <see cref="TraceSourceLogFactory"/> ł́A1 Ԗڂ̃IuWFNĝݗp܂B
        /// </param>
        /// <returns><see cref="ILog"/> NX̃CX^XB</returns>
        /// <remarks>
        /// <list type="number">
        /// <item>
        /// \t@C̐ݒɊÂ <see cref="LogFactory"/> hNX̃VOgCX^X𐶐܂B
        /// CX^X̓LbVĂALbV݂Ȃꍇ͎̂悤ɐ܂B
        /// \t@C <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[ƂČ^
        /// LqĂꍇǍ^̃CX^X𐶐܂BLqȂꍇA
        /// Wł <see cref="TraceSourceLogFactory"/> ̃CX^X𐶐܂B
        /// </item>
        /// <item>
        /// CX^X <seealso cref="GetInstance(string, object[])"/> \bhĂяo <see cref="ILog"/> NX̃CX^X擾܂B
        /// </item>
        /// </list>
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="className"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="args"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="className"/> 󕶎łB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^邱Ƃł܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^͒ۃNXłB
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̃ftHgRXgN^ĂяoɎs܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̃ftHgRXgN^ŗO܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^ <see cref="LogFactory"/> ɃLXgł܂B
        /// </item>
        /// <item>
        /// 擾 <see cref="ILog"/> NX̃CX^X null QƂłB
        /// </item>
        /// <item>
        /// 擾 <see cref="ILog"/> NX̃CX^X <typeparamref name="T"/> ɃLXgł܂B
        /// </item>
        /// </list>
        /// ɉāAW <see cref="TraceSourceLogFactory"/> gṕAȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// \t@CɋLq <see cref="System.Diagnostics.TraceSource"/> ̐ݒ荀ڂsłB
        /// Ox臒lɂ Off, Critical, Error, Warning, Information, Verbose, All ̂ꂩݒ肵ĂB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// \t@C̐ݒ肪słB
        /// </exception>
        public static T GetLogger<T>(string className, params object[] args) where T : class, ILog
        {
            // ̓`FbN
            if (className == null)
            {
                throw new ArgumentNullException("className");
            }

            if (className.Length == 0)
            {
                throw new ArgumentException(string.Format(Properties.Resources.E_EMPTY_STRING, "className"));
            }

            if (args == null)
            {
                throw new ArgumentNullException("args");
            }

            // CX^X̎擾
            ILog logger = Factory.GetInstance(className, args);
            if (logger == null)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_INSTANCE_CREATION_FAILED, typeof(ILog).FullName));
            }

            T result = logger as T;
            if (result == null)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_INVALID_CAST, logger.GetType().FullName, typeof(T).FullName));
            }

            return result;
        }

        /// <summary>
        /// <see cref="ILog"/> NX̃CX^X擾܂B
        /// </summary>
        /// <typeparam name="T"> CX^X󂯂^B</typeparam>
        /// <param name="classType">悤Ƃ <see cref="ILog"/> NX
        /// CX^Xʂ邽߂̃NX̌^B</param>
        /// <param name="args">
        /// 0 ȏ̃OCX^X𐶐邽߂ɕKvȑΏۃIuWFNg܂ object ^̉ϒB
        /// W <see cref="TraceSourceLogFactory"/> ł́A1 Ԗڂ̃IuWFNĝݗp܂B
        /// </param>
        /// <returns><see cref="ILog"/> NX̃CX^XB</returns>
        /// <remarks>
        /// <list type="number">
        /// <item>
        /// \t@C̐ݒɊÂ <see cref="LogFactory"/> hNX̃VOgCX^X𐶐܂B
        /// CX^X̓LbVĂALbV݂Ȃꍇ͎̂悤ɐ܂B
        /// \t@C <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[ƂČ^
        /// LqĂꍇǍ^̃CX^X𐶐܂BLqȂꍇA
        /// Wł <see cref="TraceSourceLogFactory"/> ̃CX^X𐶐܂B
        /// </item>
        /// <item>
        /// CX^X <seealso cref="GetInstance(string, object[])"/> \bhĂяo <see cref="ILog"/> NX̃CX^X擾܂B
        /// </item>
        /// </list>
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="className"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="args"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^邱Ƃł܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^͒ۃNXłB
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̃ftHgRXgN^ĂяoɎs܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̃ftHgRXgN^ŗO܂B
        /// </item>
        /// <item>
        /// <seealso cref="APP_KEY_FACTORY_PROPERTY"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^ <see cref="LogFactory"/> ɃLXgł܂B
        /// </item>
        /// <item>
        /// 擾 <see cref="ILog"/> NX̃CX^X null QƂłB
        /// </item>
        /// <item>
        /// 擾 <see cref="ILog"/> NX̃CX^X <typeparamref name="T"/> ɃLXgł܂B
        /// </item>
        /// </list>
        /// ɉāAW <see cref="TraceSourceLogFactory"/> gṕAȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// \t@CɋLq <see cref="System.Diagnostics.TraceSource"/> ̐ݒ荀ڂsłB
        /// Ox臒lɂ Off, Critical, Error, Warning, Information, Verbose, All ̂ꂩݒ肵ĂB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// \t@C̐ݒ肪słB
        /// </exception>
        public static T GetLogger<T>(Type classType, params object[] args) where T : class, ILog
        {
            // ̓`FbN
            if (classType == null)
            {
                throw new ArgumentNullException("classType");
            }

            if (args == null)
            {
                throw new ArgumentNullException("args");
            }

            // CX^X̎擾
            ILog logger = Factory.GetInstance(classType, args);
            if (logger == null)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_INSTANCE_CREATION_FAILED, typeof(ILog).FullName));
            }

            T result = logger as T;
            if (result == null)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_INVALID_CAST, logger.GetType().FullName, typeof(T).FullName));
            }

            return result;
        }

        /// <summary>
        /// AvP[V\t@CAL[w肵Č^擾AtNVp
        /// CX^X𐶐܂B^擾łȂꍇA<paramref name="defaultType"/> Ŏw
        /// ꂽ<see cref="Type"/>̃CX^X𐶐܂B
        /// </summary>
        /// <param name="appSettingsKey">AvP[V\t@C^擾邽߂ɗpL[
        /// B</param>
        /// <param name="defaultType">AvP[V\t@C^擾łȂꍇA
        /// p^B</param>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^邱Ƃł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^ۃNXłB
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>      
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̃RXgN^ĂяoɎs܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^̃RXgN^ŗO܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@C appSettings vf́A value l
        /// ^ <see cref="LogFactory"/> ɃLXgł܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// AvP[Vݒf[^i[ NameValueCollection IuWFNg擾ł܂łB
        /// </exception>
        /// <returns>ꂽCX^XB</returns>
        protected static LogFactory CreateLogFactoryFromAppSettings(
            string appSettingsKey, Type defaultType)
        {
            // ^AvP[V\t@C擾B
            string typeName = ConfigurationManager.AppSettings[appSettingsKey];

            LogFactory logFactory = null;

            // ^CX^X擾B
            // ^null܂͋󕶎̏ꍇAdefaultType^ƂėpB
            Type type = null;
            if (!string.IsNullOrEmpty(typeName))
            {
                try
                {
                    type = Type.GetType(typeName, true);
                }
                catch (Exception e)
                {
                    throw new TerasolunaException(string.Format(
                        Properties.Resources.E_TYPE_LOAD_FAILED, typeName), e);
                }
            }
            else
            {
                type = defaultType;
            }

            logFactory = CreateLogFactoryByType(type);
            return logFactory;
        }

        /// <summary>
        /// ^w肵AtNVpăCX^X𐶐܂B
        /// </summary>
        /// <param name="targetType">CX^X̌^B</param>
        /// <returns>ꂽCX^XB</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="targetType"/>  null QƂłB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="targetType"/> ۃNXłB
        /// </item>
        /// <item>
        /// <paramref name="targetType"/> ̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <paramref name="targetType"/> ̃RXgN^ĂяoɎs܂B
        /// </item>
        /// <item>
        /// <paramref name="targetType"/> ̃RXgN^ŗO܂B
        /// </item>
        /// <item>
        /// <paramref name="targetType"/>  <see cref="LogFactory"/> ɃLXgł܂B
        /// </item>
        /// </list>
        /// </exception>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods")]
        protected static LogFactory CreateLogFactoryByType(Type targetType)
        {
            // ̓`FbN
            if (targetType.IsAbstract)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_PARAM_ABSTRACT_TYPE,
                    "targetType",
                    targetType.AssemblyQualifiedName));
            }

            // WFlbN^Ō^p[^ݒ肳ĂȂꍇB
            if (targetType.ContainsGenericParameters)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_PARAM_GENERIC_TYPE,
                    "targetType",
                    targetType.AssemblyQualifiedName));
            }

            // ^targetTypẽCX^X𐶐B
            // publicňȂRXgN^݂KvB
            LogFactory result = null;

            try
            {
                result = Activator.CreateInstance(targetType) as LogFactory;
            }
            catch (MemberAccessException e)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_MEMBER_ACCESS_EXCEPTION,
                    targetType.FullName), e);
            }
            catch (TargetInvocationException e)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_TARGET_INVOCATION_EXCEPTION,
                    targetType.FullName), e);
            }

            if (result == null)
            {
                throw new TerasolunaException(string.Format(
                    Properties.Resources.E_INVALID_CAST,
                    targetType.FullName, typeof(LogFactory).FullName));
            }

            return result;
        }

        /// <summary>
        /// <see cref="ILog"/> NX̃CX^X擾郁\bh̒ۃ\bhłB
        /// </summary>
        /// <param name="className">CX^X̌^̕B</param>
        /// <param name="args">0 ȏ̃OCX^X𐶐邽߂ɕKvȑΏۃIuWFNg܂ object ^̉ϒB</param>
        /// <returns><see cref="ILog"/> NX̃CX^XłB</returns>
        protected abstract ILog GetInstance(string className, params object[] args);

        /// <summary>
        /// <see cref="ILog"/> NX̃CX^X擾郁\bh̒ۃ\bhłB
        /// </summary>
        /// <param name="classType">CX^X̌^B</param>
        /// <param name="args">0 ȏ̃OCX^X𐶐邽߂ɕKvȑΏۃIuWFNg܂ object ^̉ϒB</param>
        /// <returns><see cref="ILog"/>NX̃CX^XłB</returns>
        protected abstract ILog GetInstance(Type classType, params object[] args);
    }
}
