/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.dao.ibatis;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.dao.SqlHolder;
import jp.terasoluna.fw.dao.UpdateDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.ibatis.SqlMapClientCallback;
import org.springframework.orm.ibatis.SqlMapClientTemplate;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.ibatis.sqlmap.client.SqlMapExecutor;

/**
 * UpdateDAOC^tF[XiBATISpNXB
 * <p/>
 * ̃NX́ABean`t@CBean`sT[rXw
 * CWFNVĎgpBȉɐݒႨюB<br/>
 * <p/>
 * <b>ӓ_</b><br/>
 * executeBatchiBATIS̃ob`s@\gpĂB
 * executeBatch̖߂ĺAsSQLɂύXsԋp邪A
 * java.sql.PreparedStatementgpĂ邽߁A
 * hCoɂ萳mȍs擾łȂP[XB<br/>
 * ύXsmɎ擾łȂhCogpꍇA
 * ύXsgUNVɉe^Ɩł
 * (ύXs0̏ꍇG[P[X)A
 * ob`XV͎gpȂƁB<br/>
 * Qlj<br/>
 * <a href="http://otndnld.oracle.co.jp/document/products/oracle10g/101/doc_v5/java.101/B13514-02.pdf#page=450"
 * target="_blank">
 * http://otndnld.oracle.co.jp/document/products/oracle10g/101/doc_v5/java.101/B13514-02.pdf</a>
 * <br/>
 * 450y[WuWob`Oracle ̍XVvQƂ̂ƁB<br/>
 * 
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * Bean`t@C̗
 * </legend>
 * <p/>
 * <code>
 * &lt;bean id="registBLogic"
 * class="jp.strutspring.blogic.RegistBLogic"&gt;<br/>
 * &nbsp;&nbsp;&lt;property
 * name="dao"&gt;&lt;ref local="<b>updateDAO</b>"/&gt;
 * &lt;/property&gt;<br/>
 * &lt;/bean&gt;<br/>
 * <br/>
 * &lt;bean id="<b>updateDAO</b>"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;
 * class="<b>jp.terasoluna.
 * fw.dao.ibatis.UpdateDAOiBATISImpl</b>"&gt;<br/>
 * &nbsp;&nbsp;&lt;property name="sqlMapClient"&gt;
 * &lt;ref local="sqlMapClient"/&gt;&lt;/property&gt;<br/>
 * &lt;/bean&gt;<br/>
 * <br/>
 * &lt;bean id="sqlMapClient"<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * class="org.springframework.orm.ibatis.SqlMapClientFactoryBean"&gt;<br/>
 * &nbsp;&nbsp;&lt;property name="configLocation"&gt;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;value&gt;sqlMapConfig.xml&lt;/value&gt;<br/>
 * &nbsp;&nbsp;&lt;/property&gt;<br/>
 * &lt;/bean&gt;
 * </code>
 * </fieldset>
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * T[rXwł̎gp@Ff[^ꌏ̍XV
 * </legend>
 * <p/>
 * <code>
 * public class RegistBLogic {<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;private UpdateDAO dao = null;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;public UpdateDAO getDao() {<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return dao;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;}<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;public void setDao(UpdateDAO dao) {<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;this.dao = dao;<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;}<br/>
 * <br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;public String execute() {<br/>
 * <br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * UserBean bean = new UserBean();<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;bean.setId("1");<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;bean.setName("N.OUNO");<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;bean.setAge("20");<br/>
 * <br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 * <b>dao.execute("insertUser", bean);</b><br/>
 * <br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;...<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;return "success";<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;}<br/>
 * }
 * </code>
 * </fieldset>
 * <p/>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>
 * T[rXwł̎gp@FICob`
 * </legend>
 * <p/>
 * <code>
 * public String execute() {<br/>
 * <br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;List&lt;SqlHolder&gt; sqlHolders = new ArrayList&lt;SqlHolder&gt;();<br/>
 * <br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;UserBean bean = new UserBean();<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;bean.setId("1");<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;bean.setName("N.OUNO");<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;bean.setAge("20");<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;SqlHolder holder = new SqlHolder("insertUser", bean);<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;sqlHolders.add(holder);<br/>
 * <br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;UserBean bean2 = new UserBean();<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;bean.setId("2");<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;bean.setName("K.FUJIMOTO");<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;bean.setAge("21");<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;SqlHolder holder2 = new SqlHolder("insertUser", bean2);<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;sqlHolders.add(holder2);<br/>
 * <br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;<b>dao.executeBatch(sqlHolders);</b><br/>
 * <br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;...<br/>
 * &nbsp;&nbsp;&nbsp;&nbsp;return "success";<br/>
 * }
 * </code>
 * </fieldset>
 * <p/>
 *
 */
public class UpdateDAOiBatisImpl extends SqlMapClientDaoSupport implements
        UpdateDAO {
    /**
     * OCX^X
     */
    static Log log
        = LogFactory.getLog(UpdateDAOiBatisImpl.class);

    /**
     * ob`spSQL
     * @deprecated ̕ϐ͏폜܂
     */
    @Deprecated
    protected final ThreadLocal<List<SqlHolder>> batchSqls 
        = new ThreadLocal<List<SqlHolder>>();
    
    /**
     * sqlIDŎw肳ꂽSQLsāAʌԋpB
     * sSQĹuinsert, update deletev3ނƂB
     *
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @return SQL̎sʌԋp
     */
    public int execute(String sqlID, Object bindParams) {

        if (log.isDebugEnabled()) {
            log.debug("execute Start.");
        }

        //SqlMapClient̎擾
        SqlMapClientTemplate sqlMapTemp = getSqlMapClientTemplate();

        // SQL̎sFf[^ǉB
        int row = sqlMapTemp.update(sqlID, bindParams);

        if (log.isDebugEnabled()) {
            log.debug("execute End. success count:" + row);
        }
        return row;
    }

    /**
     * ob`ǉ\bhB
     * SQLXbh[JɕێB
     * ̃NGXg܂SQLێ邱Ƃ͂łȂB
     * ǉɁA<code>UpdateDAO#executeBatch()</code>ŁAꊇssB
     * 
     * <b>ӁF</b>̃\bhgpƁAob`XVΏۂSQL
     * NAȂ\B{@link #executeBatch(List)}gp邱ƁB
     *
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @deprecated addBatch̑{@link #executeBatch(List)}
     * gp邱
     */
    @SuppressWarnings("deprecation")
    @Deprecated
    public void addBatch(final String sqlID, final Object bindParams) {
        // Xbh[J̎擾
        List<SqlHolder> sqlHolders = batchSqls.get();
        if (sqlHolders == null) {
            sqlHolders = new ArrayList<SqlHolder>();
            batchSqls.set(sqlHolders);
            if (log.isDebugEnabled()) {
                log.debug("Create new SqlHolder in ThreadLocal.");
            }
        }
        
        // ob`pSQLXbh[Jɕێ    
        sqlHolders.add(new SqlHolder(sqlID, bindParams));
        if (log.isDebugEnabled()) {
            log.debug("Add batch sql.  SQL_ID='" + sqlID 
                    + "' Parameters:" + bindParams);
        }
    }

    /**
     * ob`̎s\bhB
     * <code>{@link #addBatch(String, Object)}</code>ŒǉꂽSQL
     * ꊇsBob`sSQLNAB
     * <code>{@link #addBatch(String, Object)}</code>SQLǉĂȂꍇA
     * sOB
     * 
     * <b>ӁF</b>̃\bhgpƁAob`XVΏۂSQL
     * NAȂ\B{@link #executeBatch(List)}gp邱ƁB
     *
     * @return SQL̎s
     * @deprecated addBatch̑{@link #executeBatch(List)}
     * gp邱
     */
    @SuppressWarnings("deprecation")
    @Deprecated
    public int executeBatch() {
        // Xbh[JSQLo
        final List<SqlHolder> sqlHolders = batchSqls.get();
        
        // SQLob`s
        Integer result = 0;
        try {
            result = (Integer) getSqlMapClientTemplate().execute(
                    new SqlMapClientCallback() {
                public Object doInSqlMapClient(SqlMapExecutor executor)
                      throws SQLException {
                    StringBuilder logStr = new StringBuilder();
                    if (log.isDebugEnabled()) {
                        log.debug("Batch SQL count:" + sqlHolders.size());
                    }
                    executor.startBatch();
                    for (SqlHolder sqlHolder : sqlHolders) {
                        executor.update(
                            sqlHolder.getSqlID(), sqlHolder.getBindParams());
                        
                        if (log.isDebugEnabled()) {
                            logStr.setLength(0);
                            logStr.append("Call update sql. - SQL_ID:'");
                            logStr.append(sqlHolder.getSqlID());
                            logStr.append("' Parameters:");
                            logStr.append(sqlHolder.getBindParams());
                            log.debug(logStr.toString());
                        }
                    }
                    return executor.executeBatch();
                }
            });
        } finally {
            // Xbh[JSQL폜
            batchSqls.remove();
            if (log.isDebugEnabled()) {
                log.debug("Remove SqlHolder in ThreadLocal.");
            }
        }
        
        if (log.isDebugEnabled()) {
            log.debug("ExecuteBatch complete. Result:" + result);
        }
        return result.intValue();
    }

    /**
     * ob`̎s\bhB<br/>
     * 
     * {@link SqlHolder}̃XgŎw肳ꂽׂĂSQLsB<br/>
     * 
     * <br/>
     * <b>ӓ_</b><br/>
     * executeBatchiBATIS̃ob`s@\gpĂB
     * executeBatch̖߂ĺAsSQLɂύXsԋp邪A
     * java.sql.PreparedStatementgpĂ邽߁A
     * hCoɂ萳mȍs擾łȂP[XB<br/>
     * ύXsmɎ擾łȂhCogpꍇA
     * ύXsgUNVɉe^Ɩł
     * (ύXs0̏ꍇG[P[X)A
     * ob`XV͎gpȂƁB<br/>
     * Qlj<br/>
     * <a href="http://otndnld.oracle.co.jp/document/products/oracle10g/101/doc_v5/java.101/B13514-02.pdf#page=450"
     * target="_blank">
     * http://otndnld.oracle.co.jp/document/products/oracle10g/101/doc_v5/java.101/B13514-02.pdf</a>
     * <br/>
     * 450y[WuWob`Oracle ̍XVvQƂ̂ƁB<br/>
     * 
     * @param sqlHolders ob`XVΏۂsqlIdAp[^i[
     * SqlHolderCX^X̃Xg
     * @return SQL̎sʌ
     */
    public int executeBatch(final List<SqlHolder> sqlHolders) {
        // SQLob`s
        Integer result = 0;
        result = (Integer) getSqlMapClientTemplate().execute(
                new SqlMapClientCallback() {
            public Object doInSqlMapClient(SqlMapExecutor executor)
                  throws SQLException {
                StringBuilder logStr = new StringBuilder();
                if (log.isDebugEnabled()) {
                    log.debug("Batch SQL count:" + sqlHolders.size());
                }
                executor.startBatch();
                for (SqlHolder sqlHolder : sqlHolders) {
                    executor.update(
                        sqlHolder.getSqlID(), sqlHolder.getBindParams());
                    
                    if (log.isDebugEnabled()) {
                        logStr.setLength(0);
                        logStr.append("Call update sql. - SQL_ID:'");
                        logStr.append(sqlHolder.getSqlID());
                        logStr.append("' Parameters:");
                        logStr.append(sqlHolder.getBindParams());
                        log.debug(logStr.toString());
                    }
                }
                return executor.executeBatch();
            }
        });
        
        if (log.isDebugEnabled()) {
            log.debug("ExecuteBatch complete. Result:" + result);
        }
        return result.intValue();
    }
}
