/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.DomainCombiner;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.jxpath.JXPathIntrospector;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.beans.jxpath.JXPATH152PatchActivator} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * commons-JXPath̃oO(JXPATH-152)ppb`ANeBx[gNXB<br>
 * OF<br>
 * ẼeXgsہAJVM̃ZLeB}l[WLɂȂ<br>
 * ẼeXgsہAJVMœɑ̃eXgsȂ<br>
 *   (ꎞIɃZLeB}l[WLɂ邽߁ALɂȂĂԂɑ̃eXg삷ƁA
 *    ̃eXgŃG[\B
 *    ȂAɎsȂ΁AJVMłƂ瑼̃eXgsĂ悢B)<br>
 * ẼeXgsہAJRẼZLeB|V[t@C<br>
 *   (ftHgł́AJRECXg[fBNg/lib/security/java.policy)ɂāA<br>
 *   permission java.lang.reflect.ReflectPermission "suppressAccessChecks";<br>
 *   ̌^ȂƁB(CXg[̏Ԃ̂܂܂ł΁Ǎ͂ȂB)<br>
 * ẼeXgsہAeXgΏۂƂȂclasst@CƁAeXgP[Xclasst@ĆÃfBNgɏo͂ȂƁB
 * <p>
 * 
 * @see jp.terasoluna.fw.beans.jxpath.JXPATH152PatchActivator
 */
@SuppressWarnings("unchecked")
public class JXPATH152PatchActivatorTest extends TestCase {

    private Map byClassBak = null;

    private Map byInterfaceBak = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(JXPATH152PatchActivatorTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();

        // NX[hĂȂ΃NX[h
        // (NX[hstaticCjVCUs)
        new JXPATH152PatchActivator();

        // JXPATH152PatchActivatorstaticCjVCUs̏Ԃێ
        // (tearDownstaticCjVCUsȌԂɖ߂Ă܂Ȃ悤)
        byClassBak = (Map) UTUtil.getPrivateField(JXPathIntrospector.class, "byClass");
        byInterfaceBak = (Map) UTUtil.getPrivateField(JXPathIntrospector.class, "byInterface");
        LogUTUtil.flush();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        UTUtil.setPrivateField(JXPathIntrospector.class, "byClass", byClassBak);
        UTUtil.setPrivateField(JXPathIntrospector.class, "byInterface", byInterfaceBak);
    }

    /**
     * testActivate01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() |<br>
     *         () JXPathIntrospector.byClasst:HashMap<br>
     *         () JXPathIntrospector.byInterface:HashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) JXPathIntrospector.byClassHashMapForJXPathIntrospectorɂȂĂB<br>
     *         (ԕω) JXPathIntrospector.byInterfaceHashMapForJXPathIntrospectorɂȂĂB<br>
     *         (ԕω) O:OxFINFO<br>
     *                    JXPATH-152 Patch activation succeeded.<br>
     *         
     * <br>
     * ZLeB}l[Wɑj~Ȃ΁A
     * JXPathIntrospectorbyClassbyInterfaceHashMapForJXPathIntrospectorCX^XɂȂĂ邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testActivate01() throws Exception {
        // O
        UTUtil.setPrivateField(JXPathIntrospector.class, "byClass", new HashMap());
        UTUtil.setPrivateField(JXPathIntrospector.class, "byInterface", new HashMap());

        // eXg{
        UTUtil.invokePrivate(JXPATH152PatchActivator.class, "activate");

        // 
        assertTrue(LogUTUtil.checkInfo("JXPATH-152 Patch activation succeeded."));
        assertTrue(UTUtil.getPrivateField(JXPathIntrospector.class, "byClass").getClass() == HashMapForJXPathIntrospector.class);
        assertTrue(UTUtil.getPrivateField(JXPathIntrospector.class, "byInterface").getClass() == HashMapForJXPathIntrospector.class);
    }

    /**
     * testActivate01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() |<br>
     *         () JXPathIntrospector.byClasst:HashMap<br>
     *         () JXPathIntrospector.byInterface:HashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) JXPathIntrospector.byClassHashMap̂܂܁B<br>
     *         (ԕω) JXPathIntrospector.byInterfaceHashMap̂܂܁B<br>
     *         (ԕω) O:OxFFATAL<br>
     *                    JXPATH-152 Patch activation failed.<br>
     *         
     * <br>
     * ZLeB}l[Wɑj~ꂽꍇA
     * FATALOo͂邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testActivate02() throws Exception {
        // ANZXݒ
        final ProtectionDomain testTargetProtectionDomain = JXPATH152PatchActivator.class.getProtectionDomain();
        DomainCombiner domainCombiner = new DomainCombiner() {
            public ProtectionDomain[] combine(
                    ProtectionDomain[] currentDomains,
                    ProtectionDomain[] assignedDomains) {
                ProtectionDomain[] ret = new ProtectionDomain[currentDomains.length];
                for (int i = 0; i < currentDomains.length ;i++) {
                    // eXgP[XNX⃉CuɂNXA
                    // ΏۃNX(܂܂NXpXɂNX)ȊÓASɑ΂錠^
                    if (currentDomains[i].getCodeSource() != testTargetProtectionDomain.getCodeSource()) {
                        Permissions permissions = new Permissions();
                        permissions.add(new AllPermission());
                        ProtectionDomain pd = new ProtectionDomain(currentDomains[i].getCodeSource(), permissions);
                        ret[i] = pd;
                    } else {
                        // ΏۃNX(܂܂NXpXɂNX)́AftHǧ̂܂
                        // (Field#setAccessible֎~)
                        ret[i] = currentDomains[i];
                    }
                }
                return ret;
            }
        };
        AccessControlContext acc = new AccessControlContext(AccessController.getContext(), domainCombiner);
        System.setSecurityManager(new SecurityManager());

        // LDomainCombinerŕҏWANZXݒŁAeXgs
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>() {

            public Void run() throws Exception {
                try {
                    // O
                    UTUtil.setPrivateField(JXPathIntrospector.class, "byClass", new HashMap());
                    UTUtil.setPrivateField(JXPathIntrospector.class, "byInterface", new HashMap());

                    // eXg{
                    UTUtil.invokePrivate(JXPATH152PatchActivator.class, "activate");

                    // 
                    assertTrue(LogUTUtil.checkFatal("JXPATH-152 Patch activation failed.", new AccessControlException("")));
                    assertTrue(UTUtil.getPrivateField(JXPathIntrospector.class, "byClass").getClass() == HashMap.class);
                    assertTrue(UTUtil.getPrivateField(JXPathIntrospector.class, "byInterface").getClass() == HashMap.class);
                } finally {
                    System.setSecurityManager(null);
                }
                
                return null;
            }
            
        }, acc);
    }
}
