/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;


/**
 * f[^x[XXVp̃NXB
 * 
 */
class DBUpdateObject extends DBObject {

    /**
     * f[^x[X̍XV(SQL INSERT/UPDATE/DELETE)̔ssB
     * 
     * @return XV̎sʁiʏ͍XVꂽsj
     * @throws SQLException
     */
    public int update() throws SQLException {

        PreparedStatement pstmt = null;
        int result = 0;
        try {
            // Xe[gg̎擾
            pstmt = getConnection().prepareStatement(sql);

            // XV̎s
            bindParams(pstmt);
            result = pstmt.executeUpdate();
        } finally {
            params.clear();
            if (pstmt != null) {
                try {
                    pstmt.close();
                } catch (SQLException e) {
                    // Ȃ
                }
            }
        }
        return result;
    }

    /**
     * p[^̐ݒ
     * 
     * @param index p[^̃CfbNXl
     * @param param p[^l
     * @param type p[^JDBC_SQL^
     * @throws SQLException
     */
    public void setParam(int index, String param, int type)
        throws SQLException {

        // tE^ ȊȌꍇ
        if (type != java.sql.Types.TIME
            && type != java.sql.Types.DATE
            && type != java.sql.Types.TIMESTAMP && type != java.sql.Types.NUMERIC ) {

            setString(index, param);
            return;
        }

        if(type == java.sql.Types.NUMERIC){
            setInt(index,Integer.valueOf(param ));
            return;
        }
        
        // tE^̏ꍇ
        if (param == null) {
            setTimestamp(index, null);
        } else {
            java.util.Date date = null;
            date = parseDate("yyyy-MM-dd HH:mm:ss", param);
            if (date == null) {
                date = parseDate("yyyy-MM-dd", param);
            }
            if (date == null) {
                date = parseDate("HH:mm:ss", param);
            }
            if (date == null) {
                String msg = "t܂͎ɒlϊł܂B";
                throw new IllegalArgumentException(msg);
            }
            setTimestamp(index, new Timestamp(date.getTime()));
        }
    }

    /**
     * tẼp[XB
     * 
     * @param format ϊtH[}bg
     * @param value ϊ
     * @return ϊꂽtBϊłȂꍇnullԂB
     */
    private java.util.Date parseDate(String format, String value) {
        java.util.Date date = null;
        try {
            SimpleDateFormat f = new SimpleDateFormat(format);
            date = f.parse(value);
        } catch (ParseException e) {
            // Ȃ
        }
        return date;
    }

}
