/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.Cache;
import org.castor.cache.CacheAcquireException;

public final class DebuggingCacheProxy
implements Cache {
    private Cache _cache;
    private Log _log;

    public DebuggingCacheProxy(Cache cache) {
        this._cache = cache;
    }

    public void initialize(Properties params) throws CacheAcquireException {
        this._cache.initialize(params);
        this._log = LogFactory.getLog(this._cache.getClass());
        this._log.debug((Object)(this.getType() + ".initialize() [" + this.getName() + "]"));
    }

    public void close() {
        this._log.debug((Object)(this.getType() + ".close() [" + this.getName() + "]"));
        this._cache.close();
    }

    public String getType() {
        return this._cache.getType();
    }

    public String getName() {
        return this._cache.getName();
    }

    public void expire(Object key) {
        this._log.debug((Object)(this.getType() + ".expire(" + key + ") [" + this.getName() + "]"));
        this._cache.expire(key);
    }

    public void expireAll() {
        this._log.debug((Object)(this.getType() + ".expireAll() [" + this.getName() + "]"));
        this._cache.expireAll();
    }

    public int size() {
        this._log.debug((Object)(this.getType() + ".size() [" + this.getName() + "]"));
        return this._cache.size();
    }

    public boolean isEmpty() {
        this._log.debug((Object)(this.getType() + ".isEmpty() [" + this.getName() + "]"));
        return this._cache.isEmpty();
    }

    public boolean containsKey(Object key) {
        this._log.debug((Object)(this.getType() + ".containsKey(" + key + ") [" + this.getName() + "]"));
        return this._cache.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this._log.debug((Object)(this.getType() + ".containsValue(" + value + ") [" + this.getName() + "]"));
        return this._cache.containsValue(value);
    }

    public Object get(Object key) {
        this._log.debug((Object)(this.getType() + ".get(" + key + ") [" + this.getName() + "]"));
        return this._cache.get(key);
    }

    public Object put(Object key, Object value) {
        this._log.debug((Object)(this.getType() + ".put(" + key + ", " + value + ") [" + this.getName() + "]"));
        return this._cache.put(key, value);
    }

    public Object remove(Object key) {
        this._log.debug((Object)(this.getType() + ".remove(" + key + ") [" + this.getName() + "]"));
        return this._cache.remove(key);
    }

    public void putAll(Map map) {
        this._log.debug((Object)(this.getType() + ".putAll(" + map + ") [" + this.getName() + "]"));
        this._cache.putAll(map);
    }

    public void clear() {
        this._log.debug((Object)(this.getType() + ".clear() [" + this.getName() + "]"));
        this._cache.clear();
    }

    public Set keySet() {
        this._log.debug((Object)(this.getType() + ".keySet() [" + this.getName() + "]"));
        return this._cache.keySet();
    }

    public Collection values() {
        this._log.debug((Object)(this.getType() + ".values() [" + this.getName() + "]"));
        return this._cache.values();
    }

    public Set entrySet() {
        this._log.debug((Object)(this.getType() + ".entrySet() [" + this.getName() + "]"));
        return this._cache.entrySet();
    }
}

