/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.oxm.xsd.xerces;

import jp.terasoluna.fw.oxm.xsd.exception.ErrorReporterNotFoundException;
import jp.terasoluna.fw.oxm.xsd.xerces.XMLErrorReporterEx;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;

public class XMLSchemaValidatorEx
extends XMLSchemaValidator {
    private static Log log = LogFactory.getLog(XMLSchemaValidatorEx.class);
    private XMLErrorReporterEx reporter = null;

    public XMLSchemaValidatorEx(XMLErrorReporterEx reporter) {
        this.reporter = reporter;
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.reporter == null) {
            log.error((Object)"ErrorReporterEx is not found.");
            throw new ErrorReporterNotFoundException();
        }
        String pushStr = this.reporter.indexResolve(element.rawname);
        this.reporter.getTagStack().push(pushStr);
        super.startElement(element, attributes, augs);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        super.endElement(element, augs);
        if (this.reporter == null) {
            log.error((Object)"ErrorReporterEx is not found.");
            throw new ErrorReporterNotFoundException();
        }
        this.reporter.getTagStack().pop();
    }
}

