/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSInteger
extends XSPatternBase {
    Integer maxInclusive = null;
    Integer maxExclusive = null;
    Integer minInclusive = null;
    Integer minExclusive = null;
    private int _totalDigits = -1;
    private static JType jType = JType.INT;
    private boolean _asWrapper = false;

    public XSInteger() {
        this(false);
    }

    public XSInteger(boolean asWrapper) {
        super((short)32);
        this._asWrapper = asWrapper;
        jType = this._asWrapper ? new JClass("java.lang.Integer") : JType.INT;
    }

    public JType getJType() {
        return jType;
    }

    public Integer getMaxExclusive() {
        return this.maxExclusive;
    }

    public Integer getMaxInclusive() {
        return this.maxInclusive;
    }

    public Integer getMinExclusive() {
        return this.minExclusive;
    }

    public Integer getMinInclusive() {
        return this.minInclusive;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(int max) {
        this.maxExclusive = new Integer(max);
        this.maxInclusive = null;
    }

    public void setMaxExclusive(Integer max) {
        this.maxExclusive = max;
        this.maxInclusive = null;
    }

    public void setMaxInclusive(int max) {
        this.maxInclusive = new Integer(max);
        this.maxExclusive = null;
    }

    public void setMaxInclusive(Integer max) {
        this.maxInclusive = max;
        this.maxExclusive = null;
    }

    public void setMinExclusive(int min) {
        this.minExclusive = new Integer(min);
        this.minInclusive = null;
    }

    public void setMinExclusive(Integer min) {
        this.minExclusive = min;
        this.minInclusive = null;
    }

    public void setMinInclusive(int min) {
        this.minInclusive = new Integer(min);
        this.minExclusive = null;
    }

    public void setMinInclusive(Integer min) {
        this.minInclusive = min;
        this.minExclusive = null;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSInteger.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toInt());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toInt());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toInt());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toInt());
                continue;
            }
            if ("pattern".equals(name)) {
                this.setPattern(facet.getValue());
                continue;
            }
            if (!"totalDigits".equals(name)) continue;
            this.setTotalDigits(facet.toInt());
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        StringBuffer sb = new StringBuffer("new java.lang.Integer(");
        sb.append(variableName);
        sb.append(")");
        return sb.toString();
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.lang.Integer)");
        sb.append(variableName);
        if (this._asWrapper) {
            sb.append(")");
        } else {
            sb.append(").intValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        int totalDigits;
        String pattern;
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("org.exolab.castor.xml.validators.IntegerValidator typeValidator = new org.exolab.castor.xml.validators.IntegerValidator();");
        if (this.hasMinimum()) {
            Integer min = this.getMinExclusive();
            if (min != null) {
                jsc.add("typeValidator.setMinExclusive(");
            } else {
                min = this.getMinInclusive();
                jsc.add("typeValidator.setMinInclusive(");
            }
            jsc.append(min.toString());
            jsc.append(");");
        }
        if (this.hasMaximum()) {
            Integer max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("typeValidator.setMaxExclusive(");
            } else {
                max = this.getMaxInclusive();
                jsc.add("typeValidator.setMaxInclusive(");
            }
            jsc.append(max.toString());
            jsc.append(");");
        }
        if (fixedValue != null) {
            if (jType == JType.INT) {
                Integer.parseInt(fixedValue);
            }
            jsc.add("typeValidator.setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        if ((pattern = this.getPattern()) != null) {
            jsc.add("typeValidator.setPattern(\"");
            jsc.append(XSInteger.escapePattern(pattern));
            jsc.append("\");");
        }
        if ((totalDigits = this.getTotalDigits()) != -1) {
            jsc.add("typeValidator.setTotalDigits(");
            jsc.append(Integer.toString(totalDigits));
            jsc.append(");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

