/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.upload.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import jp.terasoluna.fw.service.rich.exception.ServiceException;
import jp.terasoluna.rich.functionsample.upload.bean.FileUploadInputData;
import jp.terasoluna.rich.functionsample.upload.bean.FileUploadResultData;

import org.springframework.web.multipart.MultipartFile;

/**
 * t@CAbv[hT[rX̎NX
 */

public class FileUploadServiceImpl implements FileUploadService {

    /**
     * t@CAbv[hsB
     * 
     * @param input
     *            ̓f[^
     * @return fileUploadResultData ʃf[^
     */
    public FileUploadResultData execute(FileUploadInputData input) {

        /**
         * ߂l̏
         */
        String multipartFileName = null;
        long multipartFileSize = 0;
        String multipartFileValue = null;
        String byteFileValue = null;

        // MultipartFile^̑t@Cf[^K
        MultipartFile multipartFile = input.getMultipartFile();

        // oCgz^̑t@Cf[^擾
        byte[] byteFile = input.getBytefile();

        // MultipartFile^̃t@Cf[^̃t@CEt@CTCYK
        if (multipartFile != null) {
            multipartFileName = multipartFile.getOriginalFilename();
            multipartFileSize = multipartFile.getSize();
        }

        // MultipartFile^̃t@Cf[^̓eK
        if (multipartFile != null) {
            InputStream in = null;
            try {
                in = multipartFile.getInputStream();
                byte[] buffer = new byte[1024];
                int rsize;
                while ((rsize = in.read(buffer)) != -1) {
                    multipartFileValue = new String(buffer, 0, rsize, "MS932");
                }
            } catch (IOException e) {
                throw new ServiceException("errors.8004C999");
            } finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                } catch (Exception e) {
                    throw new ServiceException("errors.8004C999");
                }
            }
        }

        // byte^̃t@Cf[^̓eK
        if (byteFile != null) {
            try {
				byteFileValue = new String(byteFile, 0, byteFile.length, "MS932");
			} catch (UnsupportedEncodingException e) {
                throw new ServiceException("errors.8004C999");
			}
        }

        // /ʃf[^^錾Ali[B
        FileUploadResultData fileUploadResultData = new FileUploadResultData();
        fileUploadResultData.setMultipartFileName(multipartFileName);
        fileUploadResultData.setMultipartFileSize(multipartFileSize);
        fileUploadResultData.setMultipartFileValue(multipartFileValue);
        fileUploadResultData.setByteFileValue(byteFileValue);

        // / ʃf[^ԋpB
        return fileUploadResultData;
    }
}
