/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.util;

import java.util.concurrent.ConcurrentHashMap;
import jp.terasoluna.fw.batch.message.MessageAccessor;
import jp.terasoluna.fw.logger.TLogger;

public class MessageUtil {
    private static final TLogger LOGGER = TLogger.getLogger(MessageUtil.class);
    private static final ConcurrentHashMap<ThreadGroup, MessageAccessor> tgm = new ConcurrentHashMap();

    protected MessageUtil() {
    }

    public static String getMessage(String code) {
        return MessageUtil.getMessage(code, null);
    }

    public static String getMessage(String code, Object[] args) {
        String mes = null;
        MessageAccessor ma = null;
        ThreadGroup tg = MessageUtil.getThreadGroup();
        if (tg != null) {
            ma = tgm.get(tg);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("TAL025006", new Object[]{MessageUtil.getThreadMessage()});
            }
        }
        if (ma != null) {
            try {
                mes = ma.getMessage(code, args);
            }
            catch (Throwable e) {}
        } else {
            LOGGER.debug("DAL025043");
        }
        if (mes == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Message not found. CODE:[");
            sb.append(code);
            sb.append("]");
            return sb.toString();
        }
        return mes;
    }

    public static void setMessageAccessor(MessageAccessor messageAccessor) {
        if (messageAccessor == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("WAL025008", new Object[]{MessageUtil.getThreadMessage()});
            }
            return;
        }
        ThreadGroup tg = MessageUtil.getThreadGroup();
        if (tg != null) {
            tgm.put(tg, messageAccessor);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("TAL025007", new Object[]{MessageUtil.getThreadMessage()});
            }
        }
    }

    public static void removeMessageAccessor() {
        ThreadGroup tg = MessageUtil.getThreadGroup();
        if (tg != null) {
            tgm.remove(tg);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("TAL025008", new Object[]{MessageUtil.getThreadMessage()});
            }
        }
    }

    private static ThreadGroup getThreadGroup() {
        Thread ct = Thread.currentThread();
        if (ct != null && ct.getThreadGroup() != null) {
            return ct.getThreadGroup();
        }
        return null;
    }

    private static String getThreadMessage() {
        StringBuilder sb = new StringBuilder();
        Thread ct = Thread.currentThread();
        if (ct != null && MessageUtil.getThreadGroup() != null) {
            sb.append(" tg:[");
            sb.append(MessageUtil.getThreadGroup().getName());
            sb.append("]");
        }
        if (ct != null) {
            sb.append(" t:[");
            sb.append(ct.getName());
            sb.append("]");
        }
        return sb.toString();
    }
}

