package jp.terasoluna.fw.collector.file;

import java.net.URL;
import java.util.List;

import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.CollectorTestUtil;
import jp.terasoluna.fw.collector.util.MemoryInfo;
import jp.terasoluna.fw.ex.unit.testcase.DaoTestCase;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileCollector017Test extends DaoTestCase {
    /**
     * Log.
     */
    private static Log logger = LogFactory.getLog(FileCollector017Test.class);

    private FileQueryDAO csvFileQueryDAO = null;

    private int previousThreadCount = 0;

    public void setCsvFileQueryDAO(FileQueryDAO csvFileQueryDAO) {
        this.csvFileQueryDAO = csvFileQueryDAO;
    }

    @Override
    protected void onSetUp() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        System.gc();
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        super.onSetUp();
        this.previousThreadCount = CollectorTestUtil.getCollectorThreadCount();
    }

    @Override
    protected void onTearDown() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        System.gc();
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        CollectorTestUtil.allInterrupt();
        super.onTearDown();
    }

    @Override
    protected void addConfigLocations(List<String> configLocations) {
        configLocations.add("jp/terasoluna/fw/collector/db/dataSource.xml");
    }

    public void testFileCollector017() throws Exception {
        if (this.csvFileQueryDAO == null) {
            fail("csvFileQueryDAOnullłB");
        }

        URL url = getClass().getClassLoader().getResource("USER_TEST3.csv");
        if (logger.isDebugEnabled()) {
            if (url != null) {
                logger.debug("url.getPath() : " + url.getPath());
            } else {
                logger.debug("url.getPath() : " + null);
            }
        }

        if (url == null) {
            fail("urlnullłB");
        }

        int count_first = 0;
        int exception_count = 0;

        Collector<B000001Data> it = new FileCollector<B000001Data>(
                this.csvFileQueryDAO, url.getPath(), B000001Data.class);

        try {
            // it = ac.execute();

            while (it.hasNext()) {
                B000001Data data = null;
                try {
                    data = it.next();
                } catch (Exception e) {
                    e.printStackTrace();
                    exception_count++;
                }

                if (logger.isInfoEnabled()) {

                    StringBuilder sb = new StringBuilder();
                    if (data != null) {
                        sb.append("UserId:[");
                        sb.append(String.format("%2s", data.getId()));
                        sb.append("],");
                        sb.append("FirstName:[");
                        sb.append(String.format("%4s", data.getFirstname()));
                        sb.append("],");
                        sb.append("FamilyName:[");
                        sb.append(String.format("%4s", data.getFamilyname()));
                        sb.append("],");
                        sb.append("UserAge:[");
                        sb.append(String.format("%2s", data.getAge()));
                        sb.append("])");
                        if (false) {
                            logger.info(sb.toString());
                        }
                    }
                }
                count_first++;

            }
        } finally {
            // N[Y
            FileCollector.closeQuietly(it);
        }

        // RN^Xbh`FbN
        assertTrue(CollectorTestUtil
                .lessThanCollectorThreadCount(0 + this.previousThreadCount));

        assertEquals(9999, count_first);
        assertEquals(2, exception_count);
    }

}
