/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.mock;

/**
 * DAO\bhs̃p[^NXB
 * 
 */
public class DaoParam {
    private String sqlId;
    private Object bindParams;
    private Class<?> clazz;
    private int beginIndex;
    private int maxCount;
    private String methodName;

    public DaoParam(String sqlId, Object bindParams) {
        super();
        this.sqlId = sqlId;
        this.bindParams = bindParams;
    }

    public DaoParam(String sqlId, Object bindParams, Class<?> clazz) {
        super();
        this.sqlId = sqlId;
        this.bindParams = bindParams;
        this.clazz = clazz;
    }

    public DaoParam(String sqlId, Object bindParams, int beginIndex,
            int maxCount) {
        super();
        this.sqlId = sqlId;
        this.bindParams = bindParams;
        this.beginIndex = beginIndex;
        this.maxCount = maxCount;
    }

    public DaoParam(String sqlId, Object bindParams, Class<?> clazz,
            int beginIndex, int maxCount) {
        super();
        this.sqlId = sqlId;
        this.bindParams = bindParams;
        this.clazz = clazz;
        this.beginIndex = beginIndex;
        this.maxCount = maxCount;
    }

    public String getSqlId() {
        return sqlId;
    }

    public void setSqlId(String sqlId) {
        this.sqlId = sqlId;
    }

    public Object getBindParams() {
        return bindParams;
    }

    public void setBindParams(Object bindParams) {
        this.bindParams = bindParams;
    }

    public Class<?> getClazz() {
        return clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public int getBeginIndex() {
        return beginIndex;
    }

    public void setBeginIndex(int beginIndex) {
        this.beginIndex = beginIndex;
    }

    public int getMaxCount() {
        return maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return methodName;
    }

    @Override
    public String toString() {
        return "DaoParam [sqlId=" + sqlId + ", bindParams=" + bindParams
                + ", clazz=" + clazz + ", beginIndex=" + beginIndex
                + ", maxCount=" + maxCount + ", methodName=" + methodName + "]";
    }
}
