/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.io.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.NoSuchElementException;

import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import jp.terasoluna.fw.ex.unit.util.AssertUtils;
import jp.terasoluna.fw.ex.unit.util.DefaultLineSplitter;
import jp.terasoluna.fw.ex.unit.util.DefaultPopulator;
import jp.terasoluna.fw.ex.unit.util.LineSplitter;
import jp.terasoluna.fw.ex.unit.util.Populator;

/**
 * CSVt@C̓\[XIuWFNg𐶐܂B <br>
 * RXgN^܂setterɂĈȉ̃p[^w肵܂B܂{@link AbstractInputSource}
 * Őݒ\ȃp[^wł܂B <br>
 * <table border=1>
 * <tr>
 * <th>p[^</th>
 * <th></th>
 * <th>ݒӏ</th>
 * <th>K{</th>
 * </tr>
 * <tr>
 * <td>file</td>
 * <td>CSVt@C܂́A<code>java.io.File</code>IuWFNg IuWFNg</td>
 * <td>RXgN^</td>
 * <td></td>
 * </tr>
 * <tr>
 * <td>clazz</td>
 * <td>CSV}bsOBeañNX</td>
 * <td>RXgN^</td>
 * <td></td>
 * </tr>
 * <tr>
 * <td>hasHeader</td>
 * <td>ǂݍCSVt@CɃwb_s邩ǂB ftHgtruełA擪sǂݍheader(String̔z)쐬܂B
 * <strong>wb_sȂCSVt@CǂݍޏꍇAhasHeaderfalseɂ
 * {@link #setHeader(String[])}
 * ɂƎheaderݒ肵ĂB</strong>̏ꍇAsڂf[^ƂĈ܂B</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>lineSplitter</td>
 * <td>CVSf[^s̕String̔zɂ邽߂̏BftHgł{@link DefaultLineSplitter}
 * gpāApJ}؂Ŕz쐬܂B</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>populator</td>
 * <td>CVSf[^sString̔z񂩂clazzŐݒ肵NX̃IuWFNg𐶐鏈BftHgł
 * {@link DefaultPopulator}gp܂B</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>encoding</td>
 * <td>CSVt@C̃GR[fBOBftHgMS932łB</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * </table>
 * 
 * <pre>
 * ȉ̗ɂĎgp@܂B
 * 
 * person.csv̓eȉƂ܂B
 * 
 * ID,NAME,ADDRESS
 * 1,c,
 * 2,,
 * 3,Rc,_ސ
 * 4,R{,
 * 
 * ɑ΂ă}bsONXȉƂ܂B
 * 
 * public class Person {
 *   private Integer id;
 *   private Sring name;
 *   private String address;
 *   // setter/getter͗
 * }
 * 
 * yf[^r@\z
 * 
 * Ɩ̌ʂƂPersonNX̃Xg쐬ۂɁACSV̓eҒlƂȂꍇÂ悤ɔr邱Ƃł܂B
 * 
 * // CSVt@C̓\[X쐬
 * CsvSource&lt;Person&gt; source = new CsvSource&lt;Person&gt;(&quot;person.csv&quot;, Person.class);
 * // Ɩ̌
 * List&lt;Person&gt; result = ...;
 * // Ɩ̌ʂCSV̓er
 * {@link AssertUtils}.assertInputEquals(source, result);
 * 
 * yf[^ۑ@\z
 *  // f[^Persone[uɕۑ܂
 *  source.to(new {@link DbTarget}&lt;Person&gt;(jdbcTemplate, Person.class));
 * </pre>
 */
public class CsvSource<T> extends AbstractInputSource<T> {

    private File input = null;
    /**
     * ǂݍCSVt@CɃwb_s邩ǂ
     */
    private boolean hasHeader = true;
    /**
     * es̓e}bsOΏۃNX
     */
    private Class<T> clazz;
    /**
     * 
     */
    private Populator<T> populator = new DefaultPopulator<T>();
    /**
     * 
     */
    private String[] mappedHeader;
    /**
     * CSVt@C̃GR[fBOB
     */
    private String encoding = "MS932";
    /**
     * sXvb^B(ftHgŔpJ}؂)
     */
    private LineSplitter lineSplitter = new DefaultLineSplitter(",");

    /**
     * RXgN^B
     * 
     * @param input
     *            CSVt@C
     * @param clazz
     *            }bsONX
     */
    public CsvSource(File input, Class<T> clazz) {
        super();
        this.input = input;
        this.clazz = clazz;
    }

    /**
     * RXgN^B<br>
     * 
     * <pre>
     * ^ꂽCSVt@CpXNXpXɑ݂ꍇ́Ãt@Cgp܂B
     * łȂꍇ͗^ꂽCSVt@CpX{@link java.io.File}NX̃RXgN^ɓn
     * {@link java.io.File}IuWFNg쐬܂B
     * </pre>
     * 
     * @param path
     *            CSVt@CpX
     * @param clazz
     *            }bsONX
     * @throws UTRuntimeException
     *             CSVt@CpX{@link java.io.File}IuWFNg̍쐬Ɏsꍇ
     */
    public CsvSource(String path, Class<T> clazz) throws UTRuntimeException {
        super();
        try {
            URL url = CsvSource.class.getClassLoader().getResource(path);
            if (url == null) {
                this.input = new File(path);
            } else {
                this.input = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
            }
        } catch (Exception e) {
            throw new UTRuntimeException(e);
        }
        this.clazz = clazz;
    }

    protected T populate(String line) {
        String[] vals = lineSplitter.split(line);
        T obj = populator.populate(clazz, mappedHeader, (Object[]) vals);
        return obj;
    }

    public Iterator<T> getIterator() {
        Iterator<T> itr = null;
        try {
            final BufferedReader reader = new BufferedReader(
                    new InputStreamReader(new FileInputStream(input), encoding));

            if (header == null) {
                // wb_ȂꍇA擪sǂݍ
                setHeader(lineSplitter.split(reader.readLine()));
            } else if (hasHeader) {
                // wb_񂪐ݒ肳ĂāAwb_ꍇA
                // wb_sǂ݂
                reader.readLine();
            }

            itr = new Iterator<T>() {
                // sf[^ǂݍނǂ̃tO
                private boolean readLine = true;
                // sf[^
                private String line;
                private boolean closed = false;

                public synchronized boolean hasNext() {
                    try {
                        if (readLine) {
                            line = reader.readLine();
                            // xǂݍ񂾂nexts܂œǂݍ܂Ȃ
                            readLine = false;
                        }
                        if (line == null) {
                            // t@C܂ŗꍇclose
                            if (!closed) {
                                reader.close();
                                closed = true;
                            }
                        }
                    } catch (IOException e) {
                        throw new UTRuntimeException(e);
                    }
                    return line != null;
                }

                public synchronized T next() {
                    T obj = null;
                    try {
                        if (readLine) {
                            // hasNextɂčsǂݍ܂ĂȂ΁Aǂݍ
                            line = reader.readLine();
                            readLine = false;
                        }
                        if (line == null) {
                            // t@C܂ŗꍇclose
                            if (!closed) {
                                reader.close();
                                closed = true;
                            }
                            throw new NoSuchElementException();
                        }
                        obj = populate(line);
                    } catch (NoSuchElementException e) {
                        throw e;
                    } catch (Exception e) {
                        throw new UTRuntimeException(e);
                    }
                    readLine = true;
                    return obj;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        } catch (Exception e) {
            throw new UTRuntimeException(e);
        }
        return itr;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public void setPopulator(Populator<T> populate) {
        this.populator = populate;
    }

    /**
     * @param lineSplitter
     *            Zbg lineSplitter
     */
    public void setLineSplitter(LineSplitter lineSplitter) {
        this.lineSplitter = lineSplitter;
    }

    /**
     * @param encoding
     *            Zbg encoding
     */
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setHeader(String[] header) {
        super.setHeader(header);
        if (headerMap == null) {
            mappedHeader = header;
        } else {
            mappedHeader = new String[header.length];
            for (int i = 0; i < header.length; i++) {
                String h = headerMap.get(header[i]);
                if (h != null) {
                    mappedHeader[i] = h;
                } else {
                    mappedHeader[i] = header[i];
                }
            }
        }
    }

}
