/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.util.regex.Pattern;

/**
 * JDBC^CX^vGXP[v`(yyyy-mm-dd hh:mm:ss.fffffffff)̕
 * 삷邽߂̃[eBeBNXB
 * 
 */
class TimestampUtil {
    
    /**
     * t̐K\p^[
     */
    private static final String DATE_FORMAT =
        "[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]";
    
    /**
     * ̐K\p^[
     */
    private static final String TIME_FORMAT =
        "[0-9][0-9]:[0-9][0-9]:[0-9][0-9]";

    /**
     * imb̐K\p^[
     */
    private static final String NANOS_FORMAT = "[0-9]{1,9}";
    

    /**
     * t`(yyyy-mm-dd)̕񂩂ǂ𔻒肷B
     * 
     * @param value Ώ
     * @return 茋
     */
    public static boolean isDateString(String value) {
        return matches(DATE_FORMAT, value);
    }

    /**
     * `(hh:mm:ss)̕񂩂ǂ𔻒肷B
     * 
     * @param value Ώ
     * @return 茋
     */
    public static boolean isTimeString(String value) {
        return matches(TIME_FORMAT, value);
    }

    /**
     * t{`(yyyy-mm-dd hh:mm:ss)̕񂩂ǂ𔻒肷B
     * 
     * @param value Ώ
     * @return 茋
     */
    public static boolean isDateTimeString(String value) {
        String pattern = DATE_FORMAT + " " + TIME_FORMAT;
        return matches(pattern, value);
    }

    /**
     * t{{imb`(yyyy-mm-dd hh:mm:ss.fffffffff)
     * ̕񂩂ǂ𔻒肷B
     * 
     * @param value Ώ
     * @return 茋
     */
    public static boolean isDateTimeNanosString(String value) {
        String pattern = DATE_FORMAT + " " + TIME_FORMAT + "." + NANOS_FORMAT;
        return matches(pattern, value);
    }

    /**
     * ^ꂽ񂩂t(yyyy-mm-dd)oB
     * 
     * @param value oΏۂ̕
     * @return o
     */
    public static String getDateString(String value) {
        return value.substring(0, 10);
    }

    /**
     * ^ꂽ񂩂玞(hh:mm:ss)oB
     * 
     * @param value oΏۂ̕
     * @return o
     */
    public static String getTimeString(String value) {
        return value.substring(11, 19);
    }

    /**
     * ^ꂽ񂩂t{(yyyy-mm-dd hh:mm:ss)oB
     * 
     * @param value oΏۂ̕
     * @return o
     */
    public static String getDateTimeString(String value) {
        return value.substring(0, 19);
    }

    /**
     * p^[}b`OsB
     * 
     * @param pattern }b`O鐳K\p^[
     * @param value }b`OΏ
     * @return 茋
     */
    private static boolean matches(String pattern, String value) {
        // NULL`FbN
        if (value == null) {
            return false;
        }
        // p^[}b`Os
        boolean result = Pattern.matches(pattern, value);
        return result;
    }


}
