/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/**
 * ServletContext ̃bNAbvNXB
 * <BR><BR>
 * ɁATERASOLUNA t[[N̊g̒P̃eXgp̃NXŁA
 * ƖAvP[ṼeXgŕKvɂȂ邱Ƃ͂قƂǂȂƎvB
 * 
 * <pre>
 * [gp]
 *       MockServletContext context = new MockServletContext();
 *       MockServletConfig config = new MockServletConfig();
 *       config.setServletContext(context);
 *
 *       ActionServletEx as = new ActionServletEx();
 *       as.init(config); 
 * </pre>
 * 
 */
public class MockServletContext implements ServletContext {

    /**
     * RXgN^ 
     */
    public MockServletContext() {
        attributes = new HashMap();
    }
    
    /**
     * w肳ꂽ URL ɑΉ ServletContext IuWFNgԂ܂B 
     * @param s URL
     * @return ServletContext IuWFNg
     */
    public ServletContext getContext(String s) {
        throw new UnsupportedOperationException(
            "getContext() IS Not Supported!");
    }
    
    /**
     *  Servlet ReiT|[gĂ Java Servlet API 
     * ̃W[o[WԂ܂B
     * @return Java Servlet API ̃W[o[W
     */
    public int getMajorVersion() {
        throw new UnsupportedOperationException(
            "getMajorVersion() IS Not Supported!");
    }
    
    /**
     *  Servlet ReiT|[gĂ Java Servlet API 
     * ̃}Ci[o[WԂ܂B
     * @return Java Servlet API ̃}Ci[o[W
     */
    public int getMinorVersion() {
        throw new UnsupportedOperationException(
            "getMinorVersion() IS Not Supported!");
    }
    
    /**
     * w肳ꂽt@C MIME ^CvԂ܂B
     * @param s t@C
     * @return MIME ^Cv
     */
    public String getMimeType(String s) {
        throw new UnsupportedOperationException(
            "getMimeType() IS Not Supported!");
    }
    
    /**
     * Ŏw肳ꂽpXɈv̂ Web AvP[VɂƁA 
     * ̃TupXȉɂSẴ\[X̃pXfBNgɎ`
     * XgɂĕԂ܂B
     * @param s pX
     * @return ̃TupXȉɂSẴ\[X̃pXfBNg
     * `̃Xg
     */
    public Set getResourcePaths(String s) {
        throw new UnsupportedOperationException(
            "getResourcePaths() IS Not Supported!");
    }
    
    /**
     * w肳ꂽpXŃ}bsOĂ郊\[X URL Ԃ܂B
     * @param s pX
     * @return URL
     * @throws MalformedURLException MalformedURLException
     */
    public URL getResource(String s) throws MalformedURLException {
        return new URL("file:" + s);
    }
    
    /**
     * w肳ꂽpXɑ郊\[X InputStream IuWFNgŕԂ܂B 
     * @param s oX
     * @return InputStream `̃\[X
     */
    public InputStream getResourceAsStream(String s)  {
        try {
            return new FileInputStream(s);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }

    }
   
    /**
     * w肳ꂽpXɈʒu郊\[X̃bp[Ƃē삷 
     * RequestDispatcher IuWFNgԂ܂B
     * @param s pX
     * @return RequestDispatcher IuWFNg
     */
    public RequestDispatcher getRequestDispatcher(String s) {
        return new MockRequestDispatcher(s);

    }
    
    /**
     * w肳ꂽ Servlet ̃bp[Ƃē삷 RequestDispatcher 
     * IuWFNgԂ܂B
     * @param s Servlet
     * @return RequestDispatcher IuWFNg
     */
    public RequestDispatcher getNamedDispatcher(String s) {
        throw new UnsupportedOperationException(
            "getNamedDispatcher() IS Not Supported!");
    }
    
    /**
     * @deprecated  
     * @param s String
     * @return Servlet
     * @throws ServletException ServletException
     */
    public Servlet getServlet(String s) throws ServletException {
        throw new UnsupportedOperationException(
            "getServlet() IS Not Supported!");
    }
    
    /**
     * @deprecated  
     * @return Servlets
     */
    public Enumeration getServlets() {
        throw new UnsupportedOperationException(
            "getServlets() IS Not Supported!");
    }

    /**
     * @deprecated  
     * @return ServletNames
     */
    public Enumeration getServletNames() {
        throw new UnsupportedOperationException(
            "getServletNames() IS Not Supported!");
    }
    
    /**
     * ^ꂽzpXɑΉۂ̃pX String IuWFNgŕԂ܂B
     * @param s zpX
     * @return ۂ̃pX
     */
    public String getRealPath(String s) {
        throw new UnsupportedOperationException(
            "getRealPath() IS Not Supported!");
    }
    
    /**
     * Servlet 삵Ă Servlet Rei̖Oo[WԂ܂B 
     * @return Servlet 삵Ă Servlet Rei̖Oo[W
     */
    public String getServerInfo() {
        throw new UnsupportedOperationException(
            "getServerInfo() IS Not Supported!");
    }
    
    /**
     * w肳ꂽȌp[^̒l܂ޕԂ܂B 
     * @param s p[^̖O
     * @return p[^̒l
     */
    public String getInitParameter(String s) {
        throw new UnsupportedOperationException(
            "getInitParameter() IS Not Supported!");
    }
    
    /**
     * ̃ReLXg̏p[^̖O String 񋓂ł 
     * Enumeration ŕԂ܂B 
     * @return ̃ReLXg̏p[^̖O
     */
    public Enumeration getInitParameterNames() {
        throw new UnsupportedOperationException(
            "getInitParameterNames() IS Not Supported!");
    }
    
    /**
     * w肳ꂽOɑΉ Servlet ReȋԂ܂B 
     * @param s O
     * @return Ή Servlet Reȋ
     */
    public Object getAttribute(String s) {
        return attributes.get(s);
    }
    
    /**
     * Servlet Servlet ReLXg̗p\ȑ܂ 
     * Enumeration IuWFNgԂ܂B  
     * @return ReLXg̗p\ȑ
     */
    public Enumeration getAttributeNames() {
        Set set = new HashSet();
        for (Iterator iter = attributes.keySet().iterator(); 
                                    iter.hasNext(); set.add(iter.next())) {
                              continue;          
        }
        return Collections.enumeration(set);
    }
    
    /**
     *  Servlet ReLXgŎw肳ꂽɃIuWFNgѕt܂B 
     * @param key 
     * @param attr IuWFNg
     */
    public void setAttribute(String key, Object attr) {
        System.out.println("setAttribute start!!!");   
        if (attr != null) {
            attributes.put(key, attr);
        } else {
            removeAttribute(key);
        }
    }
    
    /**
     * Servlet ReLXgw肳ꂽȎ폜܂B 
     * @param key 
     */
    public void removeAttribute(String key) {
        attributes.remove(key);
    }
    
    /**
     *  Web AvP[V̖OԂ܂B
     * @return Web AvP[V̖O
     */
    public String getServletContextName() {
        throw new UnsupportedOperationException(
            "getServletContextName() IS Not Supported!");
    }
    
    /**
     * i[Map
     */
    private Map attributes;

    /**
     * @see javax.servlet.ServletContext#log(java.lang.String)
     */
    public void log(String msg) {
        System.out.println("[MockServletContext]" + msg);
    }

    /**
     * @see javax.servlet.ServletContext#log(java.lang.Exception, java.lang.String)
     */
    public void log(Exception exception, String msg) {
        System.out.println("[MockServletContext]" + msg + " " + exception);
    }

    /**
     * @see javax.servlet.ServletContext#log(java.lang.String, java.lang.Throwable)
     */
    public void log(String msg, Throwable throwable) {
        System.out.println("[MockServletContext]" + msg + " " + throwable);
    }
}



