package jp.terasoluna.fw.batch.executor;

import java.net.URL;

import jp.terasoluna.fw.batch.annotation.util.MockApplicationContext;
import jp.terasoluna.fw.batch.executor.SecurityManagerEx.ExitException;
import jp.terasoluna.fw.batch.executor.concurrent.BatchServant;
import jp.terasoluna.fw.batch.executor.concurrent.BatchThreadPoolTaskExecutor;
import jp.terasoluna.fw.batch.executor.vo.BatchJobListResult;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.ex.unit.util.SystemEnvUtils;
import jp.terasoluna.fw.ex.unit.util.TerasolunaPropertyUtils;
import junit.framework.TestCase;

import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;

public class AsyncBatchExecutorTest extends TestCase {

    final SecurityManager sm = System.getSecurityManager();

    public AsyncBatchExecutorTest() {
        super();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TerasolunaPropertyUtils.saveProperties();
        System.setSecurityManager(new SecurityManagerEx());
    }

    @Override
    protected void tearDown() throws Exception {
        TerasolunaPropertyUtils.restoreProperties();
        SystemEnvUtils.restoreEnv();
        System.setSecurityManager(sm);
        super.tearDown();
    }

    /**
     * maineXg01 yُnz
     * 
     * <pre>
     * O
     * Eadmin.dataSourcebean`t@C擾queryDaonull
     * ENfoo
     * mF
     * EIAL025007̃Oo͂邱
     * EIAL025006̃Ofooo͂邱
     * E^[R[h255
     * </pre>
     */
    public void testMain01() throws Exception {
        TerasolunaPropertyUtils.addProperty("beanDefinition.admin.dataSource",
                "AsyncBatchExecutorTest01.xml");
        // TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
        // "src/test/resources/test_terminate");

        try {
            AsyncBatchExecutor.main(new String[] { "foo" });
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg02 yُnz
     * 
     * <pre>
     * O
     * Eadmin.dataSourcebean`t@C擾updateDaonull
     * ENfoo
     * mF
     * EIAL025008̃Oo͂邱
     * EIAL025006̃Ofooo͂邱
     * E^[R[h255
     * </pre>
     */
    public void testMain02() throws Exception {
        TerasolunaPropertyUtils.addProperty("beanDefinition.admin.dataSource",
                "AsyncBatchExecutorTest02.xml");
        // TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
        // "src/test/resources/test_terminate");

        try {
            AsyncBatchExecutor.main(new String[] { "foo" });
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg03 yُnz
     * 
     * <pre>
     * O
     * Eadmin.dataSourcebean`t@C擾transactionManagernull
     * ENfoo
     * mF
     * EIAL025016̃Oo͂邱
     * EIAL025006̃Ofooo͂邱
     * E^[R[h255
     * </pre>
     */
    public void testMain03() throws Exception {
        TerasolunaPropertyUtils.addProperty("beanDefinition.admin.dataSource",
                "AsyncBatchExecutorTest03.xml");
        // TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
        // "src/test/resources/test_terminate");

        try {
            AsyncBatchExecutor.main(new String[] { "foo" });
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg04 ynz
     * 
     * <pre>
     * O
     * EN
     * EϐJOB_APP_CDݒ
     * mF
     * EIAL025006̃OjoAppCdo͂Ȃ
     * </pre>
     */
    public void testMain04() throws Exception {
        TerasolunaPropertyUtils.addProperty("beanDefinition.admin.dataSource",
                "AsyncBatchExecutorTest01.xml");
        // TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
        // "src/test/resources/test_terminate");
        SystemEnvUtils.removeEnv(AsyncBatchExecutor.ENV_JOB_APP_CD);
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg05 ynz
     * 
     * <pre>
     * O
     * EN
     * EϐJOB_APP_CDhogeݒ
     * mF
     * EIAL025006̃Ohogeo͂邱
     * </pre>
     */
    public void testMain05() throws Exception {
        TerasolunaPropertyUtils.addProperty("beanDefinition.admin.dataSource",
                "AsyncBatchExecutorTest01.xml");
        // TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
        // "src/test/resources/test_terminate");
        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg06 ynz
     * 
     * <pre>
     * O
     * Ewf[^x[Xُ펞̃gC񐔁x&quot;abc&quot;ݒ
     * mF
     * E^[R[h255
     * </pre>
     */
    public void testMain06() throws Exception {
        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.dbAbnormalRetryMax");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.dbAbnormalRetryMax", "abc");

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg07 ynz
     * 
     * <pre>
     * O
     * Ewf[^x[Xُ펞̃gCԊui~bjx&quot;abc&quot;ݒ
     * mF
     * E^[R[h255
     * </pre>
     */
    public void testMain07() throws Exception {
        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.dbAbnormalRetryInterval");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.dbAbnormalRetryInterval", "abc");

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg08 ynz
     * 
     * <pre>
     * O
     * Ewf[^x[Xُ펞̃gC񐔂ZbgO񂩂̔Ԋui~bjx&quot;abc&quot;ݒ
     * mF
     * E^[R[h255
     * </pre>
     */
    public void testMain08() throws Exception {
        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.dbAbnormalRetryReset");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.dbAbnormalRetryReset", "abc");

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg09 ynz
     * 
     * <pre>
     * O
     * EwWusgCԊui~bjx&quot;abc&quot;ݒ
     * mF
     * E^[R[h255
     * </pre>
     */
    public void testMain09() throws Exception {
        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.executeRetryInterval");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.executeRetryInterval", "abc");

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg10 ynz
     * 
     * <pre>
     * O
     * EwWusgC񐔁x&quot;abc&quot;ݒ
     * mF
     * E^[R[h255
     * </pre>
     */
    public void testMain10() throws Exception {
        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.executeRetryCountMax");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.executeRetryCountMax", "abc");

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg11 ynz
     * 
     * <pre>
     * O
     * Ew󂫃Xbhc臒l̃ftHglx&quot;abc&quot;ݒ
     * mF
     * E^[R[h255
     * </pre>
     */
    public void testMain11() throws Exception {
        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.availableThreadThresholdCount");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.availableThreadThresholdCount", "abc");

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg12 ynz
     * 
     * <pre>
     * O
     * Ew󂫃Xbhc臒lȉ̏ꍇ̃EFCgԁi~bj̃ftHglx&quot;abc&quot;ݒ
     * mF
     * E^[R[h255
     * </pre>
     */
    public void testMain12() throws Exception {
        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.availableThreadThresholdWait");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.availableThreadThresholdWait", "abc");

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(255, e.state);
        }
    }

    /**
     * maineXg13 ynz
     * 
     * <pre>
     * O
     * EwWusgCԊui~bjx&quot;10&quot;ݒ
     * mF
     * E^[R[h0
     * </pre>
     */
    public void testMain13() throws Exception {
        // eXgf[^ݒ
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String endFilePath = srcUrl.getPath();

        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.executeRetryInterval");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.executeRetryInterval", "10");
        TerasolunaPropertyUtils.removeProperty("executor.endMonitoringFile");
        TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
                endFilePath);

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(0, e.state);
        }
    }

    /**
     * maineXg14 ynz
     * 
     * <pre>
     * O
     * EwWusgC񐔁x&quot;10&quot;ݒ
     * mF
     * E^[R[h0
     * </pre>
     */
    public void testMain14() throws Exception {
        // eXgf[^ݒ
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String endFilePath = srcUrl.getPath();

        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.executeRetryCountMax");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.executeRetryCountMax", "10");
        TerasolunaPropertyUtils.removeProperty("executor.endMonitoringFile");
        TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
                endFilePath);

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(0, e.state);
        }
    }

    /**
     * maineXg15 ynz
     * 
     * <pre>
     * O
     * Ew󂫃Xbhc臒l̃ftHglx&quot;10&quot;ݒ
     * mF
     * E^[R[h0
     * </pre>
     */
    public void testMain15() throws Exception {
        // eXgf[^ݒ
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String endFilePath = srcUrl.getPath();

        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.availableThreadThresholdCount");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.availableThreadThresholdCount", "10");
        TerasolunaPropertyUtils.removeProperty("executor.endMonitoringFile");
        TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
                endFilePath);

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(0, e.state);
        }
    }

    /**
     * maineXg16 ynz
     * 
     * <pre>
     * O
     * Ew󂫃Xbhc臒lȉ̏ꍇ̃EFCgԁi~bj̃ftHglx&quot;10&quot;ݒ
     * mF
     * E^[R[h0
     * </pre>
     */
    public void testMain16() throws Exception {
        // eXgf[^ݒ
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String endFilePath = srcUrl.getPath();

        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.availableThreadThresholdWait");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.availableThreadThresholdWait", "10");
        TerasolunaPropertyUtils.removeProperty("executor.endMonitoringFile");
        TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
                endFilePath);

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(0, e.state);
        }
    }

    /**
     * maineXg17 ynz
     * 
     * <pre>
     * O
     * Ew󂫃Xbhc臒lȉ̏ꍇ̃EFCgԁi~bj̃ftHglx&quot;10&quot;ݒ
     * mF
     * E^[R[h0
     * </pre>
     */
    public void testMain17() throws Exception {
        // eXgf[^ݒ
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String endFilePath = srcUrl.getPath();

        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.availableThreadThresholdWait");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.availableThreadThresholdWait", "10");
        TerasolunaPropertyUtils.removeProperty("executor.endMonitoringFile");
        TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
                endFilePath);

        SystemEnvUtils.setEnv(AsyncBatchExecutor.ENV_JOB_APP_CD, "hoge");
        try {
            AsyncBatchExecutor.main(new String[] {});
            fail("O͔܂");
        } catch (ExitException e) {
            assertEquals(0, e.state);
        }
    }

    /**
     * testCloseRootApplicationContext001
     * @throws Exception
     */
    public void testCloseRootApplicationContext001() throws Exception {
        ApplicationContext context = null;
        AsyncBatchExecutor.closeRootApplicationContext(context);
    }

    /**
     * testCloseRootApplicationContext002
     * @throws Exception
     */
    public void testCloseRootApplicationContext002() throws Exception {
        ApplicationContext context = new AbstractApplicationContext() {

            @Override
            protected void closeBeanFactory() {
            }

            @Override
            public ConfigurableListableBeanFactory getBeanFactory()
                                                                   throws IllegalStateException {
                return null;
            }

            @Override
            protected void refreshBeanFactory() throws BeansException,
                                               IllegalStateException {
            }
        };

        AsyncBatchExecutor.closeRootApplicationContext(context);
    }

    /**
     * testLogOutputTaskExecutor001
     * @throws Exception
     */
    public void testLogOutputTaskExecutor001() throws Exception {
        Log log = new Log() {
            public void debug(Object message) {
            }

            public void debug(Object message, Throwable t) {
            }

            public void error(Object message) {
            }

            public void error(Object message, Throwable t) {
            }

            public void fatal(Object message) {
            }

            public void fatal(Object message, Throwable t) {
            }

            public void info(Object message) {
            }

            public void info(Object message, Throwable t) {
            }

            public boolean isDebugEnabled() {
                return false;
            }

            public boolean isErrorEnabled() {
                return false;
            }

            public boolean isFatalEnabled() {
                return false;
            }

            public boolean isInfoEnabled() {
                return false;
            }

            public boolean isTraceEnabled() {
                return false;
            }

            public boolean isWarnEnabled() {
                return false;
            }

            public void trace(Object message) {
            }

            public void trace(Object message, Throwable t) {
            }

            public void warn(Object message) {
            }

            public void warn(Object message, Throwable t) {
            }
        };

        ThreadPoolTaskExecutor taskExec = new BatchThreadPoolTaskExecutor();
        taskExec.setCorePoolSize(1);
        taskExec.setMaxPoolSize(1);
        taskExec.initialize();

        AsyncBatchExecutor.logOutputTaskExecutor(log, taskExec);
    }

    /**
     * testCheckEndFile001
     * @throws Exception
     */
    public void testCheckEndFile001() throws Exception {
        String endFilePath = null;
        boolean result = AsyncBatchExecutor.checkEndFile(endFilePath);
        assertFalse(result);
    }

    /**
     * testCheckEndFile002
     * @throws Exception
     */
    public void testCheckEndFile002() throws Exception {
        // eXgf[^ݒ
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");

        String endFilePath = srcUrl.getPath();
        boolean result = AsyncBatchExecutor.checkEndFile(endFilePath);
        assertTrue(result);
    }

    /**
     * testCheckTaskQueue001
     * @throws Exception
     */
    public void testCheckTaskQueue001() throws Exception {
        ThreadPoolTaskExecutor taskExec = new BatchThreadPoolTaskExecutor();
        taskExec.setCorePoolSize(1);
        taskExec.setMaxPoolSize(1);
        taskExec.initialize();

        boolean result = AsyncBatchExecutor.checkTaskQueue(taskExec);
        assertTrue(result);
    }

    /**
     * testCheckTaskQueue002
     * @throws Exception
     */
    public void testCheckTaskQueue002() throws Exception {
        ThreadPoolTaskExecutor taskExec = new ThreadPoolTaskExecutor();
        taskExec.setCorePoolSize(1);
        taskExec.setMaxPoolSize(1);
        taskExec.setQueueCapacity(1);
        taskExec.initialize();

        Runnable task = new Runnable() {
            public void run() {
                try {
                    System.out.println("aaa");
                    Thread.sleep(5000);
                    System.out.println("bbb");
                } catch (InterruptedException e) {
                    System.out.println("ccc");
                }
            }
        };
        taskExec.execute(task);

        Thread.sleep(1000);

        boolean result = AsyncBatchExecutor.checkTaskQueue(taskExec);
        assertTrue(result);

        taskExec.shutdown();
        Thread.sleep(500);
    }

    /**
     * testCheckTaskQueue003
     * @throws Exception
     */
    public void testCheckTaskQueue003() throws Exception {
        ThreadPoolTaskExecutor taskExec = new BatchThreadPoolTaskExecutor();
        taskExec.setCorePoolSize(1);
        taskExec.setMaxPoolSize(1);
        taskExec.initialize();

        Runnable task = new Runnable() {
            public void run() {
                try {
                    System.out.println("aaa");
                    Thread.sleep(5000);
                    System.out.println("bbb");
                } catch (InterruptedException e) {
                    System.out.println("ccc");
                }
            }
        };
        taskExec.execute(task);

        Thread.sleep(1000);

        boolean result = AsyncBatchExecutor.checkTaskQueue(taskExec);
        assertFalse(result);

        taskExec.shutdown();
        Thread.sleep(500);
    }

    /**
     * testExecuteJob001
     * @throws Exception
     */
    public void testExecuteJob001() throws Exception {
        // p[^
        AsyncBatchExecutor executor = null;
        ApplicationContext ctx = null;
        ThreadPoolTaskExecutor taskExecutor = null;
        String batchTaskServantName = null;
        BatchJobListResult batchJobListResult = null;

        // eXg
        boolean result = AsyncBatchExecutor.executeJob(executor, ctx,
                taskExecutor, batchTaskServantName, batchJobListResult);

        // 
        assertFalse(result);
    }

    /**
     * testExecuteJob002
     * @throws Exception
     */
    public void testExecuteJob002() throws Exception {
        // p[^
        AsyncBatchExecutor executor = new AsyncBatchExecutor() {
            @Override
            public QueryDAO getSysQueryDAO() {
                return null;
            }
        };
        ApplicationContext ctx = new MockApplicationContext();
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        String batchTaskServantName = "batchTaskServant";
        BatchJobListResult batchJobListResult = new BatchJobListResult();

        // eXg
        boolean result = AsyncBatchExecutor.executeJob(executor, ctx,
                taskExecutor, batchTaskServantName, batchJobListResult);

        // 
        assertFalse(result);
    }

    /**
     * testExecuteJob003
     * @throws Exception
     */
    public void testExecuteJob003() throws Exception {
        // p[^
        AsyncBatchExecutor executor = new AsyncBatchExecutor() {
            @Override
            public UpdateDAO getSysUpdateDAO() {
                return null;
            }
        };
        ApplicationContext ctx = new MockApplicationContext();
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        String batchTaskServantName = "batchTaskServant";
        BatchJobListResult batchJobListResult = new BatchJobListResult();

        // eXg
        boolean result = AsyncBatchExecutor.executeJob(executor, ctx,
                taskExecutor, batchTaskServantName, batchJobListResult);

        // 
        assertFalse(result);
    }

    /**
     * testExecuteJob004
     * @throws Exception
     */
    public void testExecuteJob004() throws Exception {
        // p[^
        AsyncBatchExecutor executor = new AsyncBatchExecutor() {
            @Override
            public PlatformTransactionManager getSysTransactionManager() {
                return null;
            }
        };
        ApplicationContext ctx = new MockApplicationContext();
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        String batchTaskServantName = "batchTaskServant";
        BatchJobListResult batchJobListResult = new BatchJobListResult();

        // eXg
        boolean result = AsyncBatchExecutor.executeJob(executor, ctx,
                taskExecutor, batchTaskServantName, batchJobListResult);

        // 
        assertFalse(result);
    }

    /**
     * testExecuteJob005
     * @throws Exception
     */
    public void testExecuteJob005() throws Exception {
        // p[^
        AsyncBatchExecutor executor = new AsyncBatchExecutor();
        ApplicationContext ctx = new MockApplicationContext();
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        String batchTaskServantName = "batchTaskServant";
        BatchJobListResult batchJobListResult = new BatchJobListResult();

        // eXg
        boolean result = AsyncBatchExecutor.executeJob(executor, ctx,
                taskExecutor, batchTaskServantName, batchJobListResult);

        // 
        assertFalse(result);
    }

    /**
     * testExecuteJob006
     * @throws Exception
     */
    public void testExecuteJob006() throws Exception {
        // p[^
        AsyncBatchExecutor executor = new AsyncBatchExecutor();
        MockApplicationContext ctx = new MockApplicationContext() {
            @Override
            public Object getBean(String key, Class arg1) throws BeansException {
                return null;
            }
        };
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        String batchTaskServantName = "batchServant";
        BatchJobListResult batchJobListResult = new BatchJobListResult();

        // eXg
        boolean result = AsyncBatchExecutor.executeJob(executor, ctx,
                taskExecutor, batchTaskServantName, batchJobListResult);

        // 
        assertFalse(result);
    }

    /**
     * testExecuteJob007
     * @throws Exception
     */
    public void testExecuteJob007() throws Exception {
        // p[^
        AsyncBatchExecutor executor = new AsyncBatchExecutor() {
            @Override
            protected boolean startBatchStatus(String jobSequenceId,
                    QueryDAO queryDAO, UpdateDAO updateDAO,
                    PlatformTransactionManager transactionManager) {
                return false;
            }
        };
        MockApplicationContext ctx = new MockApplicationContext();
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        String batchTaskServantName = "batchServant";
        BatchJobListResult batchJobListResult = new BatchJobListResult();

        BatchServant batchServant = new BatchServant() {
            public void setJobSequenceId(String jobSequenceId) {
            }

            public void run() {
            }
        };
        ctx.addBeanMap(batchTaskServantName, batchServant);

        // eXg
        boolean result = AsyncBatchExecutor.executeJob(executor, ctx,
                taskExecutor, batchTaskServantName, batchJobListResult);

        // 
        assertFalse(result);
    }

    /**
     * testExecuteJob008
     * @throws Exception
     */
    public void testExecuteJob008() throws Exception {
        // p[^
        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.executeRetryCountMax");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.executeRetryCountMax", "10");
        TerasolunaPropertyUtils
                .removeProperty("batchTaskExecutor.executeRetryInterval");
        TerasolunaPropertyUtils.addProperty(
                "batchTaskExecutor.executeRetryInterval", "10");

        AsyncBatchExecutor executor = new AsyncBatchExecutor() {
            @Override
            protected boolean startBatchStatus(String jobSequenceId,
                    QueryDAO queryDAO, UpdateDAO updateDAO,
                    PlatformTransactionManager transactionManager) {
                return true;
            }
        };
        MockApplicationContext ctx = new MockApplicationContext();
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor() {
            @Override
            public void execute(Runnable task) {
                throw new TaskRejectedException("hoge");
            }
        };
        String batchTaskServantName = "batchServant";
        BatchJobListResult batchJobListResult = new BatchJobListResult();

        BatchServant batchServant = new BatchServant() {
            public void setJobSequenceId(String jobSequenceId) {
            }

            public void run() {
            }
        };
        ctx.addBeanMap(batchTaskServantName, batchServant);

        // eXg
        boolean result = AsyncBatchExecutor.executeJob(executor, ctx,
                taskExecutor, batchTaskServantName, batchJobListResult);

        // 
        assertFalse(result);
    }

    /**
     * testExecuteJob009
     * @throws Exception
     */
    public void testExecuteJob009() throws Exception {
        // p[^
        AsyncBatchExecutor executor = new AsyncBatchExecutor() {
            @Override
            protected boolean startBatchStatus(String jobSequenceId,
                    QueryDAO queryDAO, UpdateDAO updateDAO,
                    PlatformTransactionManager transactionManager) {
                return true;
            }
        };
        MockApplicationContext ctx = new MockApplicationContext();
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor() {
            @Override
            public void execute(Runnable task) {
            }
        };
        String batchTaskServantName = "batchServant";
        BatchJobListResult batchJobListResult = new BatchJobListResult();

        BatchServant batchServant = new BatchServant() {
            public void setJobSequenceId(String jobSequenceId) {
            }

            public void run() {
            }
        };
        ctx.addBeanMap(batchTaskServantName, batchServant);

        // eXg
        boolean result = AsyncBatchExecutor.executeJob(executor, ctx,
                taskExecutor, batchTaskServantName, batchJobListResult);

        // 
        assertTrue(result);
    }
}
