/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.executor;

import jp.terasoluna.fw.batch.executor.vo.BLogicResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.ex.unit.testcase.DaoTestCase;
import jp.terasoluna.fw.ex.unit.util.TerasolunaPropertyUtils;

import org.springframework.transaction.PlatformTransactionManager;

public class AbstractJobBatchExecutorTest extends DaoTestCase {

    /**
     * pDAONX
     */
    private QueryDAO queryDAO = null;

    private UpdateDAO updateDAO = null;

    private PlatformTransactionManager transactionManager = null;

    @Override
    protected void onSetUpInTransaction() throws Exception {
        deleteFromTable("job_control");

        update("INSERT INTO job_control (job_seq_id, job_app_cd, job_arg_nm1, job_arg_nm2, job_arg_nm3, job_arg_nm4, job_arg_nm5, job_arg_nm6, job_arg_nm7, job_arg_nm8, job_arg_nm9, job_arg_nm10, job_arg_nm11, job_arg_nm12, job_arg_nm13, job_arg_nm14, job_arg_nm15, job_arg_nm16, job_arg_nm17, job_arg_nm18, job_arg_nm19, job_arg_nm20, blogic_app_status, cur_app_status, add_date_time, upd_date_time) VALUES ('0000000001', 'B000001', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL)");
        update("INSERT INTO job_control (job_seq_id, job_app_cd, job_arg_nm1, job_arg_nm2, job_arg_nm3, job_arg_nm4, job_arg_nm5, job_arg_nm6, job_arg_nm7, job_arg_nm8, job_arg_nm9, job_arg_nm10, job_arg_nm11, job_arg_nm12, job_arg_nm13, job_arg_nm14, job_arg_nm15, job_arg_nm16, job_arg_nm17, job_arg_nm18, job_arg_nm19, job_arg_nm20, blogic_app_status, cur_app_status, add_date_time, upd_date_time) VALUES ('0000000002', 'B000001', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL)");
        update("INSERT INTO job_control (job_seq_id, job_app_cd, job_arg_nm1, job_arg_nm2, job_arg_nm3, job_arg_nm4, job_arg_nm5, job_arg_nm6, job_arg_nm7, job_arg_nm8, job_arg_nm9, job_arg_nm10, job_arg_nm11, job_arg_nm12, job_arg_nm13, job_arg_nm14, job_arg_nm15, job_arg_nm16, job_arg_nm17, job_arg_nm18, job_arg_nm19, job_arg_nm20, blogic_app_status, cur_app_status, add_date_time, upd_date_time) VALUES ('0000000003', 'B000001', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2', NULL, NULL)");
        update("INSERT INTO job_control (job_seq_id, job_app_cd, job_arg_nm1, job_arg_nm2, job_arg_nm3, job_arg_nm4, job_arg_nm5, job_arg_nm6, job_arg_nm7, job_arg_nm8, job_arg_nm9, job_arg_nm10, job_arg_nm11, job_arg_nm12, job_arg_nm13, job_arg_nm14, job_arg_nm15, job_arg_nm16, job_arg_nm17, job_arg_nm18, job_arg_nm19, job_arg_nm20, blogic_app_status, cur_app_status, add_date_time, upd_date_time) VALUES ('0000000004', 'B000001', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, NULL)");

        queryDAO = getBean("adminQueryDAO");
        updateDAO = getBean("adminUpdateDAO");
        transactionManager = getBean("adminTransactionManager");

        TerasolunaPropertyUtils.saveProperties();

    }

    @Override
    protected void onTearDownAfterTransaction() throws Exception {

        TerasolunaPropertyUtils.restoreProperties();
        super.onTearDownAfterTransaction();
    }

    /**
     * WuXe[^X̃eXg <br>
     * <br>
     * eXgTvF Nu0vŌ݃WuXe[^X{u0v̏ꍇA WuXe[^X茋ʂsu1vԋp邱ƂmFB <br>
     * <br>
     * mFځFsu1vԋp邱ƂmFB<br>
     * <br>
     * @throws Exception
     */
    public void testJudgmentStatus01() throws Exception {

        BatchJobData param = new BatchJobData();
        param.setJobAppCd("B000001");
        param.setCurAppStatus("0");
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        String result = exe.judgmentStatus(param, "0000000001", "0", "0");

        assertEquals("1", result);

    }

    /**
     * WuXe[^X̃eXg <br>
     * <br>
     * eXgTvF Nu0vŌ݃WuXe[^Xsu1v̏ꍇA WuXe[^X茋ʂnullԋp邱ƂmFB <br>
     * <br>
     * mFځFnullԋp邱ƂmFB<br>
     * <br>
     * @throws Exception
     */
    public void testJudgmentStatus02() throws Exception {

        BatchJobData param = new BatchJobData();
        param.setJobAppCd("B000001");
        param.setCurAppStatus("1");

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        String result = exe.judgmentStatus(param, "0000000001", "0", "0");

        assertNull(result);
    }

    /**
     * WuXe[^X̃eXg <br>
     * <br>
     * eXgTvF Nu0vŌ݃WuXe[^Xρu2v̏ꍇA WuXe[^X茋ʂnullԋp邱ƂmFB <br>
     * <br>
     * mFځFnullԋp邱ƂmFB<br>
     * <br>
     * @throws Exception
     */
    public void testJudgmentStatus03() throws Exception {

        BatchJobData param = new BatchJobData();
        param.setJobAppCd("B000001");
        param.setCurAppStatus("2");

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        String result = exe.judgmentStatus(param, "0000000001", "0", "0");

        assertNull(result);
    }

    /**
     * WuXe[^X̃eXg <br>
     * <br>
     * eXgTvF Iu1vŌ݃WuXe[^Xsu0v̏ꍇA WuXe[^X茋ʂnullԋp邱ƂmFB <br>
     * <br>
     * mFځFnullԋp邱ƂmFB<br>
     * <br>
     * @throws Exception
     */
    public void testJudgmentStatus04() throws Exception {

        BatchJobData param = new BatchJobData();
        param.setJobAppCd("B000001");
        param.setCurAppStatus("0");

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        String result = exe.judgmentStatus(param, "0000000001", "1", "0");

        assertNull(result);

    }

    /**
     * WuXe[^X̃eXg <br>
     * <br>
     * eXgTvF Iu1vŌ݃WuXe[^Xsu1v̏ꍇA WuXe[^X茋ʂρu2vԋp邱ƂmFB <br>
     * <br>
     * mFځFρu2vԋp邱ƂmFB<br>
     * <br>
     * @throws Exception
     */
    public void testJudgmentStatus05() throws Exception {

        BatchJobData param = new BatchJobData();
        param.setJobAppCd("B000001");
        param.setCurAppStatus("1");

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        String result = exe.judgmentStatus(param, "0000000001", "1", "0");

        assertEquals("2", result);

    }

    /**
     * WuXe[^X̃eXg <br>
     * <br>
     * eXgTvF Iu1vŌ݃WuXe[^Xρu2v̏ꍇA WuXe[^X茋ʂnullԋp邱ƂmFB <br>
     * <br>
     * mFځFnullԋp邱ƂmFB<br>
     * <br>
     * @throws Exception
     */
    public void testJudgmentStatus06() throws Exception {

        BatchJobData param = new BatchJobData();
        param.setJobAppCd("B000001");
        param.setCurAppStatus("2");

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        String result = exe.judgmentStatus(param, "0000000001", "1", "0");

        assertNull(result);

    }

    /**
     * WuXe[^XXV\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Nu0vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000001ṽWuXe[^X{u0v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂ邱ƁB
     * @throws Exception
     */
    public void testUpdateBatchStatus01() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        boolean result = exe.updateBatchStatus("0000000001", "0", null,
                queryDAO, updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000001",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("1", row.getCurAppStatus());
    }

    /**
     * WuXe[^XXV\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Nu0vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000002ṽWuXe[^Xsu1v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂ邱ƁB
     * @throws Exception
     */
    public void testUpdateBatchStatus02() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        boolean result = exe.updateBatchStatus("0000000002", "0", null,
                queryDAO, updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000002",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("1", row.getCurAppStatus());
    }

    /**
     * WuXe[^XXV\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Nu0vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000003ṽWuXe[^Xρu2v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂ邱ƁB
     * @throws Exception
     */
    public void testUpdateBatchStatus03() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        boolean result = exe.updateBatchStatus("0000000003", "0", null,
                queryDAO, updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000003",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("2", row.getCurAppStatus());
    }

    /**
     * WuXe[^XXV\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Iu1vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000001ṽWuXe[^X{u0v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂ邱ƁB
     * @throws Exception
     */
    public void testUpdateBatchStatus04() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        boolean result = exe.updateBatchStatus("0000000001", "1", "0",
                queryDAO, updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000001",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("0", row.getCurAppStatus());
    }

    /**
     * WuXe[^XXV\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Iu1vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000002ṽWuXe[^Xsu1v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂ邱ƁB
     * @throws Exception
     */
    public void testUpdateBatchStatus05() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        boolean result = exe.updateBatchStatus("0000000002", "1", "0",
                queryDAO, updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000002",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("2", row.getCurAppStatus());
    }

    /**
     * WuXe[^XXV\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Iu1vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000003ṽWuXe[^Xρu2v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂ邱ƁB
     * @throws Exception
     */
    public void testUpdateBatchStatus06() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        boolean result = exe.updateBatchStatus("0000000003", "1", "0",
                queryDAO, updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000003",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("2", row.getCurAppStatus());
    }

    /**
     * WuXe[^XXViWuIj\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Iu1vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000001ṽWuXe[^X{u0v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂȂƁB
     * @throws Exception
     */
    public void testEndBatchStatus01() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        BLogicResult blogicResult = new BLogicResult();
        boolean result = exe.endBatchStatus("0000000001", blogicResult,
                queryDAO, updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000001",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("0", row.getCurAppStatus());

    }

    /**
     * WuXe[^XXViWuIj\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Iu1vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000002ṽWuXe[^Xsu1v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂ邱ƁB
     * @throws Exception
     */
    public void testEndBatchStatus02() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        BLogicResult blogicResult = new BLogicResult();
        boolean result = exe.endBatchStatus("0000000002", blogicResult,
                queryDAO, updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000002",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("2", row.getCurAppStatus());

    }

    /**
     * WuXe[^XXViWuIj\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Iu1vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000003ṽWuXe[^Xρu2v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂȂƁB
     * @throws Exception
     */
    public void testEndBatchStatus03() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        BLogicResult blogicResult = new BLogicResult();
        boolean result = exe.endBatchStatus("0000000003", blogicResult,
                queryDAO, updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000003",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("2", row.getCurAppStatus());

    }

    /**
     * WuXe[^XXViWuJnj\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Nu0vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000001ṽWuXe[^X{u0v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂ邱ƁB
     * @throws Exception
     */
    public void testStartBatchStatus01() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        boolean result = exe.startBatchStatus("0000000001", queryDAO,
                updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000001",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("1", row.getCurAppStatus());

    }

    /**
     * WuXe[^XXViWuJnj\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Nu0vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000002ṽWuXe[^Xsu1v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂȂƁB
     * @throws Exception
     */
    public void testStartBatchStatus02() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        boolean result = exe.startBatchStatus("0000000002", queryDAO,
                updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000002",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("1", row.getCurAppStatus());

    }

    /**
     * WuXe[^XXViWuJnj\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Nu0vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000003ṽWuXe[^Xρu2v̏ꍇ trueԋp邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * trueԋp邱ƁB<br>
     * DB̃Xe[^XXVĂȂƁB
     * @throws Exception
     */
    public void testStartBatchStatus03() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        boolean result = exe.startBatchStatus("0000000003", queryDAO,
                updateDAO, transactionManager);

        BatchJobData row = queryForRowObject(
                "select * from job_control where job_seq_id = 0000000003",
                BatchJobData.class);

        assertTrue(result);
        assertEquals("2", row.getCurAppStatus());

    }

    /**
     * Wus\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * Nu0vŃWuǗe[uɓo^Ă WuV[PXR[hu0000000001ṽWu Ɏs邱ƂmFB <br>
     * <br>
     * mFځF<br>
     * WuIR[h0ԋp邱ƁB<br>
     * DB̃Xe[^XXVĂ邱ƁB
     * @throws Exception
     */
    public void testExecuteBatch01() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        exe.sysQueryDAO = queryDAO;
        exe.sysUpdateDAO = updateDAO;
        exe.sysTransactionManager = transactionManager;
        BLogicResult result = exe.executeBatch("0000000001");

        assertNotNull(result);
        assertEquals(0, result.getBlogicStatus());
    }

    public void testExecuteBatch02() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        exe.sysQueryDAO = null;
        exe.sysUpdateDAO = null;
        exe.sysTransactionManager = null;
        BLogicResult result = exe.executeBatch("0000000001");

        assertNotNull(result);
        assertEquals(-1, result.getBlogicStatus());
    }

    public void testExecuteBatch03() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        exe.sysQueryDAO = queryDAO;
        exe.sysUpdateDAO = updateDAO;
        exe.sysTransactionManager = transactionManager;
        BLogicResult result = exe.executeBatch("0000000000");

        assertNotNull(result);
        assertEquals(-1, result.getBlogicStatus());
    }

    public void testExecuteBatch04() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        exe.sysQueryDAO = queryDAO;
        exe.sysUpdateDAO = updateDAO;
        exe.sysTransactionManager = transactionManager;
        exe.changeStartStatus = true;
        BLogicResult result = exe.executeBatch("0000000001");

        assertNotNull(result);
        assertEquals(0, result.getBlogicStatus());
    }

    public void testExecuteBatch05() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        exe.sysQueryDAO = queryDAO;
        exe.sysUpdateDAO = updateDAO;
        exe.sysTransactionManager = transactionManager;
        exe.changeStartStatus = true;
        BLogicResult result = exe.executeBatch("0000000003");

        assertNotNull(result);
        assertEquals(0, result.getBlogicStatus());
    }

    /**
     * GetJobIntervalTime\bh̃eXg<br>
     * <br>
     * eXgTvF getter\bh̃eXgł邽߁AlmɕԂ邱ƂmFB
     * @throws Exception
     */
    public void testGetJobIntervalTime01() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        assertEquals(3000, exe.getJobIntervalTime());
    }

    /**
     * getExecutorEndMonitoringFile\bh̃eXg<br>
     * <br>
     * eXgTvFgetter\bh̃eXgł邽߁Alnullł邱ƂmFB
     * @throws Exception
     */
    public void testGetExecutorEndMonitoringFile01() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        assertNotNull(exe.getExecutorEndMonitoringFile());
        assertEquals("/tmp/batch_terminate_file", exe
                .getExecutorEndMonitoringFile());
    }

    /**
     * getExecutorJobTerminateWaitIntervalTime\bh̃eXg<br>
     * <br>
     * eXgTvFgetter\bh̃eXgł邽߁Al5000ł邱ƂmFB
     * @throws Exception
     */
    public void testGetExecutorJobTerminateWaitIntervalTime01()
                                                               throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        assertEquals(3000, exe.getExecutorJobTerminateWaitIntervalTime());
    }

    /**
     * setChangeStartStatus\bh̃eXg<br>
     * <br>
     * eXgTvFsetter\bh̃eXgł邽߁Alfalseł邱ƂmFB
     * @throws Exception
     */
    public void testSetChangeStartStatus01() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        assertFalse(exe.changeStartStatus);

    }

    /**
     * setChangeStartStatus\bh̃eXg<br>
     * <br>
     * eXgTvFsetter\bh̃eXgł邽߁Atrue^Atrueԋp邱ƂmFB
     * @throws Exception
     */
    public void testSetChangeStartStatus02() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        exe.setChangeStartStatus(true);

        assertTrue(exe.changeStartStatus);
    }

    public void testInitParameter01() {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils.removeProperty("polling.interval");
        exe.initParameter();

        assertEquals(1000, exe.jobIntervalTime);

    }

    public void testInitParameter02() {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils.removeProperty("polling.interval");
        TerasolunaPropertyUtils.addProperty("polling.interval", "5000");
        exe.initParameter();

        assertEquals(5000, exe.jobIntervalTime);

    }

    public void testInitParameter03() {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils.removeProperty("polling.interval");
        TerasolunaPropertyUtils.addProperty("polling.interval", "test");
        exe.initParameter();

        assertEquals(1000, exe.jobIntervalTime);

    }

    public void testInitParameter04() {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils.removeProperty("executor.endMonitoringFile");
        exe.initParameter();

        assertNull(exe.executorEndMonitoringFile);

    }

    public void testInitParameter05() {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils.removeProperty("executor.endMonitoringFile");
        TerasolunaPropertyUtils.addProperty("executor.endMonitoringFile",
                "/tmp/batch_terminate_file2");
        exe.initParameter();

        assertEquals("/tmp/batch_terminate_file2",
                exe.executorEndMonitoringFile);

    }

    public void testInitParameter06() {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils
                .removeProperty("executor.jobTerminateWaitInterval");
        exe.initParameter();

        assertEquals(5000, exe.executorJobTerminateWaitIntervalTime);

    }

    public void testInitParameter07() {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils
                .removeProperty("executor.jobTerminateWaitInterval");
        TerasolunaPropertyUtils.addProperty(
                "executor.jobTerminateWaitInterval", "8000");
        exe.initParameter();

        assertEquals(8000, exe.executorJobTerminateWaitIntervalTime);

    }

    public void testInitParameter08() {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils
                .removeProperty("executor.jobTerminateWaitInterval");
        TerasolunaPropertyUtils.addProperty(
                "executor.jobTerminateWaitInterval", "test");
        exe.initParameter();

        assertEquals(5000, exe.executorJobTerminateWaitIntervalTime);

    }

    public void testInitSystemDatasourceDao01() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        TerasolunaPropertyUtils.removeProperty("systemDataSource.queryDAO");
        exe.sysQueryDAO = null;
        exe.initSystemDatasourceDao();

        assertNull(exe.sysQueryDAO);
    }

    public void testInitSystemDatasourceDao02() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        TerasolunaPropertyUtils.removeProperty("systemDataSource.queryDAO");
        TerasolunaPropertyUtils
                .addProperty("systemDataSource.queryDAO", "test");
        exe.sysQueryDAO = null;
        exe.initSystemDatasourceDao();

        assertNull(exe.sysQueryDAO);
    }

    public void testInitSystemDatasourceDao03() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        TerasolunaPropertyUtils.removeProperty("systemDataSource.queryDAO");
        TerasolunaPropertyUtils.addProperty("systemDataSource.queryDAO",
                "adminUpdateDAO");
        exe.sysQueryDAO = null;
        exe.initSystemDatasourceDao();

        assertNull(exe.sysQueryDAO);
    }

    public void testInitSystemDatasourceDao04() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        TerasolunaPropertyUtils.removeProperty("systemDataSource.updateDAO");
        exe.sysUpdateDAO = null;
        exe.initSystemDatasourceDao();

        assertNull(exe.sysUpdateDAO);
    }

    public void testInitSystemDatasourceDao05() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        TerasolunaPropertyUtils.removeProperty("systemDataSource.updateDAO");
        TerasolunaPropertyUtils.addProperty("systemDataSource.updateDAO",
                "test");
        exe.sysUpdateDAO = null;
        exe.initSystemDatasourceDao();

        assertNull(exe.sysUpdateDAO);
    }

    public void testInitSystemDatasourceDao06() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        TerasolunaPropertyUtils.removeProperty("systemDataSource.updateDAO");
        TerasolunaPropertyUtils.addProperty("systemDataSource.updateDAO",
                "adminQueryDAO");
        exe.sysUpdateDAO = null;
        exe.initSystemDatasourceDao();

        assertNull(exe.sysUpdateDAO);
    }

    public void testInitSystemDatasourceDao07() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        TerasolunaPropertyUtils
                .removeProperty("systemDataSource.transactionManager");
        exe.sysTransactionManager = null;
        exe.initSystemDatasourceDao();

        assertNull(exe.sysTransactionManager);
    }

    public void testInitSystemDatasourceDao08() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        TerasolunaPropertyUtils
                .removeProperty("systemDataSource.transactionManager");
        TerasolunaPropertyUtils.addProperty(
                "systemDataSource.transactionManager", "test");
        exe.sysTransactionManager = null;
        exe.initSystemDatasourceDao();

        assertNull(exe.sysTransactionManager);
    }

    public void testInitSystemDatasourceDao09() throws Exception {

        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();
        TerasolunaPropertyUtils
                .removeProperty("systemDataSource.transactionManager");
        TerasolunaPropertyUtils.addProperty(
                "systemDataSource.transactionManager", "adminQueryDAO");
        exe.sysTransactionManager = null;
        exe.initSystemDatasourceDao();

        assertNull(exe.sysTransactionManager);
    }

    /**
     * testInitDefaultAppContext001
     * @throws Exception
     */
    public void testInitDefaultAppContext001() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        exe.initDefaultAppContext();
    }

    /**
     * testInitDefaultAppContext002
     * @throws Exception
     */
    public void testInitDefaultAppContext002() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils
                .removeProperty("beanDefinition.admin.classpath");
        TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.default");

        exe.initDefaultAppContext();
    }

    /**
     * testInitDefaultAppContext003
     * @throws Exception
     */
    public void testInitDefaultAppContext003() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils
                .removeProperty("beanDefinition.admin.classpath");
        TerasolunaPropertyUtils
                .removeProperty("beanDefinition.admin.dataSource");

        exe.initDefaultAppContext();
    }

    /**
     * testInitDefaultAppContext004
     * @throws Exception
     */
    public void testInitDefaultAppContext004() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils
                .removeProperty("beanDefinition.admin.dataSource");
        TerasolunaPropertyUtils
                .removeProperty("beanDefinition.admin.dataSource");

        exe.initDefaultAppContext();
    }

    /**
     * testInitSystemDatasourceDao001
     * @throws Exception
     */
    public void testInitSystemDatasourceDao001() throws Exception {
        AbstractJobBatchExecutor exe = new AsyncBatchExecutor();

        TerasolunaPropertyUtils
                .removeProperty("beanDefinition.admin.dataSource");
        TerasolunaPropertyUtils
                .removeProperty("beanDefinition.admin.dataSource");

        exe.initDefaultAppContext();
        exe.initSystemDatasourceDao();
    }
}
