/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.mock;

import java.util.List;

import jp.terasoluna.fw.dao.SqlHolder;
import jp.terasoluna.fw.dao.UpdateDAO;

/**
 * {@link UpdateDAO}̃bNłB
 * <p>
 * {@link UpdateDAO}̊e\bhԂl{@link MockUpdateDao#addResult(Object)}ɂĐݒł܂B <br>
 * ȉɎgp܂B <code>addResult</code>̈{@link RuntimeException}pNXݒ肵ꍇA
 * {@link UpdateDAO}̃\bhsɂX[܂B<br>
 * ̋Ɩɑ΂
 * </p>
 * 
 * <pre>
 * public class SampleBLogic3 implements BLogic&lt;SampleInput&gt; {
 *     private UpdateDAO updateDAO;
 * 
 *     public BLogicResult execute(SampleInput params) {
 *         int count = getUpdateDAO().execute(&quot;deleteContent01&quot;, params);
 *         BLogicResult result = new BLogicResult();
 *         result.setResultString(&quot;success&quot;);
 *         result.setResultObject(count);
 *         return result;
 *     }
 * 
 *     public void setUpdateDAO(UpdateDAO updateDAO) {
 *         this.updateDAO = updateDAO;
 *     }
 * 
 *     public UpdateDAO getUpdateDAO() {
 *         return updateDAO;
 *     }
 * }
 * 
 * </pre>
 * <p>
 * eXgR[h͈ȉ̂悤ɋLq܂B
 * </p>
 * 
 * <pre>
 * SampleBLogic3 bLogic = new SampleBLogic3();
 * MockUpdateDao updateDao = new MockUpdateDao();
 * // UpdateDAO#execute̕Ԃlݒ
 * updateDao.addResult(3);
 * // bNݒ
 * bLogic.setUpdateDAO(updateDao);
 * // ͒l
 * SampleInput input = new SampleInput();
 * // eXg\bhs
 * BLogicResult result = bLogic.execute(input);
 * // Ԃľ
 * AssertUtils.assertBLogicSuccess(result);
 * // ʃIuWFNgɐݒ肳ꂽDAO̎sʂ
 * assertEquals(3, result.getResultObject());
 * // DAO\bḧ
 * AssertUtils.assertCollectionSizeEquals(1, updateDao.getParams());
 * DaoParam param = updateDao.getParams().get(0);
 * assertEquals(input, param.getBindParams());
 * assertEquals(&quot;deleteContent01&quot;, param.getSqlId());
 * </pre>
 */
public class MockUpdateDao extends AbstractMockDao implements UpdateDAO {

    public void addBatch(String sqlId, Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        pollAndExecuteIfCallback(new Object[] { sqlId, bindParams });
    }

    public int execute(String sqlId, Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        return pollInt();
    }

    @Deprecated
    public int executeBatch() {
        addParam(new DaoParam(null, null));
        return pollInt();
    }

    public int executeBatch(List<SqlHolder> sqlHolders) {
        for (SqlHolder sqlHolder : sqlHolders) {
            addParam(new DaoParam(sqlHolder.getSqlID(),
                    sqlHolder.getBindParams()));
        }
        return pollInt();
    }

}
