/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import java.util.Locale;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;

/**
 * {@link jp.terasoluna.fw.beans.jxpath.BeanPointerFactoryEx} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Bean|C^t@Ng̊gNXB<br>
 * OF
 * <p>
 * 
 * @see jp.terasoluna.fw.beans.jxpath.BeanPointerFactoryEx
 */
public class BeanPointerFactoryExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BeanPointerFactoryExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BeanPointerFactoryExTest(String name) {
        super(name);
    }

    /**
     * testGetOrder01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF
     * <br>
     * ҒlF(߂l) -:850<br>
     *         
     * <br>
     * \[g擾郁\bhBŒlԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetOrder01() throws Exception {
        // O
    	BeanPointerFactoryEx factory = new BeanPointerFactoryEx();

        // eXg{
    	assertEquals(850, factory.getOrder());
    }

    /**
     * testCreateNodePointerQname01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:not null<br>
     *         () bean:new Object()<br>
     *         () locale:Locale("ja")<br>
     *         
     * <br>
     * ҒlF(߂l) NodePointer:new BeanPointerEX {<br>
     *                      locale=locale<br>
     *                      name=name<br>
     *                      bean=bean<br>
     *                  }<br>
     *         
     * <br>
     * m[h|C^擾eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateNodePointerQname01() throws Exception {
        // O
    	BeanPointerFactoryEx factory = new BeanPointerFactoryEx();
    	QName qName = new QName("name");
    	Object bean = new Object();
    	Locale locale = new Locale("ja");

        // eXg{
    	NodePointer result = factory.createNodePointer(qName, bean, locale);

        // 
    	assertSame(BeanPointerEx.class, result.getClass());
    	assertSame(locale, result.getLocale());
    	assertSame(qName, result.getName());
    	assertSame(bean, UTUtil.getPrivateField(result, "bean"));
    }

    /**
     * testCreateNodePointerNodePointer01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() parent:not null<br>
     *         () name:not null<br>
     *         () bean:null<br>
     *         
     * <br>
     * ҒlF(߂l) NodePointer:new NullPointer {<br>
     *                      parent=parent<br>
     *                      name=name<br>
     *                  }<br>
     *         
     * <br>
     * ^[Qbgnull̏ꍇ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateNodePointerNodePointer01() throws Exception {
        // O
    	BeanPointerFactoryEx factory = new BeanPointerFactoryEx();
    	QName qName = new QName("name");
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, null, locale);

        // eXg{
    	NodePointer result = factory.createNodePointer(nodePointer, qName, null);

        // 
    	assertSame(NullPointer.class, result.getClass());
    	assertSame(nodePointer, result.getParent());
    	assertSame(qName, result.getName());
    }

    /**
     * testCreateNodePointerNodePointer02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() parent:not null<br>
     *         () name:not null<br>
     *         () bean:new Object()<br>
     *         
     * <br>
     * ҒlF(߂l) NodePointer:new BeanPointerEX {<br>
     *                      parent=parent<br>
     *                      name=name<br>
     *                      bean=bean<br>
     *                  }<br>
     *         
     * <br>
     * ^[Qbgnullł͂Ȃꍇ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateNodePointerNodePointer02() throws Exception {
        // O
    	BeanPointerFactoryEx factory = new BeanPointerFactoryEx();
    	QName qName = new QName("name");
    	Object bean = new Object();
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, bean, locale);

        // eXg{
    	NodePointer result = factory.createNodePointer(nodePointer, qName, bean);

        // 
    	assertSame(BeanPointerEx.class, result.getClass());
    	assertSame(nodePointer, result.getParent());
    	assertSame(qName, result.getName());
    	assertSame(bean, UTUtil.getPrivateField(result, "bean"));
    }
}
