/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.util;

import java.util.ArrayList;
import java.util.List;

import org.springframework.transaction.TransactionDefinition;

import jp.terasoluna.fw.batch.util.BatchUtil;
import jp.terasoluna.fw.dao.IllegalClassTypeException;
import junit.framework.TestCase;

/**
 * 
 * 
 */
public class BatchUtilTest extends TestCase {

	/**
	 * 񌋍\bh̃eXg<br>
	 * <br>
	 * eXgTvF<br>
	 * ͂ꂽz̓eɌ邩ǂmFB <br>
	 * mFځF<br>
	 * ꂽ񂪕ԋp邱<br>
	 * 
	 * @throws Exception
	 */
	public void testCat01() throws Exception {

		// eXg̓f[^ݒ
		String[] args = { "test1", "test2" };

		// eXg{
		String result = BatchUtil.cat((Object[]) args);

		// ʌ
		assertEquals("test1test2", result);
	}

	/**
	 * 񌋍\bh̃eXg<br>
	 * <br>
	 * eXgTvF<br>
	 * nullݒ肳ꂽꍇnullԋp邱ƂmFB <br>
	 * mFځF<br>
	 * nullԋp邱<br>
	 * 
	 * @throws Exception
	 */
	public void testCat02() throws Exception {

		// eXg̓f[^ݒ
		String[] args = null;

		// eXg{
		String result = BatchUtil.cat((Object[]) args);

		// ʌ
		assertNull(result);
	}

	/**
	 * 񌋍\bh̃eXg<br>
	 * <br>
	 * eXgTvF<br>
	 * 󕶎ݒ肳ꂽꍇA󕶎ԋp邱ƂmFB <br>
	 * mFځF<br>
	 * 󕶎ԋp邱<br>
	 * 
	 * @throws Exception
	 */
	public void testCat03() throws Exception {

		// eXg̓f[^ݒ
		String[] args = { "" };

		// eXg{
		String result = BatchUtil.cat((Object[]) args);

		// ʌ
		assertEquals("", result);
	}

	/**
	 * 񌋍\bh̃eXg<br>
	 * <br>
	 * eXgTvF<br>
	 * 3ȏ̕񂪐ݒ肳ĂAԂ̕null܂܂ĂꍇAnull͔΂Čԋp邱ƂmFB <br>
	 * mFځF<br>
	 * null΂񂪕ԋp邱<br>
	 * 
	 * @throws Exception
	 */
	public void testCat04() throws Exception {

		// eXg̓f[^ݒ
		String[] args = { "test1", null, "test2" };

		// eXg{
		String result = BatchUtil.cat((Object[]) args);

		// ʌ
		assertEquals("test1test2", result);
	}

	/**
	 * CtHO̊JnbZ[W擾郁\bh̃eXg<br><br>
	 * 
	 * eXgTvF<br>
	 * ͂ɕ^Az肵O񂪕ԋp邱ƂmFB<br>
	 * mFځF<br>
	 * ͕񂪖ߍ܂ꂽO񂪕ԋp邱<br>
	 * 
	 * 
	 * @throws Exception
	 */
	public void testGetInfoLogStartMsg01() throws Exception {

		// eXg̓f[^ݒ
		String arg = "test1";

		// eXg{
		String result = BatchUtil.getInfoLogStartMsg(arg);

		// ʌ
		assertEquals("[test1] Jn", result);
	}

	
	/**
	 * CtHO̊JnbZ[W擾郁\bh̃eXg<br><br>
	 * 
	 * eXgTvF<br>
	 * ͂null^Az肵O񂪕ԋp邱ƂmFB<br>
	 * mFځF<br>
	 * ͕񂪖ߍ܂ȂO񂪕ԋp邱<br>
	 * 
	 * 
	 * @throws Exception
	 */
	public void testGetInfoLogStartMsg02() throws Exception {

		// eXg̓f[^ݒ
		String arg = null;

		// eXg{
		String result = BatchUtil.getInfoLogStartMsg(arg);

		// ʌ
		assertEquals("[] Jn", result);
	}
	
	/**
	 * CtHO̊JnbZ[W擾郁\bh̃eXg<br><br>
	 * 
	 * eXgTvF<br>
	 * ͂ɋ󕶎^Az肵O񂪕ԋp邱ƂmFB<br>
	 * mFځF<br>
	 * ͕񂪖ߍ܂ȂO񂪕ԋp邱<br>
	 * 
	 * 
	 * @throws Exception
	 */
	public void testGetInfoLogStartMsg03() throws Exception {

		// eXg̓f[^ݒ
		String arg = "";

		// eXg{
		String result = BatchUtil.getInfoLogStartMsg(arg);

		// ʌ
		assertEquals("[] Jn", result);
	}

	
	
	/**
	 * CtHȌIbZ[W擾郁\bh̃eXg<br><br>
	 * 
	 * eXgTvF<br>
	 * ͂ɕ^Az肵O񂪕ԋp邱ƂmFB<br>
	 * mFځF<br>
	 * ͕񂪖ߍ܂ꂽO񂪕ԋp邱<br>
	 * 
	 * 
	 * @throws Exception
	 */
	public void testGetInfoLogEndMsg01() throws Exception {

		// eXg̓f[^ݒ
		String arg = "test1";

		// eXg{
		String result = BatchUtil.getInfoLogEndMsg(arg);

		// ʌ
		assertEquals("[test1] I", result);
	}

	/**
	 * CtHȌIbZ[W擾郁\bh̃eXg<br><br>
	 * 
	 * eXgTvF<br>
	 * ͂ɋ󕶎^Az肵O񂪕ԋp邱ƂmFB<br>
	 * mFځF<br>
	 * ͕񂪖ߍ܂ȂO񂪕ԋp邱<br>
	 * 
	 * 
	 * @throws Exception
	 */
	public void testGetInfoLogEndMsg02() throws Exception {

		// eXg̓f[^ݒ
		String arg = null;

		// eXg{
		String result = BatchUtil.getInfoLogEndMsg(arg);

		// ʌ
		assertEquals("[] I", result);
	}
	
	/**
	 * CtHȌIbZ[W擾郁\bh̃eXg<br><br>
	 * 
	 * eXgTvF<br>
	 * ͂ɋ󕶎^Az肵O񂪕ԋp邱ƂmFB<br>
	 * mFځF<br>
	 * ͕񂪖ߍ܂ȂO񂪕ԋp邱<br>
	 * 
	 * 
	 * @throws Exception
	 */
	public void testGetInfoLogEndMsg03() throws Exception {

		// eXg̓f[^ݒ
		String arg = "";

		// eXg{
		String result = BatchUtil.getInfoLogEndMsg(arg);

		// ʌ
		assertEquals("[] I", result);
	}
	
	
	
	
	public void testGetTransactionDefinition01() throws Exception {

		// eXg{
		TransactionDefinition result = BatchUtil.getTransactionDefinition();

		// ʌ
		assertNotNull(result);
	}

	public void testChangeListToArray01() throws Exception {

		// eXg̓f[^ݒ
		List<String> list = new ArrayList<String>();
		list.add("test1");
		list.add("test2");
		list.add("test3");

		// eXg{
		String[] result = BatchUtil.changeListToArray(list, String.class);

		// ʌ
		assertEquals("test1", result[0]);
		assertEquals("test2", result[1]);
		assertEquals("test3", result[2]);
	}

	public void testChangeListToArray02() throws Exception {

		// eXg̓f[^ݒ
		List<String> list = new ArrayList<String>();
		list.add("test1");
		list.add("test2");
		list.add("test3");
		try {

			// eXg{
			String[] result = BatchUtil.changeListToArray(list, null);

			// ʌ
			fail();
		} catch (IllegalClassTypeException e) {
			// TODO: handle exception
		}

	}

	public void testChangeListToArray03() throws Exception {

		// eXg̓f[^ݒ
		List<String> list = new ArrayList<String>();
		list.add("test1");
		list.add("test2");
		list.add("test3");
		try {
			// eXg{
			String[] result = BatchUtil.changeListToArray(list, Integer.class);

			// ʌ
			fail();
		} catch (IllegalClassTypeException e) {
			// TODO: handle exception
		}

	}

	public void testGetProperties01() throws Exception {

		// eXg{
		List<String> result = BatchUtil.getProperties("messages", "errors");

		// ʌ
		assertEquals(26, result.size());
	}
}
