/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.executor;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import java.util.Map;

import javax.management.Query;

import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.executor.AbstractBatchExecutor;
import jp.terasoluna.fw.batch.executor.AsyncBatchExecutor;
import jp.terasoluna.fw.batch.executor.SyncBatchExecutor;
import jp.terasoluna.fw.batch.executor.vo.BLogicResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.ex.unit.util.TerasolunaPropertyUtils;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * AbstractBatchExecutorTest̃eXgP[XNX
 */
public class AbstractBatchExecutorTest extends TestCase {

	/**
	 * blogicBeanNamenull̏ꍇABLogicResult̃^[R[h-1ԋp邱ƂmF
	 * ܂OJOB_APP_CD:[null]o͂Ă邱ƂmF
	 * 
	 * @throws Exception
	 */
	public void testExecuteBatch01() throws Exception {

		// eXg̓f[^ݒ
		BatchJobData param = new BatchJobData();

		// eXg{
		AbstractBatchExecutor batchExecutor = new SyncBatchExecutor();
		BLogicResult result = batchExecutor.executeBatch(param);

		// ʌ
		assertEquals(-1, result.getBlogicStatus());
	}

	/**
	 * blogicBeanName󕶎̏ꍇABLogicResult̃^[R[h-1ԋp邱ƂmF
	 * ܂OJOB_APP_CD:[]o͂Ă邱ƂmF
	 * 
	 * @throws Exception
	 */
	public void testExecuteBatch02() throws Exception {

		// eXg̓f[^ݒ
		BatchJobData param = new BatchJobData();
		param.setJobAppCd("");
		// eXg{
		AbstractBatchExecutor batchExecutor = new SyncBatchExecutor();
		BLogicResult result = batchExecutor.executeBatch(param);

		// ʌ
		assertEquals(-1, result.getBlogicStatus());
	}

	/**
	 * blogicBeanNameB000001̏ꍇABLogicResult̃^[R[h0ԋp邱ƂmF
	 * eXg{邽߂ɂ́AWuBean`t@C[B000001.xml]B000001BLogic.javaKvƂȂ
	 * 
	 * @throws Exception
	 */
	public void testExecuteBatch03() throws Exception {

		// eXg̓f[^ݒ
		BatchJobData param = new BatchJobData();
		param.setJobAppCd("B000001");
		// eXg{
		AbstractBatchExecutor batchExecutor = new SyncBatchExecutor();
		BLogicResult result = batchExecutor.executeBatch(param);

		// ʌ
		assertEquals(0, result.getBlogicStatus());
	}

	/**
	 * blogicBeanNameB000001̏ꍇABLogicResult̃^[R[h0ԋp邱ƂmF
	 * eXg{邽߂ɂ́AWuBean`t@C[B000001.xml]B000001BLogic.javaKvƂȂ
	 * 
	 * @throws Exception
	 */
	public void testExecuteBatch04() throws Exception {

		// eXg̓f[^ݒ
		BatchJobData param = new BatchJobData();
		param.setJobAppCd("B000001");
		param.setJobArgNm1("test1");
		// eXg{
		AbstractBatchExecutor batchExecutor = new SyncBatchExecutor();
		BLogicResult result = batchExecutor.executeBatch(param);

		// ʌ
		assertEquals(0, result.getBlogicStatus());
	}

	/**
	 * blogicBeanNameB000001̏ꍇABLogicResult̃^[R[h0ԋp邱ƂmF
	 * eXg{邽߂ɂ́AWuBean`t@C[B000001.xml]B000001BLogic.javaKvƂȂ
	 * 
	 * @throws Exception
	 */
	public void testExecuteBatch05() throws Exception {

		// eXg̓f[^ݒ
		BatchJobData param = new BatchJobData();
		param.setJobAppCd("B000001");
		param.setJobArgNm1("test1");
		param.setJobArgNm2("test2");
		param.setJobArgNm3("test3");
		param.setJobArgNm4("test4");
		param.setJobArgNm5("test5");
		param.setJobArgNm6("test6");
		param.setJobArgNm7("test7");
		param.setJobArgNm8("test8");
		param.setJobArgNm9("test9");
		param.setJobArgNm10("test10");
		param.setJobArgNm11("test11");
		param.setJobArgNm12("test12");
		param.setJobArgNm13("test13");
		param.setJobArgNm14("test14");
		param.setJobArgNm15("test15");
		param.setJobArgNm16("test16");
		param.setJobArgNm17("test17");
		param.setJobArgNm18("test18");
		param.setJobArgNm19("test19");
		param.setJobArgNm20("test20");
		// eXg{
		AbstractBatchExecutor batchExecutor = new SyncBatchExecutor();
		BLogicResult result = batchExecutor.executeBatch(param);

		// ʌ
		assertEquals(0, result.getBlogicStatus());
	}

	/**
	 * blogicBeanNameB000001̏ꍇABLogicResult̃^[R[h0ԋp邱ƂmF
	 * eXg{邽߂ɂ́AWuBean`t@C[B000001.xml]B000001BLogic.javaKvƂȂ
	 * 
	 * @throws Exception
	 */
	public void testExecuteBatch06() throws Exception {

		// eXg̓f[^ݒ
		BatchJobData param = new BatchJobData();
		param.setJobAppCd("B000002");
		// eXg{
		AbstractBatchExecutor batchExecutor = new SyncBatchExecutor();
		BLogicResult result = batchExecutor.executeBatch(param);

		// ʌ
		assertEquals(1, result.getBlogicStatus());
	}

	/**
	 * blogicBeanNameB000001̏ꍇABLogicResult̃^[R[h0ԋp邱ƂmF
	 * eXg{邽߂ɂ́AWuBean`t@C[B000001.xml]B000001BLogic.javaKvƂȂ
	 * 
	 * @throws Exception
	 */
	public void testExecuteBatch07() throws Exception {

		// eXg̓f[^ݒ
		BatchJobData param = new BatchJobData();
		param.setJobAppCd("B000003");
		// eXg{
		AbstractBatchExecutor batchExecutor = new SyncBatchExecutor();
		BLogicResult result = batchExecutor.executeBatch(param);

		// ʌ
		assertEquals(255, result.getBlogicStatus());
	}

	/**
	 * blogicBeanNameB000001̏ꍇABLogicResult̃^[R[h0ԋp邱ƂmF
	 * eXg{邽߂ɂ́AWuBean`t@C[B000001.xml]B000001BLogic.javaKvƂȂ
	 * 
	 * @throws Exception
	 */
	public void testExecuteBatch08() throws Exception {

		// eXg̓f[^ݒ
		BatchJobData param = new BatchJobData();
		param.setJobAppCd("B000004");
		// eXg{
		AbstractBatchExecutor batchExecutor = new SyncBatchExecutor();
		BLogicResult result = batchExecutor.executeBatch(param);

		// ʌ
		assertEquals(100, result.getBlogicStatus());
	}

	public void testExecuteBatchClass01() throws Exception {
		String batchClassName = null;
		String exceptionHandlerBeanName = null;
		BLogicParam param = null;

		// eXg
		AbstractBatchExecutor exe = new SyncBatchExecutor();
		ApplicationContext context = null;
		BLogicResult result = exe.executeBatchClass(batchClassName,
				exceptionHandlerBeanName, param, context);

		assertEquals(-1, result.getBlogicStatus());

	}

	public void testExecuteBatchClass02() throws Exception {
		String batchClassName = "B000001BLogic";
		String exceptionHandlerBeanName = "B000001ExceptionHandler";
		BLogicParam param = null;

		// eXg
		AbstractBatchExecutor exe = new SyncBatchExecutor();
		ApplicationContext context = new ClassPathXmlApplicationContext(
				"beansDef/B000001.xml");
		BLogicResult result = exe.executeBatchClass(batchClassName,
				exceptionHandlerBeanName, param, context);

		assertEquals(0, result.getBlogicStatus());

	}

	public void testExecuteBatchClass03() throws Exception {
		String batchClassName = "B000000BLogic";
		String exceptionHandlerBeanName = "B000001ExceptionHandler";
		BLogicParam param = null;

		// eXg
		AbstractBatchExecutor exe = new SyncBatchExecutor();
		ApplicationContext context = new ClassPathXmlApplicationContext(
				"beansDef/B000001.xml");
		BLogicResult result = exe.executeBatchClass(batchClassName,
				exceptionHandlerBeanName, param, context);

		assertEquals(-1, result.getBlogicStatus());

	}

	public void testExecuteBatchClass04() throws Exception {
		String batchClassName = "B000004BLogic";
		String exceptionHandlerBeanName = "B000004ExceptionHandler";
		BLogicParam param = null;

		// eXg
		AbstractBatchExecutor exe = new SyncBatchExecutor();
		ApplicationContext context = new ClassPathXmlApplicationContext(
				"beansDef/B000004.xml");
		BLogicResult result = exe.executeBatchClass(batchClassName,
				exceptionHandlerBeanName, param, context);

		assertEquals(100, result.getBlogicStatus());

	}

	public void testExecuteBatchClass05() throws Exception {
		String batchClassName = "B000000BLogic";
		String exceptionHandlerBeanName = "B000000ExceptionHandler";
		BLogicParam param = null;

		// eXg
		AbstractBatchExecutor exe = new SyncBatchExecutor();
		ApplicationContext context = new ClassPathXmlApplicationContext(
				"beansDef/B000001.xml");
		BLogicResult result = exe.executeBatchClass(batchClassName,
				exceptionHandlerBeanName, param, context);

		assertEquals(-1, result.getBlogicStatus());

	}
	
	
	public void testSetMethod01() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();
		boolean result = exe.setMethod(null, "test", "test");

		assertEquals(false, result);

	}

	public void testGetMethod01() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();
		Object result = exe.getMethod(null, "test1");

		assertNull(result);

	}

	public void testGetDefaultApplicationContext01() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();
		ApplicationContext result = exe.getDefaultApplicationContext();

		assertNotNull(result);

	}

	
	public void testGetSysQueryDAO01() throws Exception {

		AbstractBatchExecutor exe = new AsyncBatchExecutor();

		QueryDAO result = exe.getSysQueryDAO();

		assertNotNull(result);
	}

	public void testGetSysQueryDAO02() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();

		QueryDAO result = exe.getSysQueryDAO();

		assertNull(result);
	}
	
	public void testGetSysUpdateDAO01() throws Exception {

		AbstractBatchExecutor exe = new AsyncBatchExecutor();

		UpdateDAO result = exe.getSysUpdateDAO();

		assertNotNull(result);
	}

	public void testGetSysUpdateDAO02() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();

		UpdateDAO result = exe.getSysUpdateDAO();

		assertNull(result);
	}

	public void testGetSysTransactionManager01() throws Exception {

		AbstractBatchExecutor exe = new AsyncBatchExecutor();

		PlatformTransactionManager result = exe.getSysTransactionManager();

		assertNotNull(result);
	}

	public void testGetSysTransactionManager02() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();

		PlatformTransactionManager result = exe.getSysTransactionManager();

		assertNull(result);
	}

	
	@Override
	protected void setUp() throws Exception {
		TerasolunaPropertyUtils.saveProperties();
	}

	@Override
	protected void tearDown() throws Exception {
		TerasolunaPropertyUtils.restoreProperties();
	}
	

	public void testGetDefaultBeanFileName01() throws Exception {

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.default");
		
		String result = AbstractBatchExecutor.getDefaultBeanFileName();

		assertEquals("", result);
	}

	public void testGetDefaultBeanFileName02() throws Exception {

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.classpath", "beansDef/");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.default");
		
		String result = AbstractBatchExecutor.getDefaultBeanFileName();

		assertEquals("beansDef/", result);
	}

	public void testGetDefaultBeanFileName03() throws Exception {

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.default");
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.default", "AdminContext.xml");

		String result = AbstractBatchExecutor.getDefaultBeanFileName();

		assertEquals("AdminContext.xml", result);
	}

	public void testGetDefaultBeanFileName04() throws Exception {

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.default");
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.classpath", "beansDef/");
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.default", "AdminContext.xml");

		String result = AbstractBatchExecutor.getDefaultBeanFileName();

		assertEquals("beansDef/AdminContext.xml", result);
	}

	public void testGetDefaultBeanFileName05() throws Exception {

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.default");
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.classpath", null);
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.default", null);

		String result = AbstractBatchExecutor.getDefaultBeanFileName();

		assertEquals("", result);
	}

	public void testGetDataSourceBeanFileName01() throws Exception {

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.dataSource");

		String result = AbstractBatchExecutor.getDataSourceBeanFileName();

		assertEquals("", result);
	}

	public void testGetDataSourceBeanFileName02() throws Exception {

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.dataSource");
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.classpath", "beansDef/");

		String result = AbstractBatchExecutor.getDataSourceBeanFileName();

		assertEquals("beansDef/", result);
	}

	public void testGetDataSourceBeanFileName03() throws Exception {

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.dataSource");
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.dataSource",
				"AdminDataSource.xml");

		String result = AbstractBatchExecutor.getDataSourceBeanFileName();

		assertEquals("AdminDataSource.xml", result);
	}

	public void testGetDataSourceBeanFileName04() throws Exception {

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.dataSource");
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.classpath", "beansDef/");
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.dataSource",
				"AdminDataSource.xml");

		String result = AbstractBatchExecutor.getDataSourceBeanFileName();

		assertEquals("beansDef/AdminDataSource.xml", result);
	}

	public void testGetDataSourceBeanFileName05() throws Exception {

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.dataSource");
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.classpath", null);
		TerasolunaPropertyUtils.addProperty("beanDefinition.admin.dataSource", null);

		String result = AbstractBatchExecutor.getDataSourceBeanFileName();

		assertEquals("", result);
	}

	public void testInitDefaultAppContext01() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();

		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.classpath");
		TerasolunaPropertyUtils.removeProperty("beanDefinition.admin.default");

		exe.initDefaultAppContext();

	}


	public void testInitDefaultErrorMessage01() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();

		exe.defaultApplicationContext = null;

		exe.initDefaultErrorMessage();

	}

	public void testInitDefaultErrorMessage02() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();

		TerasolunaPropertyUtils.removeProperty("messageAccessor.default");

		exe.initDefaultErrorMessage();

	}

	public void testInitDefaultErrorMessage03() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();

		TerasolunaPropertyUtils.removeProperty("messageAccessor.default");
		TerasolunaPropertyUtils.addProperty("messageAccessor.default", null);

		exe.initDefaultErrorMessage();

	}

	public void testInitDefaultErrorMessage04() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();

		TerasolunaPropertyUtils.removeProperty("messageAccessor.default");
		TerasolunaPropertyUtils.addProperty("messageAccessor.default", "msgAcc");

		exe.initDefaultErrorMessage();

	}

	public void testGetBeanFileName01() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();
		String result = exe.getBeanFileName("");
		assertEquals("beansDef/.xml", result);
	}

	public void testGetBeanFileName02() throws Exception {

		AbstractBatchExecutor exe = new SyncBatchExecutor();
		TerasolunaPropertyUtils.removeProperty("beanDefinition.business.classpath");
		String result = exe.getBeanFileName("");

		assertEquals(".xml", result);
	}

	public void testGetApplicationContext01() throws Exception {

		String[] batchBeanFileName = { "beansDef/B000000.xml" };

		ApplicationContext result = AbstractBatchExecutor
				.getApplicationContext(batchBeanFileName);

		assertNull(result);

	}

	public void testGetApplicationContext02() throws Exception {

		String[] batchBeanFileName = { "beansDef/B000001.xml" };

		ApplicationContext result = AbstractBatchExecutor
				.getApplicationContext(batchBeanFileName);

		assertNotNull(result);
	}

	public void testGetApplicationContext03() throws Exception {

		String[] batchBeanFileName = { "beansDef/B000001.xml",
				"beansDef/B000002.xml", "beansDef/B000003.xml" };

		ApplicationContext result = AbstractBatchExecutor
				.getApplicationContext(batchBeanFileName);

		assertNotNull(result);
	}

	public void testGetApplicationContext04() throws Exception {

		String[] batchBeanFileName = { "beansDef/B000000.xml",
				"beansDef/B000001.xml", "beansDef/B000002.xml" };

		ApplicationContext result = AbstractBatchExecutor
				.getApplicationContext(batchBeanFileName);

		assertNull(result);

		// O̊mF
		// java.lang.reflect.InvocationTargetExceptionX[Ă邱

	}

	public void testGetApplicationContext05() throws Exception {

		String[] batchBeanFileName = { "beansDef/B000000.xml",
				"beansDef/B000001.xml", "beansDef/B000002.xml" };

		ClassLoader mockLoader = mock(ClassLoader.class);

		when(
				mockLoader
						.loadClass("org.springframework.context.support.ClassPathXmlApplicationContext"))
				.thenThrow(new ClassNotFoundException());

		ClassLoader clBackup = AbstractBatchExecutor.cl;
		AbstractBatchExecutor.cl = mockLoader;
		ApplicationContext result = AbstractBatchExecutor
				.getApplicationContext(batchBeanFileName);

		assertNull(result);

		AbstractBatchExecutor.cl = clBackup;
		// O̊mF
		// ClassNotFoundExceptionX[Ă邱

	}

	public void testGetBlogicBeanName01() throws Exception {
		
		AbstractBatchExecutor exe = new SyncBatchExecutor();
		String result = exe.getBlogicBeanName("B000000");
		
		assertEquals("B000000BLogic", result);
	}
	

	public void testGetBlogicBeanName02() throws Exception {
		
		
		AbstractBatchExecutor exe = new SyncBatchExecutor();
		String result = exe.getBlogicBeanName(null);
		
		assertEquals("", result);
	}
	
	public void testGetBlogicBeanName03() throws Exception {
		
		
		AbstractBatchExecutor exe = new SyncBatchExecutor();
		String result = exe.getBlogicBeanName("");
		
		assertEquals("", result);
	}
		
	
}
