/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.exception;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import jp.terasoluna.fw.batch.exception.BatchException;
import jp.terasoluna.fw.batch.message.MessageAccessor;
import jp.terasoluna.fw.batch.util.MessageUtil;
import jp.terasoluna.fw.util.PropertyUtil;
import junit.framework.TestCase;

/**
 * O<br>
 * <br>
 * 
 * Esrc/test/resourcestH_zAppricationResources.properties݂邱ƁB<br>
 * <br>
 * 
 * EvpeBMessageAccessor.default̒lݒ肳Ă邱ƁB<br>
 * <fieldset><legend>batch.propertiesݒ</legend>
 * #bZ[W\[XANZTBean<br>
 * MessageAccessor.default=msgAcc
 * 
 * </fieldset> <br>
 * EBean`t@CɃvpeBŐݒ肳ꂽ̒lBeanݒ肳Ă邱ƁB<br>
 * <fieldset><legend>AdminContext.xmlݒ</legend>
 * 
 * &lt;!-- bZ[WANZT --&gt;<br>
 * &lt;bean id=&quot;msgAcc&quot;
 * class=&quot;jp.terasoluna.fw.batch.message.MessageAccessorImpl&quot;
 * /&gt;
 * 
 * </fieldset> <br>
 * Emessages.propertiest@C݂邱<br>
 * 
 */
public class BatchExceptionTest extends TestCase {

	/**
	 * vpeBl擾l
	 */
	private String value = null;

	/**
	 * Reip̃tB[h
	 */
	private ApplicationContext context;

	/**
	 * MessageAccessorNX̃tB[h
	 */
	private MessageAccessor messageAccessor;

	@Override
	protected void setUp() throws Exception {

		// bZ[W\[XANZTBean擾
		context = new ClassPathXmlApplicationContext(
				"beansDef/AdminContext.xml");
		value = PropertyUtil.getProperty("messageAccessor.default");
		messageAccessor = (MessageAccessor) context.getBean(value,
				MessageAccessor.class);
		MessageUtil.setMessageAccessor(messageAccessor);
	}
	/**
	 * testBatchException01()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testBatchException01() throws Exception {

		BatchException result = new BatchException();
		assertNotNull(result);
	}

	/**
	 * testBatchException02()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFmessage"test"ݒ肳Ă邱<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testBatchException02() throws Exception {

		BatchException result = new BatchException("test");
		assertNotNull(result);
		assertEquals("test", result.getMessage());
	}

	/**
	 * testBatchException03()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFmessage"test"ݒ肳Ă邱<br>
	 * mFځFcauseRuntimeExceptionł邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testBatchException03() throws Exception {

		BatchException result = new BatchException("test",
				new RuntimeException());

		assertNotNull(result);
		assertEquals("test", result.getMessage());
		assertEquals("java.lang.RuntimeException", result.getCause().toString());
	}

	/**
	 * testBatchException04()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFcauseRuntimeExceptionł邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testBatchException04() throws Exception {

		BatchException result = new BatchException(new RuntimeException());

		assertNotNull(result);
		assertEquals("java.lang.RuntimeException", result.getCause().toString());
	}

	/**
	 * testCreateException01()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFerrors.requiredL[̃bZ[Wݒ肳Ă邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCreateException01() throws Exception {

		BatchException result = BatchException
				.createException("errors.required");

		assertNotNull(result);
		assertEquals("{0}͓͕K{ڂł.", result.getMessage());
	}

	/**
	 * testCreateException02()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFbZ[Wݒ肳ĂȂƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCreateException02() throws Exception {

		BatchException result = BatchException.createException(null);

		assertNotNull(result);
		assertEquals("Message not found. CODE:[null]", result.getMessage());
	}

	/**
	 * testCreateException03()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFbZ[Wݒ肳ĂȂƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCreateException03() throws Exception {

		BatchException result = BatchException.createException("");

		assertNotNull(result);
		assertEquals("Message not found. CODE:[]", result.getMessage());
	}

	/**
	 * testCreateException04()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFaerrors.requiredL[̃bZ[Wargݒ肳Ă邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCreateException04() throws Exception {

		BatchException result = BatchException.createException(
				"errors.required", "test1");

		assertNotNull(result);
		assertEquals("test1͓͕K{ڂł.", result.getMessage());
	}

	/**
	 * testCreateException05()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFaerrors.requiredL[̃bZ[Warg3ݒ肳Ă邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCreateException05() throws Exception {

		BatchException result = BatchException.createException("errors.range",
				"test1", "10", "20");

		assertNotNull(result);
		assertEquals("test1ɂ1020܂ł͈̔͂œ͂Ă.", result.getMessage());
	}

	/**
	 * testCreateException06()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFerrors.requiredL[̃bZ[Wݒ肳Ă邱ƂmF<br>
	 * mFځFcauseRuntimeExceptionł邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCreateException06() throws Exception {

		BatchException result = BatchException.createException(
				"errors.required", new RuntimeException());

		assertNotNull(result);
		assertEquals("{0}͓͕K{ڂł.", result.getMessage());
		assertEquals("java.lang.RuntimeException", result.getCause().toString());
		
	}

	/**
	 * testCreateException07()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFaerrors.requiredL[̃bZ[Wargݒ肳Ă邱ƂmF<br>
	 * mFځFcauseRuntimeExceptionł邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCreateException07() throws Exception {

		BatchException result = BatchException.createException(
				"errors.required", new RuntimeException(), "test1");

		assertNotNull(result);
		assertEquals("test1͓͕K{ڂł.", result.getMessage());
		assertEquals("java.lang.RuntimeException", result.getCause().toString());
	}

	/**
	 * testCreateException08()<br>
	 * <br>
	 * eXgTvFBatchExceptionCX^XꂽƂmF<br>
	 * <br>
	 * mFځFBatchExceptionnullłȂ<br>
	 * mFځFerrors.rangeL[̃bZ[Warg3ݒ肳Ă邱ƂmF<br>
	 * mFځFcauseRuntimeExceptionł邱ƂmF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCreateException08() throws Exception {

		BatchException result = BatchException.createException("errors.range",
				new RuntimeException(), "test1", "10", "20");

		assertNotNull(result);
		assertEquals("test1ɂ1020܂ł͈̔͂œ͂Ă.", result.getMessage());
		assertEquals("java.lang.RuntimeException", result.getCause().toString());
	}

	/**
	 * testGetLogMessage01()<br>
	 * <br>
	 * eXgTvFԋpꂽObZ[Wł邱ƂmF<br>
	 * <br>
	 * mFځFerrors.requiredL[̃bZ[WObZ[WƂȂĂ邩mF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testGetLogMessage01() throws Exception {

		BatchException exception = BatchException.createException(
				"errors.required", "test1");

		String result = exception.getLogMessage();

		assertEquals("[errors.required] test1͓͕K{ڂł. (\n\ttest1\n)", result);

	}

	/**
	 * testGetMessageId01()<br>
	 * <br>
	 * eXgTvFݒ肳ꂽbZ[WL[bZ[WL[mF<br>
	 * <br>
	 * mFځFerrors.requiredL[̃bZ[W擾ł邩mF<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testGetMessageId01() throws Exception {

		BatchException exception = BatchException.createException(
				"errors.required", "test1");

		String result = exception.getMessageId();

		assertEquals("errors.required", result);

	}

	/**
	 * testGetMessageId02()<br>
	 * <br>
	 * eXgTvFݒ肳ꂽbZ[WL[null̏ꍇAʂnullł邱ƂmF<br>
	 * <br>
	 * mFځFnullł邱<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testGetMessageId02() throws Exception {

		BatchException exception = BatchException.createException(
				null);

		String result = exception.getMessageId();

		assertNull(result);

	}
	

	/**
	 * testGetMessageId03()<br>
	 * <br>
	 * eXgTvFݒ肳ꂽbZ[WL[󕶎̏ꍇAʂ󕶎ł邱ƂmF<br>
	 * <br>
	 * mFځF󕶎ł邱<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testGetMessageId03() throws Exception {

		BatchException exception = BatchException.createException(
				"");

		String result = exception.getMessageId();

		assertEquals("", result);

	}
	
	
}
