/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.executor;

import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import jp.terasoluna.fw.batch.blogic.BLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.exception.handler.ExceptionHandler;
import jp.terasoluna.fw.batch.executor.vo.BLogicResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.batch.message.MessageAccessor;
import jp.terasoluna.fw.batch.util.MessageUtil;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.util.PropertyUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

/**
 * ob`GO[L[^ۃNXB<br>
 * <br>
 * WuNp̃ob`GO[L[^B
 * @see jp.terasoluna.fw.batch.executor.BatchExecutor
 * @see jp.terasoluna.fw.batch.executor.SyncBatchExecutor
 */
public abstract class AbstractBatchExecutor implements BatchExecutor {

    /**
     * O.
     */
    private static Log log = LogFactory.getLog(AbstractJobBatchExecutor.class);

    /**
     * ϐFWuV[PXR[h.
     */
    protected static final String ENV_JOB_SEQ_ID = "JOB_SEQ_ID";

    /**
     * ϐFWuƖR[h.
     */
    protected static final String ENV_JOB_APP_CD = "JOB_APP_CD";

    /**
     * ϐFbean`t@CpX.
     */
    protected static final String ENV_JOB_BEAN_DEFINITION_PATH = "JOB_BEAN_DEFINITION_PATH";

    /**
     * ϐF̍ő.
     */
    protected static final int ENV_JOB_ARG_MAX = 20;

    /**
     * ϐF.
     */
    protected static final String ENV_JOB_ARG_NM = "JOB_ARG_NM";

    /**
     * ϐF1.
     */
    protected static final String ENV_JOB_ARG_NM1 = "JOB_ARG_NM1";

    /**
     * ϐF2.
     */
    protected static final String ENV_JOB_ARG_NM2 = "JOB_ARG_NM2";

    /**
     * ϐF3.
     */
    protected static final String ENV_JOB_ARG_NM3 = "JOB_ARG_NM3";

    /**
     * ϐF4.
     */
    protected static final String ENV_JOB_ARG_NM4 = "JOB_ARG_NM4";

    /**
     * ϐF5.
     */
    protected static final String ENV_JOB_ARG_NM5 = "JOB_ARG_NM5";

    /**
     * ϐF6.
     */
    protected static final String ENV_JOB_ARG_NM6 = "JOB_ARG_NM6";

    /**
     * ϐF7.
     */
    protected static final String ENV_JOB_ARG_NM7 = "JOB_ARG_NM7";

    /**
     * ϐF8.
     */
    protected static final String ENV_JOB_ARG_NM8 = "JOB_ARG_NM8";

    /**
     * ϐF9.
     */
    protected static final String ENV_JOB_ARG_NM9 = "JOB_ARG_NM9";

    /**
     * ϐF10.
     */
    protected static final String ENV_JOB_ARG_NM10 = "JOB_ARG_NM10";

    /**
     * ϐF11.
     */
    protected static final String ENV_JOB_ARG_NM11 = "JOB_ARG_NM11";

    /**
     * ϐF12.
     */
    protected static final String ENV_JOB_ARG_NM12 = "JOB_ARG_NM12";

    /**
     * ϐF13.
     */
    protected static final String ENV_JOB_ARG_NM13 = "JOB_ARG_NM13";

    /**
     * ϐF14.
     */
    protected static final String ENV_JOB_ARG_NM14 = "JOB_ARG_NM14";

    /**
     * ϐF15.
     */
    protected static final String ENV_JOB_ARG_NM15 = "JOB_ARG_NM15";

    /**
     * ϐF16.
     */
    protected static final String ENV_JOB_ARG_NM16 = "JOB_ARG_NM16";

    /**
     * ϐF17.
     */
    protected static final String ENV_JOB_ARG_NM17 = "JOB_ARG_NM17";

    /**
     * ϐF18.
     */
    protected static final String ENV_JOB_ARG_NM18 = "JOB_ARG_NM18";

    /**
     * ϐF19.
     */
    protected static final String ENV_JOB_ARG_NM19 = "JOB_ARG_NM19";

    /**
     * ϐF20.
     */
    protected static final String ENV_JOB_ARG_NM20 = "JOB_ARG_NM20";

    /**
     * ϐFƖXe[^X.
     */
    protected static final String ENV_BLOGIC_APP_STATUS = "BLOGIC_APP_STATUS";

    /**
     * ϐFXe[^X.
     */
    protected static final String ENV_CUR_APP_STATUS = "CUR_APP_STATUS";

    /**
     * VXepqueryDAO`iXe[^XQƁEXVpj擾pL[.
     */
    protected static final String SYSTEM_DATASOURCE_QUERY_DAO = "systemDataSource.queryDAO";

    /**
     * VXepupdateDAO`iXe[^XQƁEXVpj擾pL[.
     */
    protected static final String SYSTEM_DATASOURCE_UPDATE_DAO = "systemDataSource.updateDAO";

    /**
     * VXeptransactionManager`iXe[^XQƁEXVpj擾pL[.
     */
    protected static final String SYSTEM_DATASOURCE_TRANSACTION_MANAGER = "systemDataSource.transactionManager";

    /**
     * ǗpBean`t@CzuNXpX.
     */
    protected static final String BEAN_DEFINITION_ADMIN_CLASSPATH_KEY = "beanDefinition.admin.classpath";

    /**
     * ǗpBean`i{j
     */
    protected static final String BEAN_DEFINITION_DEFAULT = "beanDefinition.admin.default";

    /**
     * ǗpBean`if[^\[Xj
     */
    protected static final String BEAN_DEFINITION_DATASOURCE = "beanDefinition.admin.dataSource";

    /**
     * ƖpBean`t@CzuNXpX.
     */
    protected static final String BEAN_DEFINITION_BUSINESS_CLASSPATH_KEY = "beanDefinition.business.classpath";

    /**
     * Bean`t@C.
     */
    protected static final String PROPERTY_BEAN_FILENAME_SUFFIX = ".xml";

    /**
     * bZ[W\[XANZTBean擾L[.
     */
    protected static final String BEAN_MESSAGE_ACCESSOR_DEFAULT = "messageAccessor.default";

    /**
     * BLogicBeanɕt^ڔ.
     */
    protected static final String DEFAULT_BLOGIC_BEAN_NAME_SUFFIX = "BLogic";

    /**
     * OnhBeanɕt^ڔ.
     */
    protected static final String DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME_SUFFIX = "ExceptionHandler";

    /**
     * ftHg̗OnhBean.
     */
    protected static final String DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME = "defaultExceptionHandler";

    /**
     * AvP[VReLXgNX.
     */
    protected static final String APPLICATION_CONTEXT = "org.springframework.context.support.ClassPathXmlApplicationContext";

    /**
     * ob`̐.
     */
    protected static final int ARGUMENT_COUNT = 20;

    /**
     * NX[_.
     */
    protected static ClassLoader cl = null;

    /**
     * VXepqueryDAO`iXe[^XQƁEXVpj.
     */
    protected QueryDAO sysQueryDAO = null;

    /**
     * VXepupdateDAO`iXe[^XQƁEXVpj.
     */
    protected UpdateDAO sysUpdateDAO = null;

    /**
     * VXeptransactionManager`iXe[^XQƁEXVpj.
     */
    protected PlatformTransactionManager sysTransactionManager = null;

    /**
     * VXepAvP[VReLXg.
     */
    protected ApplicationContext defaultApplicationContext = null;

    /**
     * It's not a good idea to put code that can fail in a class initializer, but for sake of argument, here's how you configure
     * an SQL Map.
     */
    static {
        // NX[_擾iJgXbh̃ReLXgNX[_j
        cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            log.error("Classloader cannot be taken.");
        }
    }

    /**
     * RXgN^
     */
    protected AbstractBatchExecutor() {
        super();
        init();
    }

    /**
     * 
     */
    protected void init() {
        // VXeAppContextName
        initDefaultAppContext();

        // VXeSqlMapClient
        initSystemDatasourceDao();

        // G[bZ[W̏
        initDefaultErrorMessage();
    }

    /**
     * ǗpɗpApplicationContext.
     */
    protected void initDefaultAppContext() {
        // VXeAvP[VReLXg擾
        String defaultAppContextName = getDefaultBeanFileName();
        if (defaultAppContextName == null || "".equals(defaultAppContextName)) {
            log.error("Bean definition default file name is undefined.");
            return;
        }
        defaultApplicationContext = getApplicationContext(defaultAppContextName);
        if (defaultApplicationContext == null) {
            StringBuilder sb = new StringBuilder();
            sb
                    .append("Default application context not found. defaultAppContextName:[");
            sb.append(defaultAppContextName);
            sb.append("]");
            log.error(sb.toString());
            return;
        }
    }

    /**
     * VXeʂŗpDAOBean`t@C擾.
     */
    protected void initSystemDatasourceDao() {
        // AbstractJobBatchExecutorɈړ
    }

    /**
     * G[bZ[W̏.
     */
    protected void initDefaultErrorMessage() {
        if (defaultApplicationContext == null) {
            return;
        }

        // bZ[W\[XANZTBean擾
        String value = PropertyUtil.getProperty(BEAN_MESSAGE_ACCESSOR_DEFAULT);

        if (value == null) {
            if (log.isWarnEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("MessageAccessor bean not found. beanName:[");
                sb.append(value);
                sb.append("]");
                sb.append(" [");
                sb.append(Thread.currentThread().getName());
                sb.append("]");
                log.warn(sb.toString());
            }
            return;
        }

        // bZ[W\[XANZT擾.
        if (defaultApplicationContext.containsBean(value)) {
            MessageAccessor messageAccessor = null;
            try {
                messageAccessor = (MessageAccessor) defaultApplicationContext
                        .getBean(value, MessageAccessor.class);
            } catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("MessageAccessor bean not found. beanName:[");
                    sb.append(value);
                    sb.append("]");
                    log.warn(sb.toString(), e);
                }
            }
            if (messageAccessor != null) {
                MessageUtil.setMessageAccessor(messageAccessor);

                if (log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("MessageAccessor was found. [");
                    sb.append(Thread.currentThread().getName());
                    sb.append("]");
                    log.debug(sb.toString());
                }
            } else {
                if (log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("MessageAccessor not found. [");
                    sb.append(Thread.currentThread().getName());
                    sb.append("]");
                    log.debug(sb.toString());
                }
            }
        } else {
            if (log.isWarnEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("MessageAccessor bean not found. beanName:[");
                sb.append(value);
                sb.append("]");
                sb.append(" [");
                sb.append(Thread.currentThread().getName());
                sb.append("]");
                log.warn(sb.toString());
            }
        }
    }

    /**
     * WupApplicationContext.
     */
    protected ApplicationContext initJobAppContext(String jobAppCd) {
        ApplicationContext context = null;
        String beanFileName = null;

        beanFileName = getBeanFileName(jobAppCd);
        if (log.isDebugEnabled()) {
            log.debug(new StringBuilder("ApplicationContext:[").append(
                    beanFileName).append("]").toString());
        }

        if (beanFileName != null && 0 < beanFileName.length()) {
            context = getApplicationContext(beanFileName);

            if (context == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("ApplicationContext is null. batchBeanFileName:[");
                sb.append(beanFileName);
                sb.append("]");
                log.error(sb.toString());
            }

            if (log.isDebugEnabled()) {
                if (context != null) {
                    log.debug("ApplicationContext is not null.");
                }
            }
        }

        return context;
    }

    /**
     * ApplicationContextN[Y.
     * @param context
     */
    protected void closeApplicationContext(ApplicationContext context) {
        if (context instanceof AbstractApplicationContext) {
            AbstractApplicationContext aac = (AbstractApplicationContext) context;
            aac.close();
            aac.destroy();
        }
    }

    /*
     * (non-Javadoc)
     * @seejp.terasoluna.fw.batch.light.executor.BatchExecutor#executeBatch(jp.
     * terasoluna.fw.batch.light.executor.vo.BatchJobData)
     */
    public BLogicResult executeBatch(BatchJobData jobRecord) {
        BLogicResult result = new BLogicResult();

        // ob`WuR[hf[^BLogicParamɕϊ
        BLogicParam param = convertBLogicParam(jobRecord);
        if (param == null) {
            // ُI
            return result;
        }

        if (log.isDebugEnabled()) {
            log.debug(param.toString());
        }

        // WuƖR[hijNX擾
        String jobAppCd = jobRecord.getJobAppCd();

        // BLogicBean擾
        String blogicBeanName = getBlogicBeanName(jobAppCd);
        if ((blogicBeanName == null || blogicBeanName.length() == 0)) {
            log.error(new StringBuilder("Unregistered batch.(JOB_APP_CD:[")
                    .append(jobRecord.getJobAppCd()).append("])").toString());
            return result;
        }

        // OnhBean擾
        String exceptionHandlerBeanName = getExceptionHandlerBeanName(jobAppCd);
        if ((exceptionHandlerBeanName == null || exceptionHandlerBeanName
                .length() == 0)) {
            log.error(new StringBuilder("Unregistered batch.(JOB_APP_CD:[")
                    .append(jobRecord.getJobAppCd()).append("])").toString());
            return result;
        }

        // Bean`t@C擾
        ApplicationContext context = initJobAppContext(jobAppCd);

        try {
            // ob`s
            if (blogicBeanName != null && 0 < blogicBeanName.length()) {
                // NX
                result = executeBatchClass(blogicBeanName,
                        exceptionHandlerBeanName, param, context);
            }
        } finally {
            // WupApplicationContextN[Y
            closeApplicationContext(context);
        }

        return result;
    }

    /**
     * ob`WuR[hf[^BLogicParamɕϊ
     * @param jobRecord BatchJobData
     * @return BLogicParam
     */
    protected BLogicParam convertBLogicParam(BatchJobData jobRecord) {
        BLogicParam param = new BLogicParam();
        param.setJobSequenceId(jobRecord.getJobSequenceId());
        param.setJobAppCd(jobRecord.getJobAppCd());

        // Rs[
        boolean ret = argumentCopy(jobRecord, param, "JobArgNm");
        if (!ret) {
            // ُI
            return null;
        }
        return param;
    }

    /**
     * ǗpBean`i{jt@C擾B
     * @return ǗpBean`i{jt@C
     */
    protected static String getDefaultBeanFileName() {
        StringBuilder str = new StringBuilder();
        String classpath = PropertyUtil
                .getProperty(BEAN_DEFINITION_ADMIN_CLASSPATH_KEY);
        String beanFileName = PropertyUtil.getProperty(BEAN_DEFINITION_DEFAULT);
        str.append(classpath == null ? "" : classpath);
        str.append(beanFileName == null ? "" : beanFileName);
        if (log.isDebugEnabled()) {
            log.debug("Default bean file:" + str.toString());
        }
        return str.toString();
    }

    /**
     * ǗpBean`if[^\[Xjt@C擾B
     * @return ǗpBean`if[^\[Xjt@C
     */
    protected static String getDataSourceBeanFileName() {
        StringBuilder str = new StringBuilder();
        String classpath = PropertyUtil
                .getProperty(BEAN_DEFINITION_ADMIN_CLASSPATH_KEY);
        String beanFileName = PropertyUtil
                .getProperty(BEAN_DEFINITION_DATASOURCE);
        str.append(classpath == null ? "" : classpath);
        str.append(beanFileName == null ? "" : beanFileName);
        if (log.isDebugEnabled()) {
            log.debug("Default bean file:" + str.toString());
        }
        return str.toString();
    }

    /**
     * <h6>ob`NXs.</h6>
     * @param blogicBeanName rWlXWbNBean
     * @param exceptionHandlerBeanName OnhBean
     * @param param rWlXWbNp[^
     * @param context ReLXg
     * @return sXe[^X
     */
    protected BLogicResult executeBatchClass(String blogicBeanName,
            String exceptionHandlerBeanName, BLogicParam param,
            ApplicationContext context) {
        BLogicResult result = new BLogicResult();
        BLogic blogic = null;
        ExceptionHandler exceptionHandler = null;

        // ApplicationContext擾łȂꍇ
        if (context == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("ApplicationContext is null.");
            log.error(sb.toString());
            return result;
        }

        // rWlXWbNBean݂邩mF
        String findBlogicBeanName = null;
        if (context.containsBean(blogicBeanName)) {
            findBlogicBeanName = blogicBeanName;
        } else if (context.containsBean(Introspector
                .decapitalize(blogicBeanName))) {
            findBlogicBeanName = Introspector.decapitalize(blogicBeanName);
        }

        // rWlXWbÑCX^XBean`擾
        if (findBlogicBeanName != null) {
            try {
                blogic = (BLogic) context.getBean(findBlogicBeanName,
                        BLogic.class);
            } catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("BLogic bean not found. beanName:[");
                sb.append(blogicBeanName);
                sb.append("]");
                log.error(sb.toString(), e);
                return result;
            }
        }

        if (blogic == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("BLogic bean not found. beanName:[");
            sb.append(blogicBeanName);
            sb.append("]");
            log.error(sb.toString());
            return result;
        }

        // OnhBean݂邩mF
        String findExceptionHandlerBeanName = null;
        if (context.containsBean(exceptionHandlerBeanName)) {
            findExceptionHandlerBeanName = exceptionHandlerBeanName;
        } else if (context.containsBean(Introspector
                .decapitalize(exceptionHandlerBeanName))) {
            findExceptionHandlerBeanName = Introspector
                    .decapitalize(exceptionHandlerBeanName);
        }

        // Onh̃CX^XBean`擾
        if (findExceptionHandlerBeanName != null) {
            try {
                exceptionHandler = (ExceptionHandler) context.getBean(
                        findExceptionHandlerBeanName, ExceptionHandler.class);
            } catch (Throwable e) {
                if (log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("ExceptionHandler bean not found. beanName:[");
                    sb.append(exceptionHandlerBeanName);
                    sb.append("]");
                    log.trace(sb.toString(), e);
                }
                // Onh͌ȂĂs
            }
        }

        // ƖʗOnhȂꍇ͋ʗOnh擾
        if (exceptionHandler == null) {
            // ftHg̗Onh̃CX^XBean`擾
            if (context.containsBean(getDefaultExceptionHandlerBeanName())) {
                try {
                    exceptionHandler = (ExceptionHandler) context.getBean(
                            getDefaultExceptionHandlerBeanName(),
                            ExceptionHandler.class);
                } catch (Throwable e) {
                    if (log.isTraceEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb
                                .append("ExceptionHandler bean not found. beanName:[");
                        sb.append(getDefaultExceptionHandlerBeanName());
                        sb.append("]");
                        log.trace(sb.toString(), e);
                    }
                    // Onh͌ȂĂs
                }
            }
        }

        try {
            // BLogic#execute\bhs
            int blogicStatus = blogic.execute(param);

            result.setBlogicStatus(blogicStatus);

        } catch (Throwable e) {
            // Onh݂ꍇ
            if (exceptionHandler != null) {
                // Os
                result.setBlogicStatus(exceptionHandler
                        .handleThrowableException(e));
            }
        }

        return result;
    }

    /**
     * <h6>tB[h(1`20)Rs[.</h6>
     * @param from Rs[CX^X
     * @param to Rs[CX^X
     * @param field tB[h
     * @return Rs[true
     */
    protected boolean argumentCopy(Object from, Object to, String field) {
        for (int i = 1; i <= ARGUMENT_COUNT; i++) {
            // getter\bh
            StringBuilder getterName = new StringBuilder();
            getterName.append("get");
            getterName.append(field);
            getterName.append(i);

            // getters
            String argument = (String) getMethod(from, getterName.toString());

            if (argument != null) {
                // setter\bh
                StringBuilder setterName = new StringBuilder();
                setterName.append("set");
                setterName.append(field);
                setterName.append(i);

                // setters
                boolean ret = setMethod(to, setterName.toString(), argument);
                if (!ret) {
                    // ُI
                    return ret;
                }
            }
        }
        return true;
    }

    /**
     * <h6>p[^ݒ.</h6>
     * @param obj ΏۃCX^X
     * @param methodName \bh
     * @param argument 
     * @return \bhsłtrue
     */
    protected boolean setMethod(Object obj, String methodName, String argument) {

        if (obj == null) {
            log.error("Object is null.");
            return false;
        }

        try {
            // BeanɃp[^ݒ
            Method method = obj.getClass().getMethod(methodName,
                    new Class[] { String.class });
            method.invoke(obj, new Object[] { argument });
        } catch (SecurityException e) {
            log.error("setMethod Error.", e);
            return false;
        } catch (NoSuchMethodException e) {
            log.error("setMethod Error.", e);
            return false;
        } catch (IllegalArgumentException e) {
            log.error("setMethod Error.", e);
            return false;
        } catch (InvocationTargetException e) {
            log.error("setMethod Error.", e);
            return false;
        } catch (IllegalAccessException e) {
            log.error("setMethod Error.", e);
            return false;
        }

        return true;
    }

    /**
     * <h6>p[^ݒ.</h6>
     * @param obj ΏۃCX^X
     * @param methodName \bh
     * @return p[^ݒ肳ꂽIuWFNg
     */
    protected Object getMethod(Object obj, String methodName) {
        Method method = null;
        Object result = null;

        if (obj == null) {
            log.error("Object is null.");
            return null;
        }

        try {
            // Beanp[^擾
            method = obj.getClass().getMethod(methodName, new Class[] {});
            result = method.invoke(obj, new Object[] {});
        } catch (SecurityException e) {
            log.error("getMethod Error.", e);
            return null;
        } catch (NoSuchMethodException e) {
            log.error("getMethod Error.", e);
            return null;
        } catch (IllegalArgumentException e) {
            log.error("getMethod Error.", e);
            return null;
        } catch (IllegalAccessException e) {
            log.error("getMethod Error.", e);
            return null;
        } catch (InvocationTargetException e) {
            log.error("getMethod Error.", e);
            return null;
        }
        return result;
    }

    /**
     * <h6>AvP[VReLXg擾.</h6>
     * @param batchBeanFileName Bean`t@C
     * @return AvP[VReLXg
     */
    protected static ApplicationContext getApplicationContext(
            String... batchBeanFileName) {
        ApplicationContext ctx = null;
        Class<?> clazz = null;
        Constructor<?> constructor = null;
        try {
            // NXǂݍ
            clazz = cl.loadClass(APPLICATION_CONTEXT);
        } catch (ClassNotFoundException e) {
            log.error("ClassNotFoundException", e);
            return null;
        }
        try {
            // RXgN^擾
            Class<?>[] arrClass = new Class[] { String[].class };
            constructor = clazz.getConstructor(arrClass);
        } catch (SecurityException e) {
            log.error("SecurityException", e);
            return null;
        } catch (NoSuchMethodException e) {
            log.error("NoSuchMethodException", e);
            return null;
        }
        try {
            Object[] array = new Object[] { (Object[]) batchBeanFileName };
            // ReLXg̃CX^X
            ctx = (ApplicationContext) constructor.newInstance(array);
            return ctx;
        } catch (IllegalArgumentException e) {
            // Ȃ
            log.warn("bean definition load error.", e);
        } catch (InstantiationException e) {
            // Ȃ
            log.warn("bean definition load error.", e);
        } catch (IllegalAccessException e) {
            // Ȃ
            log.warn("bean definition load error.", e);
        } catch (InvocationTargetException e) {
            // Ȃ
            log.warn("bean definition load error.", e);
        } catch (RuntimeException e) {
            // Ȃ
            log.warn("bean definition load error.", e);
        }

        return ctx;
    }

    /**
     * <h6>Bean`t@C擾.</h6>
     * @param jobAppCd WuAvP[VR[h
     * @return Bean`t@C
     */
    protected String getBeanFileName(String jobAppCd) {
        StringBuilder str = new StringBuilder();

        String classpath = PropertyUtil
                .getProperty(BEAN_DEFINITION_BUSINESS_CLASSPATH_KEY);

        str.append(classpath == null ? "" : classpath);
        str.append(jobAppCd == null ? "" : jobAppCd);
        str.append(PROPERTY_BEAN_FILENAME_SUFFIX);

        return str.toString();
    }

    /**
     * <h6>sBLogicBean擾.</h6>
     * @param jobAppCd WuAvP[VR[h
     * @return BLogicBean
     */
    protected String getBlogicBeanName(String jobAppCd) {
        StringBuilder str = new StringBuilder();

        if (jobAppCd != null && jobAppCd.length() != 0) {
            str.append(jobAppCd);
            str.append(DEFAULT_BLOGIC_BEAN_NAME_SUFFIX);
        }

        return str.toString();
    }

    /**
     * <h6>OnhBean擾.</h6>
     * @param jobAppCd WuAvP[VR[h
     * @return OnhBean
     */
    protected String getExceptionHandlerBeanName(String jobAppCd) {
        StringBuilder str = new StringBuilder();

        if (jobAppCd != null && jobAppCd.length() != 0) {
            str.append(jobAppCd);
            str.append(DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME_SUFFIX);
        }

        return str.toString();
    }

    /**
     * <h6>ftHg̗OnhBean擾.</h6>
     * @return OnhBean
     */
    protected String getDefaultExceptionHandlerBeanName() {
        return DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME;
    }

    /**
     * VXepAvP[VReLXg擾.
     * @return the defaultApplicationContext
     */
    protected ApplicationContext getDefaultApplicationContext() {
        return defaultApplicationContext;
    }

    /**
     * VXepqueryDAO`iXe[^XQƁEXVpj
     * @return the queryDAO
     */
    public QueryDAO getSysQueryDAO() {
        return sysQueryDAO;
    }

    /**
     * VXepupdateDAO`iXe[^XQƁEXVpj
     * @return the updateDAO
     */
    public UpdateDAO getSysUpdateDAO() {
        return sysUpdateDAO;
    }

    /**
     * VXeptransactionManager`iXe[^XQƁEXVpj
     * @return the sysTransactionManager
     */
    public PlatformTransactionManager getSysTransactionManager() {
        return sysTransactionManager;
    }

}
