/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.exception.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Onh̃ftHg.
 */
public class DefaultExceptionHandler implements ExceptionHandler {
    /**
     * Log.
     */
    private static Log logger = LogFactory
            .getLog(DefaultExceptionHandler.class);

    /**
     * ftHgOnh̃^[R[h.
     */
    protected static final int DEFAULT_EXCEPTION_HANDLER_STATUS = 255;

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.batch.light.exception.handler.ExceptionHandler#handleThrowableException(java.lang.Throwable)
     */
    public int handleThrowableException(Throwable e) {
        // WARNOo͂
        if (logger.isWarnEnabled()) {
            logger.warn("An exception occurred.", e);
        }
        // OnhÕXe[^XԂB
        return DEFAULT_EXCEPTION_HANDLER_STATUS;
    }

}
