/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.util.FileUtility;

/**
 * t@CRs[ɍs[eBeBB<br>
 * <br>
 * TERASOLUNAob`t[[NFileUtilityɂRs[sƁAt@CbNA`N1024oCgɂoCgڑɂANFSւ̃t@CRs[ɂĐ\򉻂B<br>
 * ̂߁ANFSgpt@CRs[Ő\oȂꍇ NXɂt@CRs[sƁB
 */
public class FastFileUtility extends FileUtility {

    /**
     * t@CRs[B
     * <p>
     * Rs[̃t@C̃pX󂯎A Rs[̃pXɃt@CRs[B<br>
     * Rs[Ƀt@C݂ꍇA㏑ŃRs[B<br>
     * </p>
     * @param srcFile Rs[̃t@C̃pX
     * @param newFile Rs[̃t@C̃pX
     * @throws t@C@\O
     */
    public static void copyFile(String srcFile, String newFile) {

        if (srcFile == null) {
            throw new FileException("srcFile is null.");
        }
        if (newFile == null) {
            throw new FileException("newFile is null.");
        }

        File srcFileObject = new File(srcFile);
        // Rs[̃pXɃt@C݂ȂꍇAG[𓊂ďIB
        if (!srcFileObject.exists()) {
            throw new FileException(srcFile + " is not exist.");
        }
        File outputFileObject = new File(newFile);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel ic = null;
        FileChannel oc = null;

        try {
            fis = new FileInputStream(srcFileObject);
            fos = new FileOutputStream(outputFileObject);
            ic = fis.getChannel();
            oc = fos.getChannel();
            ic.transferTo(0, ic.size(), oc);
        } catch (IOException e) {
            throw new FileException("File control operation was failed.", e);
        } finally {
            if (oc != null) {
                try {
                    oc.close();
                } catch (IOException e) {
                    // Ȃ.
                }
            }
            if (ic != null) {
                try {
                    ic.close();
                } catch (IOException e) {
                    // Ȃ.
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e) {
                    // Ȃ.
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException e) {
                    // Ȃ.
                }
            }
        }
    }
}
