/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import jp.terasoluna.fw.file.dao.FileLineException;
import jp.terasoluna.fw.file.dao.standard.AbstractFileLineIterator;
import jp.terasoluna.fw.file.dao.standard.ColumnParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainFileLineIterator
extends AbstractFileLineIterator<Object> {
    private char delimiter = (char)44;
    private char encloseChar = '\u0000';
    private int currentLineCount = 0;
    private boolean readTrailer = false;

    public PlainFileLineIterator(String fileName, Class clazz, Map<String, ColumnParser> columnParserMap) {
        super(fileName, clazz, columnParserMap);
        super.init();
    }

    @Override
    public String[] separateColumns(String fileLineString) {
        throw new UnsupportedOperationException("separateColumns(String) isn't supported.");
    }

    @Override
    public String next() {
        if (this.readTrailer) {
            throw new FileLineException("Data part should be called before trailer part.", new IllegalStateException(), this.getFileName(), this.currentLineCount);
        }
        if (!this.hasNext()) {
            throw new FileLineException("The data which can be acquired doesn't exist.", new NoSuchElementException(), this.getFileName(), this.currentLineCount + 1, null, -1);
        }
        ++this.currentLineCount;
        return this.readLine();
    }

    @Override
    public void skip(int skipLines) {
        for (int i = 0; i < skipLines; ++i) {
            if (!this.hasNext()) {
                throw new FileLineException("The data which can be acquired doesn't exist.", new NoSuchElementException(), this.getFileName(), this.currentLineCount + 1);
            }
            this.readLine();
            ++this.currentLineCount;
        }
    }

    @Override
    public List<String> getTrailer() {
        List<String> trailer = super.getTrailer();
        this.readTrailer = true;
        return trailer;
    }

    @Override
    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    public char getEncloseChar() {
        return this.encloseChar;
    }

    @Override
    public int getCurrentLineCount() {
        return this.currentLineCount;
    }

    @Override
    protected boolean isCheckColumnAnnotationCount() {
        return false;
    }
}

