/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_04.blogic;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.toursample.common.TourUVO;
import jp.terasoluna.toursample.common.blogic.PriceCalculateBLogic;
import jp.terasoluna.toursample.common.blogic.ReserveDetailAcquireBLogic;
import jp.terasoluna.toursample.common.dto.PriceCalculateOutput;
import jp.terasoluna.toursample.common.dto.ReserveDetailAcquireInput;
import jp.terasoluna.toursample.common.dto.ReserveDetailAcquireOutput;
import jp.terasoluna.toursample.common.exception.RecordNotFoundException;
import jp.terasoluna.toursample.uc_a01_04.dto.RP_A01_04_01_01Input;
import jp.terasoluna.toursample.uc_a01_04.dto.RP_A01_04_01_01Output;
import jp.terasoluna.toursample.uc_a01_04.exception.CannotCancelException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * \擾NXB<br>
 * 
 * 
 */
public class RP_A01_04_01_01BLogicImpl implements BLogic<RP_A01_04_01_01Input> {

    /**
     * ZoNXB
     */
    private PriceCalculateBLogic priceCalculateBLogic = null;

    /**
     * \擾NX B
     */
    private ReserveDetailAcquireBLogic reserveDetailAcquireBLogic = null;

    /**
     * ZoNX擾B
     * 
     * @return priceCalculateBLogic
     */
    public PriceCalculateBLogic getPriceCalculateBLogic() {

        return this.priceCalculateBLogic;
    }

    /**
     * ZoNXݒ肷B
     * 
     * @param priceCalculateBLogic
     */
    public void setPriceCalculateBLogic(
            PriceCalculateBLogic priceCalculateBLogic) {

        this.priceCalculateBLogic = priceCalculateBLogic;
    }

    /**
     * \擾NX擾B
     * 
     * @return reserveDetailAcquireBLogic
     */
    public ReserveDetailAcquireBLogic getReserveDetailAcquireBLogic() {

        return this.reserveDetailAcquireBLogic;
    }

    /**
     * \擾NXݒ肷B
     * 
     * @param reserveDetailAcquireBLogic
     */
    public void setReserveDetailAcquireBLogic(
            ReserveDetailAcquireBLogic reserveDetailAcquireBLogic) {

        this.reserveDetailAcquireBLogic = reserveDetailAcquireBLogic;
    }

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(RP_A01_04_01_01BLogicImpl.class);

    /**
     * \Aʏ擾B<br>
     * 擾o͒lɃZbgB<br>
     * 
     * @exception RecordNotFoundException
     *                \񂪂ȂꍇB
     * @exception CannotCancelException
     *                Uς݂̏ꍇB
     * @param rp_a01_04_01_01Input
     * @return rWlXWbN̎sʁABLogicResultCX^XB
     */
    public BLogicResult execute(RP_A01_04_01_01Input rp_a01_04_01_01Input) {

        // sʂi[B
        BLogicResult result = new BLogicResult();

        // o͏i[NX𐶐B
        RP_A01_04_01_01Output rp_A01_04_01_01Output = new RP_A01_04_01_01Output();

        // \̃NX𐶐B
        ReserveDetailAcquireInput input = new ReserveDetailAcquireInput();

        // ReserveDetailAcquireInputɗ\ԍi[B
        input.setReserveNo(rp_a01_04_01_01Input.getReserveNo());

        // ڋqi[B
        TourUVO uvo = rp_a01_04_01_01Input.getUSER_VALUE_OBJECT();

        // ReserveDetailAcquireInputɌڋqԍi[B
        input.setCustomerCode(uvo.getCustomerCode());

        // ʏ\擾B
        ReserveDetailAcquireOutput reserveDetail = reserveDetailAcquireBLogic
                .execute(input);

        // \񂪂ȂꍇAOsB
        if (reserveDetail == null) {

            if (log.isErrorEnabled()) {
                log.error("error.common.00008:\񂪌܂B");
            }

            throw new RecordNotFoundException("error.common.00008");
        }

        // cA[̊{B
        int basePrice = reserveDetail.getBasePrice();

        // l̗\lB
        int adultCount = reserveDetail.getAdultCount();

        // qǂ̗\lB
        int childCount = reserveDetail.getChildCount();

        // ʏ藿擾AZoB
        PriceCalculateOutput price = priceCalculateBLogic.execute(basePrice,
                adultCount, childCount);

        // \Ao͒lɃZbgB
        rp_A01_04_01_01Output.setReserveDetail(reserveDetail);
        rp_A01_04_01_01Output.setPrice(price);

        // ʂZbgB
        result.setResultObject(rp_A01_04_01_01Output);
        result.setResultString("success");

        return result;
    }
}