/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.web.RequestUtil;

import org.apache.struts.Globals;
import org.apache.struts.config.ModuleConfig;

/**
 * <p>
 *  <code>ModuleConfig</code> Ɋւ郆[eBeBB
 * </p>
 *
 */
public class ModuleUtil {

    /**
     * NGXgɊ֘A <code>ModuleConfig</code> CX^XԂ܂B
     *
     * @param request NGXg
     * @return ModuleConfigCX^XB̃NGXgnull̏ꍇA
     *     NGXgAT[ubgReLXg烂W[RtBO
     *     擾łȂꍇnullԋpB
     */
    public static ModuleConfig getModuleConfig(HttpServletRequest request) {

        if (request == null) {
            return null;
        }

        //ServletContext擾
        ServletContext application = RequestUtil.getServletContext(request);

        //ModuleConfig擾
        ModuleConfig config =
            (ModuleConfig) request.getAttribute(Globals.MODULE_KEY);

        //NGXgɃW[ꍇ̓ftHgW[Ԃ
        if (config == null) {
            config =
                (ModuleConfig) application.getAttribute(Globals.MODULE_KEY);
        }

        return config;

    }

    /**
     * NGXgɊ֘AW[̃vtBbNXpXԂ܂B
     *
     * @param request NGXg
     * @return W[vtBbNXBrequestnull̏ꍇA
     *     getModuleConfiǧʂnull̏ꍇnullԋpB
     */
    public static String getPrefix(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        ModuleConfig config = getModuleConfig(request);
        //Prefix擾
        String prefix = null;
        if (config != null) {
            prefix = config.getPrefix();
        }
        return prefix;
    }


}
