/*
 * Copyright (c) 2009 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.download.service;

import java.io.File;
import java.util.List;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.thin.functionsample.download.bean.FileDownLoadMenuBean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * t@C폜rWlXWbNB
 *
 * t@C폜B
 *
 */
public class FileDeleteBLogic implements BLogic<FileDownLoadMenuBean> {

    /**
     * \ONXB
     */
    private Log log = LogFactory.getLog(FileDeleteBLogic.class);

    /**
     * QueryDAONXB SpringɂCX^Xݒ肳B
     */
    protected QueryDAO queryDAO = null;

    /**
     * UpdateDAONXB SpringɂCX^Xݒ肳B
     */
    protected UpdateDAO updateDAO = null;

    /**
     * QueryDAOԋpB
     *
     * @return ێQueryDAO
     */
    public QueryDAO getQueryDAO() {
        return queryDAO;
    }

    /**
     * QueryDAOݒ肷B
     *
     * @param queryDAO QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /**
     * UpdateDAOԋpB
     *
     * @return ێUpdateDAO
     */
    public UpdateDAO getUpdateDAO() {
        return updateDAO;
    }

    /**
     * UpdateDAOݒ肷B
     *
     * @param updateDAO UpdateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    /**
     * t@C폜B
     *
     * @see jp.terasoluna.fw.service.thin.BLogic#execute(P)
     */
    public BLogicResult execute(FileDownLoadMenuBean param) {
        BLogicResult result = new BLogicResult();

        // t@C擾
        String fileName = param.getFileName();
        // t@CpX擾
        String filePath = param.getFilePath();

        if (log.isDebugEnabled()) {
            log.debug("fileName:" + fileName);
            log.debug("filePath:" + filePath);
        }

        // 폜⃊Xg擾
        List<FileDownLoadMenuBean> list = queryDAO.executeForObjectList(
                "upload.selectDeleteFile", param);

        if (list != null && list.size() > 0) {
            // 폜Ώۃt@CpX̐
            String fileFullPath = filePath + File.separator + fileName;
            File file = new File(fileFullPath);

            // DB̃t@CXg폜
            int deleteCount = updateDAO.execute("upload.deleteFile", param);

            if (file.exists()) {
                if (deleteCount > 0) {
                    file.delete();
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("file not found:" + fileFullPath);
                }
            }

            result.setResultString("success");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("list is null.");
            }
            result.setResultString("failure");
        }

        return result;
    }

}