/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.blockage.service;

import java.util.Map;

import jp.terasoluna.thin.functionsample.blockage.bean.BlockageParam;
import jp.terasoluna.thin.functionsample.blockage.web.BlockageController;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.thin.BlockageControlFilter;

/**
 * ƖǁAǉsT[rXNX
 * <p>
 * `FbNꂽƖɑ΂ĕǏs
 *
 */
public class BlockageServiceImpl implements BlockageService {
    /**
     * ƖXg擾T[rX
     */
    protected ListBlockageService listBlockageService = null;
    /**
     * listBlockageService擾B
     * @return listBlockageService
     */
    public ListBlockageService getListBlockageService() {
        return listBlockageService;
    }
    /**
     * listBlockageServiceݒ肷B
     * @param listBlockageService listBlockageServiceB
     */
    public void setListBlockageService
                                    (ListBlockageService listBlockageService) {
        this.listBlockageService = listBlockageService;
    }
    /**
     * `FbNꂽƖǂB
     * `FbNĂȂꍇAƖǂJB
     *
     * @param param ǃ`FbN
     * @return ƖǃXgƕǏ
     */
    public Map<String, Object> blockage(BlockageParam param){
        Map<String, Object> list = null;
        String sPropertyUrl  = null;
        String sCount = null;
        String sUCUrl = null;
        boolean bBlockage = false;
        int count = 0;
        int i;
        
        // Rg[擾
        BlockageController controller
                = (BlockageController) 
                    BlockageControlFilter.getBlockageController();
        
        do{
            // T̘AԂB
            sCount = "" + ++count;
            while(sCount.length() < 5 ){
                sCount = "0" + sCount;
            }
            // vpeB擾Bjblockage.A.url
            sPropertyUrl  = "blockage." + sCount + ".url";

            // w肳ꂽL[̃vpeB擾B
            sUCUrl = PropertyUtil.getProperty(sPropertyUrl, "error");
            
            // 擾sAerror擾B
            if(sUCUrl.equals("error")){
                break;
            }else{
                // `FbNĂ邩ǂ`FbNB
                bBlockage = false;
                for(i=0 ; i < param.getChecked().length ; i++){
                    if((count-1) == Integer.parseInt( param.getChecked()[i])){
                        // `FbNĂꍇAbBlockage̒ltrueɐݒ肷B
                        bBlockage = true;
                        break;
                    }
                }
                if(bBlockage){
                    // ƖǏs
                    controller.blockade(sUCUrl);
                }else{
                    // `FbNĂȂꍇA
                    // YURLǂĂ邩ǂ`FbNB
                    if(controller.isBlockaded(sUCUrl)){
                        // ǂĂꍇAJB
                        controller.open(sUCUrl);
                    }
                }
            }
        }while(sUCUrl != null);
        
        // ƖXgƕǏԂ擾B
        list = listBlockageService.getUCList();
        return list;
    }
}
