/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.message;

import java.util.List;

import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

/**
 * DB烁bZ[W\[X擾DBMessageResourceDAO̎NXB
 * {NX́AbZ[W\[Xi[DB猟SQLgpA
 * bZ[W\[XDBMessageIuWFNg̃XgƂĂ܂Ƃ߁AԋpB
 * <br><br>
 * <strong>gp@</strong>
 * <br>
 * ̃NXgpɂ̓AvP[VReLXgNDAOƂ
 * FKvB<br>
 * <br>
 * <strong>ݒ</strong><br>
 * DAO̎NXƂĖ{NXgpꍇABean`t@C
 * ȉ̋LqB<br>
 * <pre>
 * &lt;bean id = &quot;dBMessageResourceDAO&quot;
 *   class = &quot;jp.terasoluna.fw.message.DBMessageResourceDAOImpl&quot;&gt;
 *   &lt;property name = &quot;dataSource&quot;&gt;
 *     &lt;ref bean = &quot;dataSource&quot;&gt;&lt;/ref&gt;
 *   &lt;/property&gt;
 * &lt;/bean&gt;
 * </pre>
 * 
 * <strong></strong><br>
 * &lt;bean&gt;vfidDBMessageResourceDAOw肵A&lt;bean&gt;vf
 * &lt;property&gt;vfɂdataSourceݒ肷B<br> 
 * 
 * <h3>SQLɂ</h3>
 * 
 * DB烁bZ[W\[X擾錟SQLɂ͏l^ĂB
 * ftHǧSQL
 * <pre>SELECT CODE,MESSAGE FROM MESSAGES</pre>
 * łB
 * ftHǧSQLgpꍇADB̃J͈ȉ̒ʂƂȂB<br>
 * e[u = MESSAGES<br>
 * bZ[WR[hi[J = CODE<br>
 * bZ[W{i[J = MESSAGE<br>
 * AftHǧSQLgpꍇAP[Ή͍sȂB
 * P[Ήꍇ́ALASQL̕ύXKvƂȂB
 * 
 * 
 * <h4>SQL̕ύX1</h4>
 * ̕ύX@͌SQL̃tH[}bgɂāAe[uyъeJ
 * ƎɎw肵A{NX̋@\ɂāASQL𐶐@łB̕@
 * {邱ƂŁAȉ̂Ƃ\ɂȂB<br>
 * PDDB̃e[uyъeJ̎RȐݒ<br>
 * QDP[Ή<br>
 * SQL̃tH[}bg
 * <pre>SELECT bZ[WR[h̃J , R[h̃J , R[h̃J, oAgR[h̃J ,bZ[W{̂̃J FROM e[u
 * </pre>
 * e[uyъeJ̑SĂ͈ꕔw肷邱ƂDB̃e[uy
 * JRɐݒoBꕔ̒l݂̂w肵ꍇAw肳ĂȂl
 * LftHǧSQL̒lgpB<br>
 * AR[h̃JAR[h̃JAoAgR[h̃J
 * w肷邵AeJLɂ邱ƂɂÃR[hɂ郍P[
 * ʂ\ƂȂB
 * ̒l͖{NXɎĂeX̃Zb^[𗘗p鎖ŕύXoB
 * <br>
 * <br>
 * <strong>ݒ</strong><br>
 * Bean`t@Cňȉ̂悤ȋLqB<br>
 * e[uyъeJ̑SĂƎɐݒ肷ꍇB
 * 
 * <pre>
 * &lt;bean id = &quot;DBMessageResourceDAO&quot;
 *   class = &quot;jp.terasoluna.fw.message.DBMessageResourceDAOImpl&quot;&gt;
 *     &lt;ref bean = &quot;dataSource&quot;&gt;&lt;/ref&gt;
 *   &lt;/property&gt;
 *   &lt;property name = &quot;tableName&quot;&gt;
 *     &lt;value&gt;DBMESSAGES&lt;/value&gt;
 *   &lt;/property&gt;
 *   &lt;property name = &quot;codeColumn&quot;&gt;
 *     &lt;value&gt;BANGOU&lt;/value&gt;
 *   &lt;/property&gt;
 *   &lt;property name = &quot;languageColumn&quot;&gt;
 *     &lt;value&gt;GENGO&lt;/value&gt;
 *   &lt;/property&gt;
 *   &lt;property name = &quot;countryColumn&quot;&gt;
 *     &lt;value&gt;KUNI&lt;/value&gt;
 *   &lt;/property&gt;
 *   &lt;property name = &quot;variantColumn&quot;&gt;
 *     &lt;value&gt;HOUGEN&lt;/value&gt;
 *   &lt;/property&gt;
 *   &lt;property name = &quot;messageColumn&quot;&gt;
 *     &lt;value&gt;MESSAGE&lt;/value&gt;
 *   &lt;/property&gt;
 * &lt;/bean&gt;
 * </pre>
 * 
 * &lt;bean&gt;vf&lt;properities&gt;vfnameɕύXe[u
 * Jw肵AvalueɂĐݒ肵lw肷B<br>
 * <br>
 * Lݒɂ茟SQL
 * <pre>SELECT BANGOU,GENGO,KUNI,HOUGEN,HONBUN FROM DBMESSAGES</pre>
 * ƂȂB<br>
 * ܂DB̃e[uyуJ͈ȉ̒ʂƂȂB <br>
 * e[u = DBMESSAGES<br>
 * bZ[WR[hi[J = BANGOU<br>
 * bZ[W̌R[hi[J = GENGO<br>
 * bZ[W̍R[hi[J = KUNI<br>
 * bZ[W̃oAgR[hi[J = HOUGEN<br>
 * bZ[W{i[J = HONBUN<br>
 * 
 * 
 * <h4>SQL̕ύX2</h4>
 * ̕ύX@͖{NX̋@\ɂ錟SQL̐s킸ɁASQLƎ
 * Ɏw肷@łBWHEREȂǌSQL̃tH[}bgł͑ΉoȂ
 * NG𗘗pꍇɗLłB<br>
 * <br>
 * <strong>ݒ</strong><br>
 * Bean`t@Cňȉ̂悤ȋLqB
 * SQLyуe[uAeJ̑SĂƎɐݒ肷ꍇB<br>
 * <br>
 * 
 * <pre>
 * &lt;bean id = &quot;DBMessageResourceDAO&quot;
 *   class = &quot;jp.terasoluna.fw.message.DBMessageResourceDAOImpl&quot;&gt;
 *   &lt;property name = &quot;dataSource&quot;&gt;
 *     &lt;ref bean = &quot;dataSource&quot;&gt;&lt;/ref&gt;
 *   &lt;/property&gt;
 *   &lt;property name = &quot;findMessageSql&quot;&gt;
 *     &lt;value&gt;
 *       SELECT BANGOU as CODE,HONBUN as MESSAGE FROM DBDATA WHERE CATEGORY = "DBMESSAGE"
 *     &lt;/value&gt;
 *   &lt;/property&gt;
 * &lt;/bean&gt;
 * </pre>
 * 
 * &lt;bean&gt;vf&lt;properities&gt;vfnameɌSQLƎgp
 * Jw肵AvalueɂĐݒ肵SQLw肷B<br>
 * <br>
 * SQL<br>
 * VKJ as ftHg̃J<br>
 * Ƃ邱ƂDB̃JύX邱ƂoB
 * AftHgŒlnĂ郁bZ[WR[hyуbZ[ŴQJ
 * ݂̂̑ΉƂȂBP[ΉꍇȂ̃Jݒ肷KvB
 * ̏ꍇ͌SQL̕ύX1ɕ킢AJLɂKvB<br>
 * <br>
 * Lݒɂ茟SQL
 * <pre>SELECT BANGOU as CODE,HONBUN as MESSAGE FROM DBDATA WHERE CATEGORY = "DBMESSAGE"
 * </pre>
 * ƂȂB<br>
 * 
 * ܂DB̃e[uyуJ͈ȉ̒ʂƂȂB<br>
 * e[u = DBDATA<br>
 * bZ[WR[hi[J = BANGOU<br>
 * bZ[W̌R[hi[J = null<br>
 * bZ[W̍R[hi[J = null<br>
 * bZ[W̃oAgR[hi[J = null<br>
 * bZ[W{i[J = HONBUN<br>
 * 
 * @see jp.terasoluna.fw.message.DataSourceMessageSource
 * @see jp.terasoluna.fw.message.DBMessage
 * @see jp.terasoluna.fw.message.DBMessageQuery
 * @see jp.terasoluna.fw.message.DBMessageResourceDAO
 * 
 */
public class DBMessageResourceDAOImpl extends JdbcDaoSupport implements
        DBMessageResourceDAO {
    /**
     * bZ[Wi[DB̃e[uBftHgMESSAGESB
     */
    protected String tableName = "MESSAGES";

    /**
     * bZ[WR[hi[DB̃JBftHgCODEB
     */
    protected String codeColumn = "CODE";

    /**
     * R[hi[DB̃JBftHgnullB
     */
    protected String languageColumn = null;

    /**
     * R[hi[DB̃JBftHgnullB
     */
    protected String countryColumn = null;

    /**
     * oAgR[hi[DB̃JBftHgnullB
     */
    protected String variantColumn = null;

    /**
     * bZ[Wi[DB̃JBftHgMESSAGEB
     */
    protected String messageColumn = "MESSAGE";

    /**
     * Oݒ肳DBɎgpSQLB
     * ݒ肳ĂꍇA炪sB
     */
    protected String findMessageSql = null;

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(DBMessageResourceDAOImpl.class);

    /**
     * bZ[Wi[DB̃e[uݒ肷Bݒ肳ĂȂꍇ
     * ftHg̒lMESSAGESgpB
     * 
     * @param tableName
     *            bZ[Wi[DB̃e[uB
     */
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /**
     * bZ[WR[hi[DB̃Jݒ肷Bݒ肳ĂȂꍇ
     * ftHg̒lCODEgpB
     * 
     * @param codeColumn
     *            bZ[WR[hi[DB̃JB
     */
    public void setCodeColumn(String codeColumn) {
        this.codeColumn = codeColumn;
    }

    /**
     * R[hi[DB̃Jݒ肷Bݒ肳ĂȂꍇ
     * ftHg̒lnullgpB
     * 
     * @param languageColumn
     *            R[hi[DB̃JB
     */
    public void setLanguageColumn(String languageColumn) {
        this.languageColumn = languageColumn;
    }

    /**
     * R[hi[DB̃Jݒ肷Bݒ肳ĂȂꍇ
     * ftHg̒lnullgpB
     * 
     * @param countryColumn
     *            R[hi[DB̃JB
     */
    public void setCountryColumn(String countryColumn) {
        this.countryColumn = countryColumn;
    }

    /**
     * oAgR[hi[DB̃Jݒ肷Bݒ肳ĂȂꍇ
     * ftHg̒lnullgpB
     * 
     * @param variantColumn
     *            oAgR[hi[DB̃JB
     */
    public void setVariantColumn(String variantColumn) {
        this.variantColumn = variantColumn;
    }

    /**
     * bZ[Wi[DB̃Jݒ肷Bݒ肳ĂȂꍇ
     * ftHg̒lMESSAGEgpB
     * 
     * @param messageColumn
     *            bZ[Wi[DB̃JB
     */
    public void setMessageColumn(String messageColumn) {
        this.messageColumn = messageColumn;
    }

    /**
     * DB烁bZ[W\[XSQLݒ肷Bݒ肳ĂȂꍇ
     * makeSql\bhɂč쐬ꂽSQLsB
     * 
     * @param findMessageSql
     *            Oݒ肳DBɎgpSQLB
     */
    public void setFindMessageSql(String findMessageSql) {
        this.findMessageSql = findMessageSql;
    }

    /**
     * bZ[W\[X擾RDBMSIy[VNXB
     */
    protected DBMessageQuery dBMessageQuery = null;
    
    /**
     * DBMessageResourceDAOImpl𐶐B
     */
    protected DBMessageResourceDAOImpl() {
        super();
    }

    /**
     * DB胁bZ[W\[X擾DBMessageQuery𐶐B
     * RXgN^ɓnl̂AbZ[WR[h̃JA
     * R[h̃JAR[h̃Jnull̏ꍇB<br>
     * nullnꂽꍇÃJDBɑ݂Ȃ̂ƂďB
     * 
     * @throws IllegalArgumentException
     *             DBƂ̐ڑ擾łȂꍇ
     */
    @Override
    protected void initDao() {
        DataSource dataSource = getDataSource();
        if (dataSource == null) {
            log.error("Missing dataSource in spring configuration file.");
            throw new IllegalArgumentException("Missing dataSource in spring"
                    + " configuration file.");
        }
        this.dBMessageQuery = new DBMessageQuery(dataSource, makeSql(),
                codeColumn, languageColumn, countryColumn, variantColumn,
                messageColumn);
    }

    /**
     * DB擾bZ[W\[XDBMessageIuWFNgɊi[AXg^
     * ŕԋpB
     * 
     * @return bZ[W\[X̃Xg
     */
    @SuppressWarnings("unchecked")
    public List<DBMessage> findDBMessages() {
        // JDBCDaoSupportɂDBMessageQueryK邽߁A
        // nullɂ͂ȂȂB
        return dBMessageQuery.execute();
    }

    /**
     * DB烁bZ[W\[X擾SQL𐶐B
     * SQLOɃJyуe[uɕsȒlnĂȂ
     * `FbNBK{JibZ[WR[hAbZ[W{́j
     * ƃe[unull`FbNyы󕶎`FbN{B
     * ̑̃J͋󕶎`FbN݂̂{B
     * 
     * @return DB烁bZ[W\[X擾SQLB
     *          null͕ԋpȂB
     * 
     */
    protected String makeSql() {
        // J`FbN
        checkRequiredColumnName(codeColumn, "codeColumn");
        checkNotRequiredColumnName(languageColumn, "languageColumn");
        checkNotRequiredColumnName(countryColumn, "countryColumn");
        checkNotRequiredColumnName(variantColumn, "variantColumn");
        checkRequiredColumnName(messageColumn, "messageColumn");
        checkRequiredColumnName(tableName, "tableName");
        // OSQLw肳ꂽꍇAgpB
        StringBuilder sql = null;
        if (findMessageSql != null) {
            sql = new StringBuilder(findMessageSql);
        } else {
            // SQL̎w肪ȂꍇAVɐB
            sql = new StringBuilder("SELECT ");
            sql.append(codeColumn);
            sql.append(",");
            // R[h̃JAݒ肳ĂȂꍇ
            // R[hȂB
            if (languageColumn != null) {
                sql.append(languageColumn);
                sql.append(",");
            }
            // R[h̃JAݒ肳ĂȂꍇ͍R[hȂB
            if (countryColumn != null) {
                sql.append(countryColumn);
                sql.append(",");
            }
            // oAgR[h̃JAݒ肳ĂȂꍇ
            // oAgR[hȂB
            if (variantColumn != null) {
                sql.append(variantColumn);
                sql.append(",");
            }
            sql.append(messageColumn);
            sql.append(" FROM ");
            sql.append(tableName);
        }
        if (log.isDebugEnabled()) {
            log.debug("sql=[" + sql + "]");
        }
        return sql.toString();
    }

    /**
     * K{J̃Jyуe[u`FbNB
     * null`FbNyы󕶎`FbN{B
     * 
     * @param value
     *            DBł̃J̓e[u
     * @param columnName
     *            Ώۂ̃J̓e[u
     */
    protected void checkRequiredColumnName(String value, String columnName) {
        // J̃G[`FbNB
        // bZ[WR[h̃Jnull͋󕶎̏ꍇAG[ԂB
        if (value == null || "".equals(value)) {
            log.error("illegalArgument: " + columnName + " is null or empty.");
            throw new IllegalArgumentException("illegalArgument: " + columnName
                    + " is null or empty.");
        }
    }

    /**
     * K{JȊÕJ`FbNB 󕶎`FbN{B
     * 
     * @param value
     *            DBł̃J
     * @param columnName
     *            Ώۂ̃J
     */
    protected void checkNotRequiredColumnName(String value, String columnName) {
        // J̃G[`FbNB
        // bZ[WR[h̃J󕶎̏ꍇAG[ԂB
        if ("".equals(value)) {
            log.error("illegalArgument: " + columnName + " is empty.");
            throw new IllegalArgumentException("illegalArgument: " + columnName
                    + " is empty.");
        }
    }
}
