/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.util.StringUtil;
import jp.terasoluna.fw.web.RequestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionFilter
implements Filter {
    public static final String EXTENSION_THRU_KEY = "EXTENSION_THRU_KEY";
    public static final String RESTRICTION_ESCAPE_PREFIX = "restrictionEscape.";
    private static Log log = LogFactory.getLog(ExtensionFilter.class);
    private static final String PROHIBITED_EXTENSION_PREFIX = "access.control.prohibited.extension.";
    private List<String> prohibitedExtensionList = new ArrayList<String>();
    private List<String> restrictionEscapePaths = new ArrayList<String>();

    public void init(FilterConfig config) throws ServletException {
        String extensionCheckEscapePath;
        String extension;
        int i = 1;
        while ((extension = PropertyUtil.getProperty(PROHIBITED_EXTENSION_PREFIX + i)) != null) {
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("prohibitedExtension:" + extension));
            }
            this.prohibitedExtensionList.add(extension);
            ++i;
        }
        i = 1;
        while ((extensionCheckEscapePath = PropertyUtil.getProperty(RESTRICTION_ESCAPE_PREFIX + i)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("extensionCheckEscapePath:[" + extensionCheckEscapePath + "]"));
            }
            this.restrictionEscapePaths.add(extensionCheckEscapePath);
            ++i;
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(EXTENSION_THRU_KEY) == null) {
            String extension;
            req.setAttribute(EXTENSION_THRU_KEY, (Object)"true");
            String pathInfo = RequestUtil.getPathInfo(req);
            if (pathInfo != null && !this.restrictionEscapePaths.contains(pathInfo) && this.prohibitedExtensionList.contains(extension = StringUtil.getExtension(pathInfo))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("requestURI[" + pathInfo + "] has prohibited extension"));
                }
                ((HttpServletResponse)res).sendError(404);
                return;
            }
        }
        chain.doFilter(req, res);
    }

    public void destroy() {
    }
}

