/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * JtH[}bg(t@CjsNXB
 * <p>
 * t@CsIuWFNgf[^擾AFileUpdateDAOɕԋpB Ame[V̋Lqɏ]Date^̃tH[}bgsB
 * </p>
 */
public class DecimalColumnFormatter implements ColumnFormatter {

    /**
     * ltH[}bgɑΉ<code>DecimalFormat</code>ێ}bvB
     */
    private Map<String, DecimalFormatLocal> dfMap = new ConcurrentHashMap<String, DecimalFormatLocal>();

    /**
     * BigDecimal^̃tH[}bgsAԋpB
     * <p>
     * <code>columnFormat</code><code>null</code>́A 󕶎ꍇ́AtH[}bgƂĕԋpB
     * @param t t@CsIuWFNg
     * @param method JtH[}bgs̃Qb^\bh
     * @param columnFormat JtH[}bgp̕
     * @return 
     * @throws IllegalArgumentException t@CsIuWFNggetter\bh̃ANZXɎsƂ
     * @throws IllegalAccessException t@CsIuWFNgւ̐ݒ肪sƂ
     * @throws InvocationTargetException t@CsIuWFNg̃\bhOX[Ƃ
     */
    public String format(Object t, Method method, String columnFormat)
                                                                      throws IllegalArgumentException,
                                                                      IllegalAccessException,
                                                                      InvocationTargetException {

        Object column = method.invoke(t);

        // Jlnull̏ꍇ͋󕶎ԂB
        if (column == null) {
            return "";
        }

        // l̃tH[}bg
        if (columnFormat != null && !"".equals(columnFormat)) {
            DecimalFormatLocal dfLocal = dfMap.get(columnFormat);
            if (dfLocal == null) {
                dfLocal = new DecimalFormatLocal(columnFormat);
                dfMap.put(columnFormat, dfLocal);
            }
            return dfLocal.get().format(column);
        } else {
            return BigDecimal.class.cast(column).toPlainString();
        }

    }
}
