/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.partition;

import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * L[NXB
 * 
 * <p>Cӂ̌^̕L[<code>WorkQueue</code>ɓ邽߂ɃbvB</p>
 * 
 * <p>L[Ԗڂ̃L[ł邩ێB</p>
 * 
 */
public class PartitionRowObject implements WorkUnit {

    /**
     * L[ԍBL[Ԗڂ̃L[ł邩B
     */
    private int partitionNo = 0;

    /**
     * L[B
     */
    private Object partitionKey = null;

    /**
     * WuReNXgB
     */
    private JobContext jobContext = null;

    /**
     * RXgN^B
     * 
     * @param partitionNo L[ԍ
     * @param partitionKey L[
     * @param jobContext WuReNXg
     */
    public PartitionRowObject(int partitionNo, Object partitionKey,
            JobContext jobContext) {
        this.partitionNo = partitionNo;
        this.partitionKey = partitionKey;
        this.jobContext = jobContext;
    }

    /**
     * L[擾B
     * 
     * @return L[
     */
    public Object getRowObject() {
        return partitionKey;
    }

    /**
     * L[ԍ擾B
     * 
     * @return L[ԍ
     */
    public int getPartitionNo() {
        return partitionNo;
    }

    /**
     * ̃IuWFNgL[̍Ō̃IuWFNgłł邩ԂB
     * 
     * @return ̃NXł͏ <code>false</code> ԂB
     */
    public boolean isEndMark() {
        return false;
    }

    /**
     * WuReNXg擾B
     * 
     * @return WuReNXg
     */
    public JobContext getJobContext() {
        return jobContext;
    }
    
    /**
     * WuReNXgݒ肷B
     * 
     * @param jobContext WuReNXg
     */
    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }
}
