/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * `NNXB
 * 
 * <p>rWlXWbN̓̓f[^ƂȂIuWFNg萔
 * i邢͓̃[ɏ]ājێReiNXłA
 * {@link JobWorker} ̓͂ƂȂB</p>
 * 
 * <p>Wusۂ̏PʂłAgUNVA
 * ob`XVvZbT{@link BatchUpdateProcessor} ɂob`XVȂǂ̒Pʂ
 * ȂB</p>
 * 
 * <p>`Nf[^Ŏw肷鏈f̃Wȕꍇɂ́AWuBean`
 * t@CɂĈȉ̂悤ȐݒsƂŃ`NTCY̎wsƂ
 * łB</p>
 * 
 * <p><strong>ݒ</strong></p>
 * <pre><code>
 *  &lt;!-- `NTCY̎w --&gt;
 *  &lt;bean id="chunkSize" class="java.lang.Integer"&gt;
 *      &lt;constructor-arg>&lt;value>50&lt;/value&gt;&lt;/constructor-arg&gt;
 *  &lt;/bean&gt;
 * </code></pre>
 * 
 * <p>WuBean`t@CɂāA`NTCYw肵Ȃꍇɂ́A
 * t[[NBean`t@Cɐݒ肳Ă`NTCYgpB
 * </p>
 * 
 */
public class Chunk implements Iterable, WorkUnit {

    /**
     * f[^i[郊XgB
     */
    private List<Object> data = null;

    /**
     * WuReNXgB
     */
    private JobContext jobContext = null;
    
    /**
     * RXgN^B<p>
     * œnꂽ`NTCYpăf[^i[郊XgIuWFNg
     * B<p>
     * chunkSizeɕnƁA<code>IllegalArgumentException</code>
     * X[B
     *
     * @param chunkSize `NTCY 0ȏ̐
     * @param jobContext WuReNXg
     */
    public Chunk(int chunkSize, JobContext jobContext) {
        this.data = new ArrayList<Object>(chunkSize);
        this.jobContext = jobContext;
    }

    /**
     * RXgN^B<p>
     * datavf̂Ȃ<code>ArrayList</code>ŏA
     * jobContext<code>null</code>ŏB
     */
    public Chunk() {
        this.data = new ArrayList<Object>();
        this.jobContext = null;
    }

    /**
     * `NTCỸTCY擾B
     *
     * @return `NTCY
     */
    public int size() {
        return data.size();
    }

    /**
     * `NɃf[^ǉB
     *
     * @param obj ǉΏۂ̃f[^
     */
    public void add(Object obj) {
        data.add(obj);
    }

    /**
     * `NŕێĂf[^̔qԂB
     *
     * @return q
     */
    public Iterator<Object> iterator() {
        return data.iterator();
    }
    
    /**
     * `N̏I[ł邩]B
     *
     * @return ]
     */
    public boolean isEndMark() {
        return false;
    }

    /**
     * WuReNXg擾B
     * 
     * @return ̃`NɊ֘AtĂWuReNXg
     */
    public JobContext getJobContext() {
        return jobContext;
    }

    /**
     * WuReNXgݒ肷B
     * 
     * @param jobContext ̃`NƊ֘AtWuReNXg
     */
    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }
}
