/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.view.velocity;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.web.servlet.view.velocity.VelocityView;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.servlet.view.velocity.
 * VelocityViewResolverEx} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * GR[fBOw肪\VelocityViewResolvergNXB<br>
 * OFbuidlView\bḧviewNameɂ͋󕶎ANull͓ȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.view.velocity.
 * VelocityViewResolverEx
 */
public class VelocityViewResolverExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(VelocityViewResolverExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public VelocityViewResolverExTest(String name) {
        super(name);
    }

    /**
     * testGetEncoding01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.encoding:not null<br>
     *                (htext/xml;charset=UTF-8h)<br>
     *         
     * <br>
     * ҒlF(߂l) String:OŎw肵this.encoding̒lB<br>
     *         
     * <br>
     * encodingget\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetEncoding01() throws Exception {
        // O
        VelocityViewResolverEx viewResolver = new VelocityViewResolverEx();
        String encoding = "text/xml;charset=UTF-8";
        UTUtil.setPrivateField(viewResolver, "encoding", encoding);

        // eXg{
        Object result = viewResolver.getEncoding();

        // 
        assertEquals(encoding, result);
    }

    /**
     * testSetEncoding01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() encoding:not null<br>
     *                (htext/xml;charset=UTF-8h)<br>
     *         () this.encoding:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.encoding:Őݒ肵lݒ肳ĂB<br>
     *         
     * <br>
     * encodingset\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetEncoding01() throws Exception {
        // O
        VelocityViewResolverEx viewResolver = new VelocityViewResolverEx();
        UTUtil.setPrivateField(viewResolver, "encoding", null);

        // eXg{
        String encoding = "text/xml;charset=UTF-8";
        viewResolver.setEncoding(encoding);

        // 
        Object result = UTUtil.getPrivateField(viewResolver, "encoding");
        assertEquals(encoding, result);
    }

    /**
     * testBuildView01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() viewName:hsumh<br>
     *         () this.encoding:not null<br>
     *         
     * <br>
     * ҒlF(߂l) AbstractUrlBasedView:
     *         Oencodingݒ肳ꂽVelocityr[<br>
     *         (ԕω) super.buildView():
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * Velocityr[̐neXgBGR[fBOw肳Ă邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBuildView01() throws Exception {
        // O
        VelocityViewResolverEx viewResolver = new VelocityViewResolverEx();
        String encoding = "text/xml;charset=UTF-8";
        UTUtil.setPrivateField(viewResolver, "encoding", encoding);

        // eXg{
        String viewName = "sum";
        Object result = viewResolver.buildView(viewName);

        // 
        assertTrue(result instanceof VelocityView);
        VelocityView resultView = (VelocityView) result;
        assertEquals(encoding, UTUtil.getPrivateField(resultView, "encoding"));
        assertEquals(viewName, UTUtil.getPrivateField(resultView, "url"));
    }

    /**
     * testBuildView02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() viewName:hsumh<br>
     *         () this.encoding:null<br>
     *         
     * <br>
     * ҒlF(߂l) AbstractUrlBasedView:
     *         Oencodingݒ肳ꂽVelocityr[<br>
     *         (ԕω) super.buildView():
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * Velocityr[̃GR[fBONull̏ꍇ̃eXgB
     * GR[fBONullVelocityr[쐬B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBuildView02() throws Exception {
        // O
        VelocityViewResolverEx viewResolver = new VelocityViewResolverEx();
        UTUtil.setPrivateField(viewResolver, "encoding", null);

        // eXg{
        String viewName = "sum";
        Object result = viewResolver.buildView(viewName);

        // 
        assertTrue(result instanceof VelocityView);
        VelocityView resultView = (VelocityView) result;
        assertEquals(null, UTUtil.getPrivateField(resultView, "encoding"));
        assertEquals(viewName, UTUtil.getPrivateField(resultView, "url"));
    }

    /**
     * testBuildView03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() viewName:hsumh<br>
     *         () this.encoding:not null<br>
     *                i󕶎j<br>
     *         
     * <br>
     * ҒlF(߂l) AbstractUrlBasedView:
     *         Oencodingݒ肳ꂽVelocityr[<br>
     *         (ԕω) super.buildView():
     *         \bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * Velocityr[̃GR[fBO󕶎̏ꍇ̃eXgB
     * GR[fBO󕶎Velocityr[쐬B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBuildView03() throws Exception {
        // O
        VelocityViewResolverEx viewResolver = new VelocityViewResolverEx();
        String encoding = "";
        UTUtil.setPrivateField(viewResolver, "encoding", encoding);

        // eXg{
        String viewName = "sum";
        Object result = viewResolver.buildView(viewName);

        // 
        assertTrue(result instanceof VelocityView);
        VelocityView resultView = (VelocityView) result;
        assertEquals(encoding, UTUtil.getPrivateField(resultView, "encoding"));
        assertEquals(viewName, UTUtil.getPrivateField(resultView, "url"));
    }

}
